/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class DirectoryClassLoader
extends URLClassLoader {
    static URL[] dirToJarUrls(File dir) throws IOException {
        if (dir.isDirectory()) {
            File[] jars = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.length() >= 4 && name.substring(name.length() - 4).equals(".jar");
                }
            });
            URL[] urls = new URL[jars.length];
            try {
                int i = 0;
                while (i < jars.length) {
                    urls[i] = jars[i].toURI().toURL();
                    ++i;
                }
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
            return urls;
        }
        throw new IOException("Provided file isn't directory.");
    }

    public DirectoryClassLoader(File directory) throws IOException {
        super(DirectoryClassLoader.dirToJarUrls(directory));
    }
}

