/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.utils.Settings;
import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class Config {
    public static final boolean LOG_TO_CONSOLE = false;
    public static final String PYTHON_PATH = "python.path";
    public static final String PYTHON_PATH_DELIMITER = File.pathSeparator;
    protected static String PROJECTS_DIR = "projects";

    static {
        Config.stopLoggingToConsole();
    }

    public static void stopLoggingToConsole() {
        Logger actual = Logger.getAnonymousLogger();
        Logger previous = null;
        while (!actual.equals(previous)) {
            Handler[] handlers;
            Handler[] handlerArray = handlers = actual.getHandlers();
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                if (h instanceof ConsoleHandler) {
                    actual.removeHandler(h);
                }
                ++n2;
            }
            previous = actual;
            if ((actual = actual.getParent()) != null) continue;
        }
    }

    private Config() {
    }

    public static String getPlatformPath() {
        return (String)Settings.get(Settings.Setting.PLATFORM_DIR);
    }

    public static String getProjectsPath() {
        return String.valueOf(Config.getPlatformPath()) + File.separator + PROJECTS_DIR;
    }

    public static String getPythonModulePath() {
        return String.valueOf(Config.getPlatformPath()) + File.separator + "scripting" + File.separator + "python";
    }

    public static String getJythonJarPath() {
        return String.valueOf(Config.getPlatformPath()) + File.separator + "scriptEngines" + File.separator + "jython.jar";
    }

    public static String fixPythonPath(String path) {
        StringBuffer sb = new StringBuffer(path.length() + 5);
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '\\') {
                sb.append('\\');
                sb.append('\\');
            } else {
                sb.append(path.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

