/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.utils.Config;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class BotProjectsClassLoader
extends URLClassLoader {
    public BotProjectsClassLoader() {
        super(BotProjectsClassLoader.getUrlsOfBotJars(new File(Config.getProjectsPath())), ClassLoader.getSystemClassLoader());
    }

    public BotProjectsClassLoader(ClassLoader parent) {
        super(BotProjectsClassLoader.getUrlsOfBotJars(new File(Config.getProjectsPath())), parent);
    }

    public BotProjectsClassLoader(File projectsDir, ClassLoader parent) {
        super(BotProjectsClassLoader.getUrlsOfBotJars(projectsDir), parent);
    }

    public static URL[] getUrlsOfBotJars(File rootDir) {
        if (rootDir == null) {
            return new URL[0];
        }
        File[] projectDirs = rootDir.listFiles();
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        File[] fileArray = projectDirs;
        int n = projectDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File potencialProjectDir = fileArray[n2];
            List<URL> urls = BotProjectsClassLoader.getBotJar(potencialProjectDir);
            if (urls != null) {
                jarUrls.addAll(urls);
            }
            ++n2;
        }
        return jarUrls.toArray(new URL[0]);
    }

    public static List<URL> getBotJar(File projectDir) {
        String[] files;
        ArrayList<URL> urls = new ArrayList<URL>();
        File potencialJar = new File(projectDir, "dist" + File.separator + projectDir.getName() + ".jar");
        if (potencialJar.exists()) {
            try {
                urls.add(potencialJar.toURI().toURL());
                return urls;
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        if ((files = new File(projectDir, "dist").list()) == null) {
            return urls;
        }
        int index = 0;
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            index = file.lastIndexOf(46);
            if (index != -1 && file.substring(index + 1, file.length()).equals("jar")) {
                try {
                    urls.add(new File(String.valueOf(projectDir.getAbsolutePath()) + File.separator + "dist" + File.separator + file).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return urls;
    }

    public String toString() {
        return "BotPorjectsClassLoader instance";
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> retValue = super.findClass(name);
        return retValue;
    }

    public static void main(String[] args) {
        BotProjectsClassLoader cl = new BotProjectsClassLoader();
        Class<?> hunter = null;
        try {
            hunter = cl.loadClass("hunter.Main");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + e.getMessage());
            System.exit(1);
        }
        try {
            Agent agent = (Agent)hunter.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            System.exit(1);
        }
        System.out.println("Agent loaded...");
    }
}

