/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.sposhBot.python;

import cz.cuni.pogamut.Client.ScriptedAgent;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.exceptions.ScriptedAgentException;
import cz.cuni.utils.Config;
import cz.cuni.utils.ExceptionToString;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.script.ScriptException;

public class SPoshBot
extends ScriptedAgent {
    protected String pathToJythonJar = Config.getJythonJarPath() == null ? ".\\scripting\\jython.jar" : Config.fixPythonPath(Config.getJythonJarPath());
    protected String pathToSPOSH = Config.getPythonModulePath() == null ? ".\\scripting\\python" : Config.getPythonModulePath();
    protected String pyFileName = null;
    protected String sposhPlanFile = null;
    protected String pathToPogamutCore;

    public SPoshBot(String pyFileName, String sposhPlanFileName, String pathToSPOSH, String pathToJythonJar, String pathToPogamutCore) throws ScriptedAgentException {
        String string = this.pathToPogamutCore = Config.getPlatformPath() == null ? ".\\libs\\" : Config.fixPythonPath(String.valueOf(Config.getPlatformPath()) + "\\libs\\PogamutCore.jar");
        if (pathToSPOSH != null) {
            this.pathToSPOSH = pathToSPOSH;
        }
        if (pathToJythonJar != null) {
            this.pathToJythonJar = pathToJythonJar;
        }
        if (pathToPogamutCore != null) {
            this.pathToPogamutCore = pathToPogamutCore;
        }
        this.pyFileName = pyFileName;
        this.sposhPlanFile = sposhPlanFileName;
        this.init();
    }

    public SPoshBot(String pyFileName, String sposhPlanFileName) throws ScriptedAgentException {
        this(pyFileName, sposhPlanFileName, null, null, null);
    }

    public SPoshBot(String pyFileName, String sposhPlanFileName, String pathToPogamutCore) throws ScriptedAgentException {
        this(pyFileName, sposhPlanFileName, null, null, pathToPogamutCore);
    }

    @Override
    protected void engineIsGoingToBeBinded() {
        Properties prop = System.getProperties();
        String property = prop.getProperty("python.path");
        if (property == null) {
            prop.setProperty("python.path", this.pathToSPOSH);
        } else if (!property.contains(this.pathToSPOSH)) {
            prop.setProperty("python.path", String.valueOf(property) + Config.PYTHON_PATH_DELIMITER + this.pathToSPOSH);
        }
    }

    protected void init() throws ScriptedAgentException {
        if (this.pathToSPOSH == null) {
            throw new IllegalArgumentException("Path to SPOSH module is null.");
        }
        if (this.pathToJythonJar == null) {
            throw new IllegalArgumentException("Path to JythonJar is null.");
        }
        if (this.pyFileName == null) {
            throw new IllegalArgumentException("Path to '.py' file with logic is null.");
        }
        if (this.sposhPlanFile == null) {
            throw new IllegalArgumentException("Path to '.lap' file with SPOSH plan is null.");
        }
        if (!new File(this.pathToSPOSH).exists()) {
            throw new IllegalArgumentException("SPOSH module not found. Normaly it should reside under $POGAMUT_PLATFORM/scripting/python/");
        }
        if (!new File(this.pathToJythonJar).exists()) {
            throw new IllegalArgumentException("Directory with jython.jar not found. Normaly it should points to $POGAMUT_PLATFORM/scriptEngines/");
        }
        this.bindEngineByName("python");
        try {
            this.engine.eval("import sys");
            this.engine.eval("sys.path.append('" + this.pathToJythonJar + "')");
            if (this.pathToJythonJar != null) {
                this.engine.eval("sys.path.append('" + this.pathToPogamutCore + "')");
            }
            this.setAttribute("userDir", System.getProperty("user.dir"));
        }
        catch (ScriptException e) {
            throw new ScriptedAgentException("Can't set Python paths to SPOSH or Jython.jar or pogamut core jar, can't initialize.", e);
        }
        this.bindScriptFile(this.pyFileName);
    }

    @Override
    protected void doLogic() {
        if (!this.memory.hasSelf()) {
            return;
        }
        try {
            this.invocableEngine.invokeMethod(this.engine.getContext().getAttribute("sposhAgent"), "followDrive", null);
        }
        catch (ScriptException e) {
            this.platformLog.severe("Script error -> " + e.getMessage());
            this.stopAgentSoft();
        }
        catch (NoSuchMethodException e) {
            this.platformLog.severe("Script error -> " + e.getMessage());
            this.stopAgentSoft();
        }
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
        super.postPrepareAgent();
        try {
            this.setAttribute("platformLog", this.platformLog);
            this.engine.eval("platformLog.info('Python path: '+ str(sys.path))");
            try {
                this.engine.eval("from sposh.agent import Agent");
            }
            catch (Exception e) {
                this.platformLog.warning("Evaluation 'from sposh.agent import Agent' failed.");
                this.platformLog.severe(ExceptionToString.process(e));
            }
            this.engine.eval("sposhAgent = Agent(getBehaviours(), '" + this.sposhPlanFile + "', platformLog)");
            this.engine.eval("sposhAgentCreated()");
        }
        catch (ScriptException e) {
            this.platformLog.severe("Can't instantiate POSH agent -> " + e.getMessage());
            throw new PogamutException(e.getMessage());
        }
    }

    public static void main(String[] Args) {
        String userdir = System.getProperty("user.dir");
        SPoshBot bot = null;
        try {
            bot = new SPoshBot("d:\\programming\\workspaces\\Pogamut\\Core\\src\\cz\\cuni\\sposhBot\\python\\exampleSPoshBot.py", "d:\\programming\\workspaces\\Pogamut\\Core\\src\\cz\\cuni\\sposhBot\\python\\exampleSPoshBotPlan.lap");
        }
        catch (ScriptedAgentException e2) {
            e2.printStackTrace();
            System.exit(1);
        }
        URI uri = null;
        try {
            uri = new URI("ut://artemis.ms.mff.cuni.cz:3000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("URI creation failed, terminating.");
            System.exit(0);
        }
        bot.log.getParent().removeHandler(bot.log.getParent().getHandlers()[0]);
        bot.log.getParent().addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.println(String.valueOf(record.getSourceClassName()) + " " + record.getSourceMethodName() + ": " + record.getMessage());
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        });
        try {
            bot.bindLocalParser(uri);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
            System.exit(1);
        }
        catch (ConnectException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        bot.startAgent();
    }
}

