/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.sposhBot.java.examples;

import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MyBehaviour
extends JavaBehaviour {
    protected Item choosenItem = null;
    protected Item previousChoosenItem = null;
    public ArrayList<Item> itemsToRunAround = new ArrayList();
    public ArrayList<Item> medkitsToRunAround = null;
    protected boolean jumped = true;
    protected boolean medsRestart = true;

    public MyBehaviour(String name, Logger log, SPoshBot bot) {
        super(name, log, bot);
    }

    public void action_rearm() {
        this.log.info("Action REARM.");
        AddWeapon weapon = this.bot.getMemory().getBetterWeapon(this.bot.getMemory().getSeeEnemy().location, this.bot.getMemory().getAgentLocation());
        this.bot.getBody().changeWeapon(weapon);
    }

    public void action_engageEnemy() {
        this.log.info("Action ENGAGE_ENEMY.");
        this.medsRestart = true;
        this.bot.getBody().shoot(this.bot.getMemory().getSeeEnemy());
    }

    public void action_runAroundCloseMeds() {
        this.log.info("Action RUN_AROUND_CLOSE_MEDS.");
        this.bot.getMap().runAroundItemsInTheMap(this.medkitsToRunAround, false);
    }

    @Override
    public void action_runAroundItems() {
        this.log.info("Action RUN_AROUND_ITEMS.");
        this.bot.getMap().runAroundItemsInTheMap(this.itemsToRunAround, false);
    }

    public void action_runToItem() {
        this.log.info("Action RUN_TO_ITEM.");
        if (!this.bot.getMap().safeRunToLocation(this.choosenItem.location)) {
            this.log.info("unable to REACH the choosen item");
            this.previousChoosenItem = this.choosenItem;
            this.choosenItem = null;
        }
    }

    public void action_stopShooting() {
        this.log.info("Action STOP_SHOOTING.");
        this.bot.getBody().stopShoot();
    }

    public void action_jump() {
        this.log.info("Action JUMP.");
        if (this.bot.getMemory().isColliding()) {
            if (!this.jumped) {
                this.bot.getBody().jump();
                this.jumped = true;
            } else {
                this.bot.getBody().stop();
                this.jumped = false;
            }
        }
        if (this.bot.getMemory().isFalling()) {
            this.bot.getBody().sendGlobalMessage("I am flying like a bird:D!");
            this.log.info("I'm flying like an angel to the sky ... it's so high ... oh, I am high! :-)");
        }
        if (this.bot.getMemory().isBumpingToAnotherActor()) {
            this.bot.getBody().stop();
        }
    }

    @Override
    public boolean sense_fail() {
        return false;
    }

    @Override
    public boolean sense_succeed() {
        return true;
    }

    public boolean sense_stucked() {
        return this.bot.getMemory().isColliding();
    }

    public boolean sense_isShooting() {
        return this.bot.getMemory().isShooting();
    }

    public boolean sense_hasBetterWeapon() {
        Triple botLoc = this.bot.getMemory().getAgentLocation();
        Player enemy = this.bot.getMemory().getSeeEnemy();
        if (enemy == null || enemy.location == null) {
            return false;
        }
        AddWeapon candidate = this.bot.getMemory().getBetterWeapon(botLoc, enemy.location);
        return candidate != null;
    }

    public int sense_health() {
        return this.bot.getMemory().getAgentHealth();
    }

    public boolean sense_knowMedkits() {
        if (this.medsRestart) {
            this.medkitsToRunAround = null;
        }
        if (this.medkitsToRunAround != null) {
            return true;
        }
        ArrayList<Item> healths = this.bot.getMap().nearestHealth(15, 4);
        if (healths == null || healths.size() < 2) {
            return false;
        }
        this.medkitsToRunAround = healths;
        return true;
    }

    public boolean sense_armed() {
        return this.bot.getMemory().hasAnyLoadedWeapon();
    }

    public boolean sense_seeEnemy() {
        return this.bot.getMemory().getSeeAnyEnemy();
    }

    public boolean sense_seeItemAndWantIt() {
        return this.seeAnyReachableItemAndWantIt();
    }

    private Weapon chooseWeapon() {
        ArrayList<Weapon> weapons = this.bot.getMemory().getSeeReachableWeapons();
        for (Weapon weapon : weapons) {
            if (this.bot.getMemory().getCurrentWeapon() == null) {
                return weapon;
            }
            if (this.bot.getMemory().getCurrentWeapon().melee && !weapon.isMelee() && !this.bot.getMemory().hasWeaponOfType(weapon.weaponType)) {
                return weapon;
            }
            if (this.bot.getMemory().getCurrentWeapon().melee || !weapon.isMelee() || this.bot.getMemory().hasWeaponOfType(weapon.weaponType)) continue;
            return weapon;
        }
        Weapon chosen = this.bot.getMemory().getSeeReachableWeapon();
        if (!this.bot.getMemory().hasWeaponOfType(chosen.weaponType)) {
            return chosen;
        }
        return null;
    }

    private Item chooseItem() {
        if (this.bot.getMemory().getSeeAnyReachableWeapon()) {
            return this.chooseWeapon();
        }
        if (this.bot.getMemory().getSeeAnyReachableArmor()) {
            return this.bot.getMemory().getSeeReachableArmor();
        }
        if (this.bot.getMemory().getSeeAnyReachableHealth()) {
            Health health = this.bot.getMemory().getSeeReachableHealth();
            if (this.bot.getMemory().getAgentHealth() < 100) {
                return health;
            }
            if (health.boostable) {
                return health;
            }
        }
        if (this.bot.getMemory().getSeeAnyReachableAmmo() && this.bot.getMemory().isAmmoSuitable(this.bot.getMemory().getSeeReachableAmmo())) {
            return this.bot.getMemory().getSeeReachableAmmo();
        }
        return null;
    }

    private boolean seeAnyReachableItemAndWantIt() {
        if (this.bot.getMemory().getSeeAnyReachableItem()) {
            this.choosenItem = this.chooseItem();
            if (this.choosenItem != null) {
                this.log.info("NEW ITEM CHOSEN: " + this.choosenItem);
                this.log.info("LAST CHOOSEN ITEM: " + this.previousChoosenItem);
            }
        } else {
            this.choosenItem = null;
        }
        return this.choosenItem != null && !this.choosenItem.equals(this.previousChoosenItem);
    }
}

