/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.server;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.GameInfo;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.UTMap;
import cz.cuni.pogamut.Parser.GameBotConnection;
import cz.cuni.pogamut.communication.CommunicationState;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.server.BotEnteredWorldListener;
import cz.cuni.pogamut.server.BotLeftWorldListener;
import cz.cuni.pogamut.server.ParserType;
import cz.cuni.pogamut.server.UTServerConnection;
import cz.cuni.pogamut.server.UTServerConnectionInterface;
import cz.cuni.pogamut.server.UTServerInfoSnapshot;
import cz.cuni.pogamut.server.UTServerState;
import cz.cuni.pogamut.server.UTWorld;
import cz.cuni.pogamut.server.requests.ConfigurationParameter;
import cz.cuni.pogamut.server.requests.UTServerRequest;
import cz.cuni.pogamut.server.requests.UTServerRequestConfigChange;
import cz.cuni.pogamut.server.requests.UTServerRequestInventory;
import cz.cuni.pogamut.server.requests.UTServerRequestItems;
import cz.cuni.pogamut.server.requests.UTServerRequestMaps;
import cz.cuni.pogamut.server.requests.UTServerRequestNavPoints;
import cz.cuni.pogamut.server.requests.UTServerRequestPlayers;
import cz.cuni.pogamut.server.requests.UTServerRequestReconnect;
import cz.cuni.utils.Flag;
import cz.cuni.utils.FlagListener;
import cz.cuni.utils.Settings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class UTServer
implements UTWorld,
Serializable,
FlagListener,
UTServerConnectionInterface {
    private transient Logger log = null;
    private transient Logger rawGBLog = null;
    private transient UTServerConnection connection = null;
    private transient Set<BotEnteredWorldListener> botEnteredWorldListeners = null;
    private transient Set<BotLeftWorldListener> botLeftWorldListeners = null;
    protected UTServerInfoSnapshot info = new UTServerInfoSnapshot();
    protected transient CountDownLatch waitNavPoints = null;
    protected transient CountDownLatch waitItems = null;
    protected transient CountDownLatch waitMaps = null;
    protected transient CountDownLatch waitRefreshInfo = null;
    protected transient CountDownLatch waitInventory = null;
    protected GameBotConnection gbConn = null;
    protected Socket gbSocket = null;
    protected PrintWriter writer = null;

    public UTServer() {
        this.init();
    }

    protected void init() {
        this.botEnteredWorldListeners = new HashSet<BotEnteredWorldListener>();
        this.botLeftWorldListeners = new HashSet<BotLeftWorldListener>();
        this.log = Logger.getAnonymousLogger();
        this.log.setLevel(Level.ALL);
        this.rawGBLog = Logger.getAnonymousLogger();
        this.rawGBLog.setLevel(Level.ALL);
        this.info.serverStateFlag = new Flag<UTServerState>(UTServerState.NONE);
        this.info.serverStateFlag.addListener(this);
        this.connection = new UTServerConnection(this);
        Float freq = (Float)Settings.get(Settings.Setting.SERVER_UPDATE_FREQUENCY);
        int millis = (int)(1000.0f / freq.floatValue());
        this.setPongTimeoutMillis(millis);
        this.setAutoReconnectMillis(millis);
    }

    public void connect() {
        this.connection.connect();
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    public String toString() {
        String adr = null;
        adr = this.info.gamebotsControlConnectionURI == null ? "" : this.info.gamebotsControlConnectionURI.toString();
        return String.valueOf(this.info.name) + " (" + adr + ")";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public boolean request(UTServerRequest request) {
        return this.connection.request(request);
    }

    @Override
    public Flag<UTServerState> getServerStateFlag() {
        return this.info.serverStateFlag;
    }

    @Override
    public UTServerState getServerState() {
        return this.info.serverStateFlag.getFlag();
    }

    @Override
    public boolean isAutomaticallyReconnect() {
        return this.info.automaticallyReconnect;
    }

    public void setAutomaticallyReconnect(boolean automaticallyReconnect) {
        this.info.automaticallyReconnect = automaticallyReconnect;
        this.connection.request(new UTServerRequestConfigChange(ConfigurationParameter.AUTO_RECONNECT, new Boolean(this.info.automaticallyReconnect)));
    }

    public boolean getAutomaticallyReconnect() {
        return this.info.automaticallyReconnect;
    }

    public UTServerConnection getConnection() {
        return this.connection;
    }

    public void setConnection(UTServerConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isPingPong() {
        return this.info.pingPong;
    }

    public void setPingPong(boolean pingPong) {
        this.info.pingPong = pingPong;
        this.connection.request(new UTServerRequestConfigChange(ConfigurationParameter.PING_CONNECTION, new Boolean(this.info.pingPong)));
    }

    public boolean getPingPong() {
        return this.info.pingPong;
    }

    @Override
    public int getPongTimeoutMillis() {
        return this.info.pongTimeoutMillis;
    }

    public void setPongTimeoutMillis(int pongTimeoutMillis) {
        this.info.pongTimeoutMillis = pongTimeoutMillis;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public URI getGamebotsControlConnectionURI() {
        return this.info.gamebotsControlConnectionURI;
    }

    public URI getGamebotsBotsURI() {
        return this.info.gamebotsBotsURI;
    }

    public void setGamebotsControlConnectionURI(URI serverURI) {
        this.info.gamebotsControlConnectionURI = serverURI;
        if (serverURI == null) {
            this.connection.disconnect();
        } else {
            this.connection.request(new UTServerRequestConfigChange(ConfigurationParameter.URI, serverURI));
            if (!this.connection.isThreadAlive()) {
                this.connection.connect();
            }
        }
    }

    public void setGamebotsBotURI(URI serverURI) {
        this.info.gamebotsBotsURI = serverURI;
    }

    public void setServerRemoteParserURI(URI serverURI) {
        this.info.serverRemoteParserURI = serverURI;
    }

    public URI getServerRemoteParserURI() {
        return this.info.serverRemoteParserURI;
    }

    @Override
    public int getAutoReconnectMillis() {
        return this.info.autoReconnectMillis;
    }

    public void setAutoReconnectMillis(int autoReconnectMillis) {
        this.info.autoReconnectMillis = autoReconnectMillis;
    }

    @Override
    public Logger getRawGBLog() {
        return this.rawGBLog;
    }

    @Override
    public GameInfo getGameInfo() {
        return this.info.gameInfo;
    }

    @Override
    public void setGameInfo(GameInfo info) {
        this.info.gameInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flagChanged(Object changedValue, int listenerParam) {
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            switch ((UTServerState)((Object)changedValue)) {
                case UNAVAILABLE: 
                case TERMINATED: {
                    if (this.waitItems != null) {
                        this.waitItems.countDown();
                    }
                    if (this.waitMaps != null) {
                        this.waitMaps.countDown();
                    }
                    if (this.waitNavPoints != null) {
                        this.waitNavPoints.countDown();
                    }
                    if (this.waitRefreshInfo == null) break;
                    this.waitRefreshInfo.countDown();
                }
            }
        }
    }

    public void terminate() {
        this.connection.terminate();
    }

    public void finalize() {
        this.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshInformations() {
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            block9: {
                if (this.getServerState() == UTServerState.RUNNING || this.getServerState() == UTServerState.PAUSED) break block9;
                return false;
            }
            if (this.waitRefreshInfo == null) {
                this.waitRefreshInfo = new CountDownLatch(1);
            } else if (this.waitRefreshInfo.getCount() == 0L) {
                this.waitRefreshInfo = new CountDownLatch(1);
            }
        }
        this.request(new UTServerRequestPlayers());
        try {
            this.waitRefreshInfo.await();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public void reconnect() {
        this.request(new UTServerRequestReconnect());
    }

    public boolean waitForCommunication() {
        if (this.info.gamebotsControlConnectionURI == null) {
            return false;
        }
        if (this.info.gamebotsControlConnectionURI.equals(this.connection.getCurrentURI())) {
            return true;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        Flag<UTServerState> flag = this.getServerStateFlag();
        FlagListener<UTServerState> listener = new FlagListener<UTServerState>(){

            @Override
            public void flagChanged(UTServerState changedValue, int listenerParam) {
                switch (changedValue) {
                    case RUNNING: 
                    case PAUSED: {
                        latch.countDown();
                        break;
                    }
                    case UNAVAILABLE: 
                    case TERMINATED: {
                        latch.countDown();
                    }
                }
            }
        };
        flag.addListener(listener);
        if (this.getServerState() == UTServerState.RUNNING || this.getServerState() == UTServerState.PAUSED) {
            flag.removeListener(listener);
            return true;
        }
        if (this.getServerState() == UTServerState.NONE || this.getServerState() == UTServerState.UNAVAILABLE) {
            this.reconnect();
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        flag.removeListener(listener);
        return this.getServerState() == UTServerState.RUNNING || this.getServerState() == UTServerState.PAUSED;
    }

    public synchronized Set<Player> getPlayers() {
        return this.info.players;
    }

    public void addRcvMsgListener(RcvMsgListener listener) {
        this.connection.addRcvMsgListener(listener);
    }

    public void removeRcvMsgListener(RcvMsgListener listener) {
        this.connection.removeRcvMsgListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UTServerInfoSnapshot getSnapshot() {
        UTServerInfoSnapshot uTServerInfoSnapshot = this.info;
        synchronized (uTServerInfoSnapshot) {
            return (UTServerInfoSnapshot)this.info.clone();
        }
    }

    public boolean isServerOpened() {
        return this.info.serverOpened;
    }

    public void setServerOpened(boolean opened) {
        this.info.serverOpened = opened;
    }

    public void setName(String name) {
        this.info.name = name;
    }

    @Override
    public boolean isConnectionAlive() {
        switch (this.getServerState()) {
            case NONE: 
            case INITIALIZING: 
            case UNAVAILABLE: 
            case TERMINATED: {
                return false;
            }
            case HANDSHAKE: 
            case RUNNING: 
            case PAUSED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public String getMap() {
        if (this.info.gameInfo == null) {
            return null;
        }
        return this.info.gameInfo.level;
    }

    @Override
    public boolean setMap(String name) throws PogamutException {
        return this.connection.changeMap(name);
    }

    @Override
    public boolean setMapAndWait(String name) throws PogamutException {
        return this.connection.changeMapAndWait(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<UTMap> getAvailableMaps() {
        if (this.info.maps != null) {
            return this.info.maps;
        }
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.waitMaps == null) {
                this.waitMaps = new CountDownLatch(1);
            } else if (this.waitMaps.getCount() == 0L) {
                this.waitMaps = new CountDownLatch(1);
            }
            this.request(new UTServerRequestMaps());
        }
        try {
            this.waitMaps.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.info.maps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<NavPoint> getNavPoints() throws PogamutException {
        if (this.info.navPoints != null) {
            return this.info.navPoints;
        }
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.waitNavPoints == null) {
                this.waitNavPoints = new CountDownLatch(1);
            } else if (this.waitNavPoints.getCount() == 0L) {
                this.waitNavPoints = new CountDownLatch(1);
            }
            this.request(new UTServerRequestNavPoints());
        }
        try {
            this.waitNavPoints.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.info.navPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<Item> getItems() {
        if (this.info.items != null) {
            return this.info.items;
        }
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.waitItems == null) {
                this.waitItems = new CountDownLatch(1);
            } else if (this.waitItems.getCount() == 0L) {
                this.waitItems = new CountDownLatch(1);
            }
            this.request(new UTServerRequestItems());
        }
        try {
            this.waitItems.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.info.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Item> getInventory() {
        if (this.info.inventory != null) {
            return this.info.inventory;
        }
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.waitInventory == null) {
                this.waitInventory = new CountDownLatch(1);
            } else if (this.waitInventory.getCount() == 0L) {
                this.waitInventory = new CountDownLatch(1);
            }
            this.request(new UTServerRequestInventory());
        }
        try {
            this.waitInventory.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.info.inventory;
    }

    @Override
    public Collection<Player> getAllBots() throws PogamutException {
        return this.info.players;
    }

    @Override
    public synchronized Collection<Agent> getConnectedBots() {
        return this.info.bots;
    }

    @Override
    public String connectBot(Agent newBot) throws PogamutException {
        return this.connectBot(newBot, newBot.getName());
    }

    public String connectBot(Agent newBot, ParserType parserType) throws PogamutException {
        this.connectBot(newBot, newBot.getName(), parserType);
        return newBot.getName();
    }

    @Override
    public String connectBot(Agent bot, String botName) throws PogamutException {
        this.connectBot(bot, botName, this.getPreferredParserType());
        return bot.getName();
    }

    private ParserType getPreferredParserType() {
        Preferences pref = Preferences.userNodeForPackage(Agent.class);
        ParserType parserType = null;
        String parserTypeStr = pref.get("PreferredParserType", "REMOTE");
        parserType = parserTypeStr.equals("REMOTE") && this.getServerRemoteParserURI() != null ? ParserType.REMOTE : ParserType.LOCAL;
        return parserType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectBot(final Agent bot, String botName, ParserType parserType) throws PogamutException {
        try {
            switch (parserType) {
                case LOCAL: {
                    bot.bindLocalParser(this.info.gamebotsBotsURI);
                    break;
                }
                case REMOTE: {
                    try {
                        bot.bindRemoteParser(this.info.gamebotsBotsURI);
                        break;
                    }
                    catch (ConnectException ex) {
                        ex.printStackTrace();
                        this.log.severe("Can't connect bot to remote server (" + this.info.serverRemoteParserURI.toString() + ") using local parser.");
                        bot.bindLocalParser(this.info.gamebotsBotsURI);
                    }
                }
            }
        }
        catch (ConnectException ex) {
            ex.printStackTrace();
            throw new PogamutException("Connection refused.", ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new PogamutException("Cant write/read to socket.", ex);
        }
        List<Agent> ex = this.info.bots;
        synchronized (ex) {
            this.info.bots.add(bot);
        }
        bot.startAgent(botName);
        Thread startThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (BotEnteredWorldListener listener : UTServer.this.botEnteredWorldListeners) {
                    listener.botEnteredWorld(bot);
                }
            }
        }, "Notifying agent enetered world (UTServer.connectBot())");
        startThread.start();
    }

    @Override
    public void connectOriginalBot(String name, Triple location, int difficultyLevel, int team) throws PogamutException {
        if (difficultyLevel > 7) {
            difficultyLevel = 7;
        }
        if (difficultyLevel < 1) {
            difficultyLevel = 1;
        }
        this.connection.sendCommandToGB("ADDBOT {Name " + name + "}" + "{StartLocation " + location.toString() + "}" + "{StartRotation 0,0,65000}" + "{Skill " + difficultyLevel + "}" + "{Team " + team + "}");
    }

    @Override
    public void respawnBot(String botUnrealId) throws PogamutException {
        this.connection.sendCommandToGB("RESPAWN {Id " + botUnrealId + "}");
    }

    @Override
    public void respawnBot(String botUnrealId, Triple location) throws PogamutException {
        this.connection.sendCommandToGB("RESPAWN {Id " + botUnrealId + "}{Location " + location.toString() + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kickBot(String botUnrealId) throws PogamutException {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            for (Agent bot : this.info.bots) {
                if (!bot.getMemory().getAgentUnrealID().equals(botUnrealId)) continue;
                this.disconnectBot(bot);
                return;
            }
        }
        this.connection.sendCommandToGB("KICK {Id " + botUnrealId + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectBot(String botUnrealId) {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            for (Agent bot : this.info.bots) {
                if (!bot.getMemory().getAgentUnrealID().equals(botUnrealId)) continue;
                this.disconnectBot(bot);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectAllBots() {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            for (Agent bot : this.info.bots) {
                bot.disconnect();
            }
        }
    }

    @Override
    public void pause(boolean completely) throws PogamutException {
        if (completely) {
            this.connection.sendCommandToGB("PAUSE {PauseBots False} {PauseAll True}");
        } else {
            this.connection.sendCommandToGB("PAUSE {PauseBots True} {PauseAll False}");
        }
    }

    @Override
    public void resume() throws PogamutException {
        this.connection.sendCommandToGB("PAUSE {PauseBots False} {PauseAll False}");
    }

    @Override
    public void addInventory(String botUnrealId, String inventoryClass) throws PogamutException {
        this.connection.sendCommandToGB("ADDINV {Id " + botUnrealId + "}{Class " + inventoryClass + "}");
    }

    @Override
    public void changeAttribute(String botUnrealId, String attribute, String value) throws PogamutException {
        if (attribute.equals("Health")) {
            int health = Integer.parseInt(value);
            if (health < 1) {
                health = 1;
            }
            if (health > 199) {
                health = 199;
            }
            this.connection.sendCommandToGB("CHATTR {Health " + health + "}");
        }
    }

    @Override
    public void botInvulnerable(String botUnrealId, boolean invulnerable) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{Invulnerable " + (invulnerable ? "True" : "False") + "}");
    }

    @Override
    public void botAutoTrace(String botUnrealId, boolean autoTrace) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{AutoTrace " + (autoTrace ? "True" : "False") + "}");
    }

    @Override
    public void botManualSpawn(String botUnrealId, boolean manualSpawn) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{ManualSpawn " + (manualSpawn ? "True" : "False") + "}");
    }

    public void botShowDebug(String botUnrealId, boolean showDebug) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{ShowDebug " + (showDebug ? "True" : "False") + "}");
    }

    public void botShowFocalPoint(String botUnrealId, boolean showFocalPoint) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{ShowFocalPoint " + (showFocalPoint ? "True" : "False") + "}");
    }

    public void botDrawTraceLines(String botUnrealId, boolean drawTraceLines) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{DrawTraceLines " + (drawTraceLines ? "True" : "False") + "}");
    }

    public void botSynchronousOff(String botUnrealId, boolean synchronousOff) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{SynchronousOff " + (synchronousOff ? "True" : "False") + "}");
    }

    @Override
    public void setBotName(String botUnrealId, String name) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{Name " + name + "}");
    }

    @Override
    public void setVisionTime(double visionTime) throws PogamutException {
        if (visionTime < 0.1) {
            visionTime = 0.1;
        }
        if (visionTime > 2.0) {
            visionTime = 2.0;
        }
        this.connection.sendCommandToGB("CONF {VisionTime " + visionTime + "}");
    }

    @Override
    public void setGameSpeed(double speed) throws PogamutException {
        if (speed < 0.1) {
            speed = 0.1;
        }
        if (speed > 40.0) {
            speed = 40.0;
        }
        this.info.gameInfo.gameSpeed = speed;
        this.connection.sendCommandToGB("SETGAMESPEED {Speed " + speed + "}");
    }

    @Override
    public void startRecording(String fileName) throws PogamutException {
        this.connection.sendCommandToGB("REC {Filename " + fileName + "}");
    }

    @Override
    public void stopRecording() throws PogamutException {
        this.connection.sendCommandToGB("STOPREC");
    }

    @Override
    public void addBotEnteredWorldListener(BotEnteredWorldListener listener) {
        this.botEnteredWorldListeners.add(listener);
    }

    @Override
    public void removeBotEnteredWorldListener(BotEnteredWorldListener listener) {
        this.botEnteredWorldListeners.remove(listener);
    }

    @Override
    public void addBotLeftWorldListener(BotLeftWorldListener listener) {
        this.botLeftWorldListeners.add(listener);
    }

    @Override
    public void removeBotLeftWorldListener(BotLeftWorldListener listener) {
        this.botLeftWorldListeners.remove(listener);
    }

    @Override
    public void disconnectBot(Agent bot) {
        bot.disconnect();
        for (BotLeftWorldListener listener : this.botLeftWorldListeners) {
            listener.botLeftWorld(bot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBot(Agent bot) {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            this.removeBotInner(bot);
        }
    }

    protected void removeBotInner(Agent bot) {
        if (!CommunicationState.getEndStates().contains((Object)bot.getCommunicationState())) {
            this.disconnectBot(bot);
        }
        this.info.bots.remove(bot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBots() {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            while (this.info.bots.size() != 0) {
                this.removeBotInner(this.info.bots.get(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Agent> removeDisconnectedBots() {
        Collection<Agent> toBeRemoved = this.getDisconnectedBots();
        List<Agent> list = this.info.bots;
        synchronized (list) {
            this.info.bots.removeAll(toBeRemoved);
        }
        return toBeRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Agent> getDisconnectedBots() {
        HashSet<Agent> col = new HashSet<Agent>();
        List<Agent> list = this.info.bots;
        synchronized (list) {
            for (Agent bot : this.info.bots) {
                if (!CommunicationState.getEndStates().contains((Object)bot.getCommunicationState())) continue;
                col.add(bot);
            }
        }
        return col;
    }

    @Override
    public UTServerInfoSnapshot getInfo() {
        return this.info;
    }

    @Override
    public CountDownLatch getWaitNavPointsLatch() {
        return this.waitNavPoints;
    }

    @Override
    public CountDownLatch getWaitItemsLatch() {
        return this.waitItems;
    }

    @Override
    public CountDownLatch getWaitMapsLatch() {
        return this.waitMaps;
    }

    @Override
    public CountDownLatch getWaitInventoryLatch() {
        return this.waitInventory;
    }

    @Override
    public CountDownLatch getWaitRefreshInfoLatch() {
        return this.waitRefreshInfo;
    }

    @Override
    public MessageType getExpectedWelcomeMessage() {
        return MessageType.HELLO_CONTROL_SERVER;
    }

    @Override
    public boolean waitForNFOMessageInHandshake() {
        return true;
    }

    @Override
    public Class loadAgentClass(String fullyClassifiedClassName) throws PogamutException {
        throw new PogamutException("Not supported right now.");
    }

    @Override
    public Agent loadAgent(String fullyClassifiedClassName) throws PogamutException {
        try {
            Class cl = this.loadAgentClass(fullyClassifiedClassName);
            return (Agent)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PogamutException("Can't instantiate agent '" + fullyClassifiedClassName + "'.", e);
        }
    }

    protected GameBotConnection getGBConnection() throws UnknownHostException, ConnectException {
        if (this.gbConn == null) {
            this.gbConn = new GameBotConnection(this.getGamebotsControlConnectionURI().getHost(), this.getGamebotsControlConnectionURI().getPort());
            this.gbConn.connect();
        }
        return this.gbConn;
    }

    public void sendToGB(String msg) throws IOException, CantWriteException, ConnectException {
        this.connection.sendCommandToGB(msg);
    }

    public static void main(String[] args) {
        System.getProperties().setProperty("java.vendor", "ik");
        URI uri = null;
        try {
            uri = new URI("ut://localhost");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            System.exit(1);
        }
        UTServer server = new UTServer();
        server.setGamebotsControlConnectionURI(uri);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        server.disconnect();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        server.connect();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            server.setMapAndWait("DM-Flux2");
        }
        catch (PogamutException e) {
            e.printStackTrace();
        }
    }
}

