/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import cz.cuni.pogamut.experiments.Experiment;
import cz.cuni.pogamut.experiments.ExperimentExecutionState;
import cz.cuni.pogamut.experiments.TimeProvider;
import cz.cuni.pogamut.experiments.TimerTask;
import cz.cuni.utils.FlagListener;
import java.util.Comparator;
import java.util.PriorityQueue;

public class Timer {
    protected final PriorityQueue<TimerTask> queue = new PriorityQueue<TimerTask>(10, new Comparator<TimerTask>(){

        @Override
        public int compare(TimerTask o1, TimerTask o2) {
            long i = o1.scheduledSimulationTime - o2.scheduledSimulationTime;
            if (i == 0L) {
                return 0;
            }
            return i < 0L ? -1 : 1;
        }
    });
    private Object threadReaper = new Object(){

        protected void finalize() throws Throwable {
            Timer.this.stopTimer();
        }
    };
    protected TimerThread executionThread = null;
    protected TimeProvider timeProvider = null;

    public Timer(Experiment experiment) {
        this.timeProvider = experiment.getTimeProvider();
        experiment.getExperimentExecutionFlag().addListener(new FlagListener<ExperimentExecutionState>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flagChanged(ExperimentExecutionState changedValue, int listenerParam) {
                if (changedValue != null && changedValue.isRunning()) {
                    PriorityQueue<TimerTask> priorityQueue = Timer.this.queue;
                    synchronized (priorityQueue) {
                        Timer.this.queue.notify();
                    }
                }
            }
        });
        this.executionThread = new TimerThread(this.queue, experiment.getTimeProvider());
        this.executionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TimerTask task, long delay) {
        task.scheduledSimulationTime = this.timeProvider.getSimulationTime() + delay;
        PriorityQueue<TimerTask> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.offer(task);
            if (this.queue.peek() == task) {
                this.queue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        PriorityQueue<TimerTask> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.executionThread.newTasksMayBeScheduled = false;
            this.queue.notify();
        }
    }

    class TimerThread
    extends Thread {
        protected PriorityQueue<TimerTask> queue = null;
        boolean newTasksMayBeScheduled = true;
        protected TimeProvider timeProvider = null;

        public TimerThread(PriorityQueue<TimerTask> queue, TimeProvider timeProvider) {
            this.queue = queue;
            this.timeProvider = timeProvider;
            this.setName("Timer thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.mainLoop();
            }
            catch (Throwable throwable) {
                PriorityQueue<TimerTask> priorityQueue = this.queue;
                synchronized (priorityQueue) {
                    this.queue.clear();
                    this.newTasksMayBeScheduled = false;
                }
                throw throwable;
            }
            PriorityQueue<TimerTask> priorityQueue = this.queue;
            synchronized (priorityQueue) {
                this.queue.clear();
                this.newTasksMayBeScheduled = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected void mainLoop() {
            shouldRun = false;
            task = null;
            block5: while (true) {
                try {
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        var3_3 = this.queue;
                        synchronized (var3_3) {
                            while (this.queue.isEmpty() && this.newTasksMayBeScheduled) {
                                this.queue.wait();
                            }
                            if (!this.newTasksMayBeScheduled) {
                                break block5;
                            }
                            task = this.queue.peek();
                            timeToTaskActivation = task.scheduledSimulationTime - this.timeProvider.getSimulationTime();
                            if (!this.timeProvider.isRunning()) {
                                this.queue.wait();
                            } else if (timeToTaskActivation > 0L) {
                                this.queue.wait(timeToTaskActivation);
                            } else {
                                task.run();
                                this.queue.remove(task);
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException var3_4) {
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }
    }
}

