/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import cz.cuni.pogamut.experiments.Experiment;
import cz.cuni.pogamut.experiments.ExperimentExecutionState;
import cz.cuni.utils.FlagListener;

public class TimeProvider {
    protected long simulationTime = -1L;
    protected long sysTimeOfLastEvent = -1L;
    protected boolean running = true;
    protected long timeOfStart = -1L;

    public TimeProvider(Experiment experiment) {
        experiment.getExperimentExecutionFlag().addListener(new FlagListener<ExperimentExecutionState>(){
            protected boolean initialized = false;

            @Override
            public void flagChanged(ExperimentExecutionState changedValue, int listenerParam) {
                if (changedValue.isRunning() && !this.initialized) {
                    this.initialized = false;
                    TimeProvider.this.timeOfStart = System.currentTimeMillis();
                    TimeProvider.this.sysTimeOfLastEvent = System.currentTimeMillis();
                    TimeProvider.this.simulationTime = 0L;
                }
                if (!changedValue.isRunning() && TimeProvider.this.running) {
                    TimeProvider.this.stopTime();
                    return;
                }
                if (changedValue.isRunning() && !TimeProvider.this.running) {
                    TimeProvider.this.startTime();
                    return;
                }
            }
        });
    }

    public synchronized void stopTime() {
        if (this.running) {
            this.simulationTime += System.currentTimeMillis() - this.sysTimeOfLastEvent;
            this.running = false;
        }
    }

    public synchronized void startTime() {
        if (!this.running) {
            this.sysTimeOfLastEvent = System.currentTimeMillis();
            this.running = true;
        }
    }

    public long getSimulationTime() {
        if (this.running) {
            return this.simulationTime + System.currentTimeMillis() - this.sysTimeOfLastEvent;
        }
        return this.simulationTime;
    }

    public long getSystemTime() {
        return System.currentTimeMillis() - this.timeOfStart;
    }

    public boolean isRunning() {
        return this.running;
    }
}

