/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.experiments;

import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.experiments.AbstractExperimentHandle;
import cz.cuni.pogamut.experiments.ExperimentDescriptor;
import cz.cuni.pogamut.experiments.ExperimentExecutionState;
import cz.cuni.pogamut.experiments.ExperimentResult;
import cz.cuni.pogamut.experiments.LocalExperimentHandle;
import cz.cuni.pogamut.experiments.TimeProvider;
import cz.cuni.pogamut.experiments.Timer;
import cz.cuni.pogamut.experiments.TimerTask;
import cz.cuni.pogamut.server.UTServer;
import cz.cuni.pogamut.server.UTServerState;
import cz.cuni.utils.ExceptionToString;
import cz.cuni.utils.Flag;
import cz.cuni.utils.FlagListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Experiment
extends AbstractExperimentHandle
implements LocalExperimentHandle {
    protected TimeProvider timeProvider = null;
    protected Timer timer = null;
    private UTServer server = null;
    private ExperimentDescriptor descriptor = null;
    FlagListener<UTServerState> serverStateListener = new FlagListener<UTServerState>(){
        ExperimentExecutionState previousState = null;
        boolean isPaused = false;

        @Override
        public void flagChanged(UTServerState changedValue, int listenerParam) {
            if (changedValue.equals((Object)UTServerState.PAUSED)) {
                this.previousState = Experiment.this.experimentState.getFlag();
                Experiment.this.setExperimentState(ExperimentExecutionState.PAUSED);
                this.isPaused = true;
            } else if (this.isPaused) {
                if (!$assertionsDisabled && this.previousState == null) {
                    throw new AssertionError();
                }
                Experiment.this.setExperimentState(this.previousState);
                this.isPaused = false;
            }
        }
    };
    private Thread experimentThread = null;
    private Logger log = null;
    protected Flag<ExperimentExecutionState> experimentState = new Flag<ExperimentExecutionState>(ExperimentExecutionState.INIT);

    protected Experiment(ExperimentDescriptor descriptor, UTServer server) {
        try {
            this.descriptor = descriptor;
            this.server = server;
            this.timeProvider = new TimeProvider(this);
            this.timer = new Timer(this);
            this.log = descriptor.getLogger() == null ? Logger.getAnonymousLogger() : descriptor.getLogger();
            server.setGameSpeed(descriptor.getExperimentSpeed());
            server.getServerStateFlag().addListener(this.serverStateListener);
        }
        catch (PogamutException ex) {
            Logger.getLogger(Experiment.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected abstract void stageOneInit() throws Exception;

    protected abstract void stageTwoStart() throws Exception;

    protected abstract void stageThreeFinish();

    public final synchronized void runExperiment() {
        if (this.experimentThread != null) {
            this.getLogger().severe("Experiment already started.");
            return;
        }
        this.experimentThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Experiment.this.log.info("Experiment thread created, starting.");
                try {
                    Experiment.this.setExperimentState(ExperimentExecutionState.INIT);
                    Experiment.this.stageOneInit();
                    Experiment.this.setExperimentState(ExperimentExecutionState.RUNNING);
                    Experiment.this.stageTwoStart();
                }
                catch (Exception ex) {
                    Experiment.this.handleException(ex);
                }
            }
        }, "Pogamut Experiment");
        this.experimentThread.setContextClassLoader(this.descriptor.getClassLoader());
        this.experimentThread.start();
    }

    public void setResultAndTerminate(ExperimentResult result) {
        result.simulationTimeLength = this.timeProvider.getSimulationTime();
        result.systemTimeLength = this.timeProvider.getSystemTime();
        this.result = result;
        this.stop();
    }

    public void schedule(TimerTask task, long delay) {
        this.timer.schedule(task, delay);
    }

    @Override
    public Experiment getExperiment() {
        return this;
    }

    @Override
    public Flag<ExperimentExecutionState> getExperimentExecutionFlag() {
        return this.experimentState.getImmutable();
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    private void setExperimentState(ExperimentExecutionState state) {
        if (this.getExperimentExecutionFlag().getFlag().equals((Object)ExperimentExecutionState.FAILED)) {
            return;
        }
        this.experimentState.setFlag(state);
    }

    @Override
    public void stop() {
        this.setExperimentState(ExperimentExecutionState.FINISHING);
        this.stageThreeFinish();
        this.setExperimentState(ExperimentExecutionState.FINISHED);
        this.getServer().disconnectAllBots();
        this.getServer().removeAllBots();
        this.timer.stopTimer();
        this.experimentRunningLatch.countDown();
        this.log.info("Experiment finished fine.");
        this.getServer().getServerStateFlag().removeListener(this.serverStateListener);
    }

    protected void handleException(Exception e) {
        this.log.severe(ExceptionToString.process("Exception occured, terminating experiment.", e));
        this.setExperimentState(ExperimentExecutionState.FINISHING);
        this.stageThreeFinish();
        this.setExperimentState(ExperimentExecutionState.FAILED);
        this.log.info("Experiment failed.");
        this.experimentRunningLatch.countDown();
    }

    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    public UTServer getServer() {
        return this.server;
    }

    public ExperimentDescriptor getDescriptor() {
        return this.descriptor;
    }
}

