/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.communication;

import cz.cuni.pogamut.MessageObjects.Command;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.communication.MediatorClientInterface;
import cz.cuni.pogamut.communication.MediatorGBInterface;
import cz.cuni.pogamut.communication.MediatorParserInterface;
import cz.cuni.pogamut.exceptions.CantCloseConnectionException;
import cz.cuni.pogamut.exceptions.CantReadException;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.utils.ExceptionToString;
import cz.cuni.utils.Flag;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Mediator {
    private Flag<Boolean> threadClientParserAlive = new Flag<Boolean>(false);
    private Flag<Boolean> threadParserClientAlive = new Flag<Boolean>(false);
    private Flag<Boolean> communicationAlive = new Flag<Boolean>(false);
    private boolean fatalExceptionOccured = false;
    private boolean shouldRun = true;
    private CountDownLatch communicationLatch = new CountDownLatch(2);
    private CountDownLatch communicationLatchPublic = new CountDownLatch(1);
    private CountDownLatch communicationEndLatch = new CountDownLatch(1);
    private CountDownLatch dummy = new CountDownLatch(1);
    private Thread threadClientParser = null;
    private Thread threadParserClient = null;
    private Logger log = null;
    private MediatorClientInterface client = null;
    private MediatorParserInterface parser = null;
    private MediatorGBInterface gb = null;
    private boolean clientParserPause;

    public Mediator(MediatorClientInterface client, MediatorParserInterface parser, MediatorGBInterface gb) {
        this.client = client;
        this.parser = parser;
        this.gb = gb;
        this.log = Logger.getAnonymousLogger();
        this.log.setLevel(Level.ALL);
    }

    public Mediator(MediatorClientInterface client, MediatorParserInterface parser, MediatorGBInterface gb, Logger log) {
        this.client = client;
        this.parser = parser;
        this.gb = gb;
        this.log = log;
    }

    public Logger getLog() {
        return this.log;
    }

    public Flag<Boolean> getThreadClientParserAliveFlag() {
        return this.threadClientParserAlive;
    }

    public Flag<Boolean> getThreadParserClientAliveFlag() {
        return this.threadParserClientAlive;
    }

    public Flag<Boolean> getCommunicationAliveFlag() {
        return this.communicationAlive;
    }

    public boolean waitForCommunication() {
        try {
            this.communicationLatchPublic.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.communicationAlive.getFlag();
    }

    public boolean waitForCommunication(long timeOut, TimeUnit unit) {
        try {
            this.communicationLatchPublic.await(timeOut, unit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.communicationAlive.getFlag();
    }

    public boolean isCommunicationAlive() {
        return this.communicationAlive.getFlag();
    }

    public void stopMediator() {
        this.log.info("Mediator is about to stop, running flag dropped, threads interrupted.");
        this.shouldRun = false;
        this.terminateClientParserCommunicationThread();
        this.terminateParserClientCommunicationThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateParserClientCommunicationThread() {
        Mediator mediator = this;
        synchronized (mediator) {
            if (this.threadParserClient != null) {
                Thread thread = this.threadParserClient;
                synchronized (thread) {
                    this.threadParserClient.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateClientParserCommunicationThread() {
        Mediator mediator = this;
        synchronized (mediator) {
            if (this.threadClientParser != null) {
                Thread thread = this.threadClientParser;
                synchronized (thread) {
                    this.threadClientParser.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseLatches() {
        CountDownLatch countDownLatch = this.communicationLatch;
        synchronized (countDownLatch) {
            while (this.communicationLatch.getCount() != 0L) {
                this.communicationLatch.countDown();
            }
        }
        countDownLatch = this.communicationLatchPublic;
        synchronized (countDownLatch) {
            while (this.communicationLatchPublic.getCount() != 0L) {
                this.communicationLatch.countDown();
            }
        }
        countDownLatch = this.communicationEndLatch;
        synchronized (countDownLatch) {
            while (this.communicationEndLatch.getCount() != 0L) {
                this.communicationEndLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aboutToDieParserClientCommunicationThread() {
        Mediator mediator = this;
        synchronized (mediator) {
            if (this.threadParserClient == null) {
                return;
            }
            Thread thread = this.threadParserClient;
            synchronized (thread) {
                this.communicationAlive.setFlag(false);
                this.threadParserClientAlive.setFlag(false);
                this.threadParserClient = null;
                try {
                    this.parser.closeParser();
                }
                catch (CantCloseConnectionException e) {
                    this.log.severe(ExceptionToString.process("Can't close Parser connection.", e));
                }
                try {
                    this.gb.closeGB();
                }
                catch (CantCloseConnectionException e) {
                    this.log.severe(ExceptionToString.process("Can't close GB connection.", e));
                }
                this.log.info("Parser --> Client communication thread terminated.");
            }
            this.raiseLatches();
            Thread otherThread = this.threadClientParser;
            if (otherThread != null) {
                otherThread.interrupt();
            }
        }
        this.communicationAlive.clearListeners();
        this.threadParserClientAlive.clearListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aboutToDieClientParserCommunicationThread() {
        Mediator mediator = this;
        synchronized (mediator) {
            if (this.threadClientParser == null) {
                return;
            }
            Thread thread = this.threadClientParser;
            synchronized (thread) {
                this.communicationAlive.setFlag(false);
                this.threadClientParserAlive.setFlag(false);
                this.threadClientParser = null;
                try {
                    this.client.closeClient();
                }
                catch (CantCloseConnectionException e) {
                    this.log.severe(ExceptionToString.process("Can't close Client connection.", e));
                }
                this.log.info("Client --> Parser communication thread terminated.");
            }
            this.raiseLatches();
            Thread otherThread = this.threadParserClient;
            if (otherThread != null) {
                otherThread.interrupt();
            }
        }
        this.communicationAlive.clearListeners();
        this.threadClientParserAlive.clearListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startParserClientCommunicationThread() {
        Mediator mediator = this;
        synchronized (mediator) {
            if (this.threadParserClient != null) {
                return;
            }
            this.threadParserClient = new Thread(new Runnable(){

                @Override
                public void run() {
                    Mediator.this.runParserClientCommunicationThread();
                }
            }, "Mediator - Parser->Client");
        }
        this.threadParserClientAlive.setFlag(true);
        this.threadParserClient.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startClientParserCommunicationThread() {
        Mediator mediator = this;
        synchronized (mediator) {
            if (this.threadClientParser != null) {
                return;
            }
            this.threadClientParser = new Thread(new Runnable(){

                @Override
                public void run() {
                    Mediator.this.runClientParserCommunicationThread();
                }
            }, "Mediator - Client->Parser");
        }
        this.threadClientParserAlive.setFlag(true);
        this.threadClientParser.start();
    }

    protected void runParserClientCommunicationThread() {
        this.threadParserClientAlive.setFlag(true);
        this.log.info("Parser --> Client communication thread started.");
        this.communicationLatch.countDown();
        if (!this.fatalExceptionOccured) {
            try {
                this.communicationLatch.await();
            }
            catch (InterruptedException e1) {
                this.log.severe(ExceptionToString.process("Thread interrupted -> terminating.", e1));
                this.fatalExceptionOccured = true;
                this.aboutToDieParserClientCommunicationThread();
                return;
            }
        }
        if (this.fatalExceptionOccured) {
            this.log.severe("Fatal exception occured -> terminating.");
            this.aboutToDieParserClientCommunicationThread();
            return;
        }
        try {
            this.communicationLatchPublic.await();
        }
        catch (InterruptedException e1) {
            this.log.severe(ExceptionToString.process("Thread interrupted -> terminating.", e1));
            this.fatalExceptionOccured = true;
            this.aboutToDieParserClientCommunicationThread();
            return;
        }
        try {
            this.initParserClientCommunication();
            while (this.shouldRun && !this.fatalExceptionOccured && this.isCommunicationAlive()) {
                this.parserClientCommunicationIteration();
            }
        }
        catch (Exception e) {
            if (this.isCommunicationAlive()) {
                this.log.severe(ExceptionToString.process("Exception caught.", e));
                this.fatalExceptionOccured = true;
            }
            this.aboutToDieParserClientCommunicationThread();
            return;
        }
        this.aboutToDieParserClientCommunicationThread();
    }

    protected void runClientParserCommunicationThread() {
        this.threadClientParserAlive.setFlag(true);
        this.log.info("Client --> Parser communication thread started.");
        this.communicationLatch.countDown();
        if (!this.fatalExceptionOccured) {
            try {
                this.communicationLatch.await();
            }
            catch (InterruptedException e1) {
                this.log.severe(ExceptionToString.process("Thread interrupted -> terminating.", e1));
                this.fatalExceptionOccured = true;
                this.aboutToDieClientParserCommunicationThread();
                return;
            }
        }
        if (this.fatalExceptionOccured) {
            this.log.severe("Fatal exception occured -> terminating.");
            this.aboutToDieClientParserCommunicationThread();
            return;
        }
        this.communicationAlive.setFlag(true);
        this.communicationLatchPublic.countDown();
        try {
            this.initClientParserCommunication();
            while (this.shouldRun && !this.fatalExceptionOccured && this.isCommunicationAlive()) {
                if (this.clientParserPause) {
                    try {
                        this.dummy.await();
                    }
                    catch (InterruptedException e) {
                        if (this.isCommunicationAlive()) {
                            this.log.severe("Thread interrupted -> terminating.");
                            this.fatalExceptionOccured = true;
                        }
                        this.aboutToDieClientParserCommunicationThread();
                        return;
                    }
                }
                this.clientParserCommunicationIteration();
            }
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process("Exception caught.", e));
            this.fatalExceptionOccured = true;
            this.aboutToDieClientParserCommunicationThread();
            return;
        }
        this.aboutToDieClientParserCommunicationThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMediator() {
        Mediator mediator = this;
        synchronized (mediator) {
            if (this.threadClientParser != null || this.threadParserClient != null) {
                this.log.info("One of the mediator's thread is already running, can't runMediator().");
                return;
            }
        }
        this.startClientParserCommunicationThread();
        this.startParserClientCommunicationThread();
    }

    public void waitForCommunicationEnd() {
        try {
            this.communicationEndLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initParserClientCommunication() {
    }

    private void initClientParserCommunication() {
    }

    private void parserClientCommunicationIteration() throws CantReadException, CantWriteException {
        MessageObject msg = this.parser.receiveParsedMessage();
        if (msg == null) {
            return;
        }
        this.client.sendMessageToClient(msg);
        if (msg.type == MessageType.MAP_FINISHED) {
            this.stopMediator();
        }
    }

    private void clientParserCommunicationIteration() throws CantWriteException, CantReadException {
        String msg = this.client.receiveMessageFromClient();
        if (msg == null) {
            return;
        }
        this.gb.sendMessageToGB(msg);
    }

    public void sendMessageToGB(final Command msg) throws CantWriteException {
        final MediatorGBInterface mGBinterface = this.gb;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws CantWriteException {
                    mGBinterface.sendMessageToGB(msg.toString());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pe) {
            CantWriteException e = (CantWriteException)pe.getException();
            throw e;
        }
    }

    public void pauseClientParserThread() {
        this.clientParserPause = true;
    }

    public void resumeClientParserThread() {
        this.clientParserPause = false;
        this.dummy.countDown();
        this.dummy = new CountDownLatch(1);
    }
}

