/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Parser;

import cz.cuni.pogamut.Parser.GameBotConnection;
import cz.cuni.pogamut.Parser.Parser;
import cz.cuni.pogamut.Parser.UnrealIDMap;
import cz.cuni.pogamut.communication.Mediator;
import cz.cuni.pogamut.communication.MediatorForClient;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.utils.Flag;
import cz.cuni.utils.FlagListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.IllegalBlockingModeException;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class RemoteParserServer
implements Runnable {
    public static final int MAX_IO_EXCEPTIONS_SEQUENCE = 10;
    private Flag<Boolean> threadAlive = new Flag<Boolean>(false);
    private ServerSocket socket = null;
    private URI gbUri = null;
    private Logger log = null;
    private Logger clientLog = Logger.getAnonymousLogger();
    private UnrealIDMap idMap = new UnrealIDMap();
    private int exception = 0;
    private ArrayList<MediatorStorage> runningClients = new ArrayList();
    private boolean terminating = false;

    private void initClientLog() {
        this.clientLog.getParent().removeHandler(this.clientLog.getParent().getHandlers()[0]);
        this.clientLog.getParent().addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.println(String.valueOf(record.getSourceClassName()) + " " + record.getSourceMethodName() + ": " + record.getMessage());
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        });
        this.clientLog.setLevel(Level.SEVERE);
    }

    public RemoteParserServer(int port, URI gbUri, Logger log) throws IOException {
        this.socket = new ServerSocket(port);
        this.gbUri = gbUri;
        this.log = log;
        this.initClientLog();
    }

    private void stopEverything() {
        this.log.info("RemoteParserServer is going to end -> stopping all clients.");
        this.terminating = true;
        for (MediatorStorage m : this.runningClients) {
            this.log.info("Stopping (soft) mediator for " + m.address.toString());
            m.mediator.stopMediator();
        }
        this.log.info("All clients stopped (soft). Waiting for 2 secs. for results.");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException m) {
            // empty catch block
        }
        this.log.info("2 secs passed. Checking results.");
        for (MediatorStorage m : this.runningClients) {
            if (!m.mediator.getCommunicationAliveFlag().getFlag().booleanValue()) continue;
            this.log.info("Mediator for " + m.address.toString() + " doesn't respond - stopping hard.");
            m.mediator.stopMediator();
            this.log.info("Mediator for " + m.address.toString() + " stopped.");
        }
        this.log.info("All clients disconnected.");
        this.runningClients.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNewClient(Socket clientSocket) throws ConnectException, IOException {
        this.log.info("Init client -> connecting to GameBot.");
        GameBotConnection gb = new GameBotConnection(this.gbUri.getHost(), this.gbUri.getPort(), this.clientLog);
        gb.connect();
        this.log.info("Init client -> creating new parser.");
        Parser parser = new Parser(gb, this.idMap, this.clientLog);
        this.log.info("Init client -> creating interface to client.");
        MediatorForClient client = new MediatorForClient(clientSocket);
        this.log.info("Init client -> creating mediator.");
        Mediator mediator = new Mediator(client, parser, parser, this.clientLog);
        this.log.info("Init client -> starting mediator.");
        MediatorStorage mediatorStorage = new MediatorStorage(mediator, clientSocket.getInetAddress());
        mediator.getCommunicationAliveFlag().addListener(mediatorStorage);
        ArrayList<MediatorStorage> arrayList = this.runningClients;
        synchronized (arrayList) {
            this.runningClients.add(mediatorStorage);
        }
        mediator.startMediator();
        this.log.info("Client connected.");
    }

    private boolean exceptionReachedLimit() {
        ++this.exception;
        if (this.exception >= 10) {
            this.log.info("Too many IOExceptions in row (10), terminating.");
            this.stopEverything();
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        block13: {
            if (this.threadAlive.getFlag().booleanValue()) {
                return;
            }
            this.threadAlive.setFlag(true);
            this.log.info("RemoteParser server thread started, listening at " + this.socket.getLocalPort() + ", awaiting new clients (agents).");
            this.log.info("Note that the RemoteParser will run infinitely - if you want to stop him, you must kill him :-)");
            try {
                Socket newClient = null;
                while (true) {
                    try {
                        while (true) {
                            newClient = this.socket.accept();
                            this.log.info("New client accepted, setting up connection for: " + newClient.getInetAddress());
                            try {
                                this.initNewClient(newClient);
                            }
                            catch (ConnectException e) {
                                this.log.severe("Can't connect to GameBots, closing client socket.");
                                newClient.close();
                                if (!this.exceptionReachedLimit()) continue;
                                break block13;
                            }
                            catch (UnknownHostException e) {
                                this.log.severe("Can't resolve GameBots address - " + this.gbUri.getHost() + ", closing client socket.");
                                newClient.close();
                                if (!this.exceptionReachedLimit()) continue;
                                break block13;
                            }
                            catch (IOException e) {
                                this.log.severe("Communication error, closing client socket.");
                                newClient.close();
                                if (!this.exceptionReachedLimit()) continue;
                                break block13;
                            }
                            this.exception = 0;
                        }
                    }
                    catch (IOException e) {
                        if (!this.exceptionReachedLimit()) continue;
                    }
                    catch (SecurityException e) {
                        throw e;
                    }
                    catch (IllegalBlockingModeException e) {
                        throw e;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.log.severe("Unhandled exception caught -> " + e.getMessage());
                e.printStackTrace();
                this.log.info("Shutting down all clients.");
                this.stopEverything();
            }
        }
        this.log.info("RemoteParser terminated.");
        this.threadAlive.setFlag(false);
    }

    private class MediatorStorage
    implements FlagListener<Boolean> {
        public Mediator mediator = null;
        public InetAddress address = null;

        public MediatorStorage(Mediator mediator, InetAddress address) {
            this.mediator = mediator;
            this.address = address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flagChanged(Boolean changedValue, int listenerParam) {
            if (!changedValue.booleanValue() && !RemoteParserServer.this.terminating) {
                ArrayList arrayList = RemoteParserServer.this.runningClients;
                synchronized (arrayList) {
                    RemoteParserServer.this.log.info("Client " + this.address.toString() + " closed connection, removing from running clients.");
                    RemoteParserServer.this.runningClients.remove(this);
                }
            }
        }
    }
}

