/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Parser;

import cz.cuni.pogamut.MessageObjects.DeleteFromBatch;
import cz.cuni.pogamut.MessageObjects.Disconnected;
import cz.cuni.pogamut.MessageObjects.DominationPoint;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.SynchronousMessages;
import cz.cuni.pogamut.Parser.GameBotConnection;
import cz.cuni.pogamut.Parser.TranslateUnrealID2IntID;
import cz.cuni.pogamut.Parser.Yylex;
import cz.cuni.pogamut.communication.MediatorGBInterface;
import cz.cuni.pogamut.communication.MediatorParserInterface;
import cz.cuni.pogamut.exceptions.CantCloseConnectionException;
import cz.cuni.pogamut.exceptions.CantReadException;
import cz.cuni.pogamut.exceptions.CantWriteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Logger;

public class Parser
implements MediatorParserInterface,
MediatorGBInterface,
TranslateUnrealID2IntID {
    private GameBotConnection gb = null;
    private TranslateUnrealID2IntID unrealID = null;
    private Logger log = null;
    public Yylex lex = null;
    private HashMap<Integer, MessageObject> dbInt2Msg = new HashMap();
    private Set<Integer> lastBatch = new HashSet<Integer>();
    private Set<Integer> currentBatch = new HashSet<Integer>();
    private Queue<MessageObject> bufferToSend = new LinkedList<MessageObject>();
    protected boolean pushIntoBatch = true;
    public boolean dontDiff = false;

    public Parser(GameBotConnection gb, TranslateUnrealID2IntID unrealID, Logger log) {
        this.log = log;
        this.gb = gb;
        this.unrealID = unrealID;
        this.lex = new Yylex(gb.input);
        this.lex.setParser(this);
    }

    private MessageObject getMessageFromYylex() throws CantReadException {
        try {
            return this.lex.yylex();
        }
        catch (Exception e) {
            this.log.severe("Unable to read from Gamebot -> " + e.getMessage() + ", exception: " + e.getClass().getName());
            throw new CantReadException("Unable to read from Gamebot -> " + e.getMessage(), e);
        }
    }

    private void handleEndMessage() {
        Iterator<Integer> iter = this.lastBatch.iterator();
        while (iter.hasNext()) {
            MessageObject msg = this.dbInt2Msg.get(iter.next());
            DeleteFromBatch deleteMsg = new DeleteFromBatch(msg.type, msg.ID);
            if (msg.type == MessageType.ITEM) {
                deleteMsg.itemClass = ((Item)msg).cls;
            }
            this.bufferToSend.add(deleteMsg);
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new HashSet<Integer>();
    }

    private MessageObject diffMessage(MessageObject msg) {
        if (msg.getClass() == DominationPoint.class) {
            return msg;
        }
        MessageObject oldMessage = this.dbInt2Msg.get(msg.ID);
        if (!msg.diff(oldMessage)) {
            return null;
        }
        oldMessage.update(msg);
        return msg;
    }

    @Override
    public MessageObject receiveParsedMessage() throws CantReadException {
        if (this.bufferToSend.size() > 0) {
            return this.bufferToSend.poll();
        }
        if (!this.gb.isConnected()) {
            this.log.severe("Connection to GameBot lost. Ending parser.");
            return new Disconnected("Connection to GameBot lost.");
        }
        MessageObject message = this.getMessageFromYylex();
        if (message == null) {
            throw new CantReadException("Yylex returned null, GB socket probably closed by remote side.");
        }
        if (message.type == MessageType.DUMMY_MESSAGE) {
            return null;
        }
        if (message.type == MessageType.END) {
            this.handleEndMessage();
            this.bufferToSend.add(message);
            message = this.bufferToSend.poll();
            return message;
        }
        if (message.type != MessageType.NAV_POINT) {
            message.visible = true;
        }
        if (this.dontDiff) {
            return message;
        }
        if (!SynchronousMessages.synchroMessages.contains((Object)message.type)) {
            return message;
        }
        if (!message.hasID()) {
            this.log.severe("Message (" + message.type.toString() + ") hasn't ID but are listed in SynchronousMessages!");
        }
        if (!this.pushIntoBatch) {
            this.dbInt2Msg.put(message.ID, message);
            return message;
        }
        this.currentBatch.add(message.ID);
        if (!this.lastBatch.contains(message.ID)) {
            if (this.dbInt2Msg.containsKey(message.ID)) {
                this.diffMessage(message);
                return message;
            }
            this.dbInt2Msg.put(message.ID, message);
            return message;
        }
        this.lastBatch.remove(message.ID);
        message = this.diffMessage(message);
        return message;
    }

    @Override
    public void sendMessageToGB(String msg) throws CantWriteException {
        this.gb.send(msg);
    }

    @Override
    public int translateUnrealID2IntID(String unrealId) {
        return this.unrealID.translateUnrealID2IntID(unrealId);
    }

    @Override
    public void closeGB() throws CantCloseConnectionException {
        this.gb.close();
    }

    @Override
    public void closeParser() throws CantCloseConnectionException {
        this.gb.close();
    }
}

