/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.io.Serializable;

public class Weapon
extends Item
implements Cloneable,
Serializable {
    public boolean melee = false;
    public ItemType weaponType = null;
    public boolean loaded = false;
    public int currentAmmo = 0;
    public int maxAmmo = 0;
    public int effectiveDist = 0;
    public int maxDist = 0;

    public Weapon(int ID, String UnrealID, String cls, Triple location, boolean reachable, boolean visible, boolean melee, int currentAmmo, int maxAmmo, ItemType weaponType, NavPoint navPoint, int effectiveDist, int maxDist) {
        super(MessageType.WEAPON, ID, UnrealID, cls, location, reachable, visible, navPoint);
        this.melee = melee;
        this.loaded = true;
        this.weaponType = weaponType;
        this.currentAmmo = currentAmmo;
        this.maxAmmo = maxAmmo;
        this.effectiveDist = effectiveDist;
        this.maxDist = maxDist;
    }

    Weapon() {
        super(MessageType.WEAPON);
    }

    @Override
    public Object clone() {
        return new Weapon(this.ID, this.UnrealID, this.cls, this.location, this.reachable, this.visible, this.melee, this.currentAmmo, this.maxAmmo, this.weaponType, this.navPoint, this.effectiveDist, this.maxDist);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public ItemType getWeaponType() {
        return this.weaponType;
    }

    public void setWeaponType(ItemType weaponType) {
        this.weaponType = weaponType;
    }

    public void setMelee(boolean melee) {
        this.melee = melee;
    }

    public boolean isMelee() {
        return this.melee;
    }

    @Override
    public String toString() {
        String temp = super.toString();
        if (this.isLoaded()) {
            temp = String.valueOf(temp) + " is loaded, ";
            temp = String.valueOf(temp) + " ammo: " + String.valueOf(this.currentAmmo) + ", ";
        } else {
            temp = String.valueOf(temp) + " is not loaded, ";
        }
        temp = this.isMelee() ? String.valueOf(temp) + " is melee, " : String.valueOf(temp) + " is ranged, ";
        temp = String.valueOf(temp) + ", type of weapon: " + String.valueOf((Object)this.getWeaponType());
        temp = String.valueOf(temp) + ", effective distance: " + String.valueOf(this.effectiveDist);
        temp = String.valueOf(temp) + ", maximal distance: " + String.valueOf(this.maxDist);
        return temp;
    }
}

