/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.Client.KnownObjects;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import java.io.Serializable;
import java.util.ArrayList;

public class Path
extends MessageObject
implements Serializable {
    public ArrayList<NavPoint> nodes = null;
    public String pongID = null;

    public Path(int ID, String UnrealID, ArrayList<NavPoint> nodes) {
        super(MessageType.PATH, ID, UnrealID);
        this.nodes = nodes;
    }

    public Path() {
        super(MessageType.PATH);
        this.nodes = new ArrayList();
    }

    @Override
    public String toString() {
        String answer = String.valueOf(super.toString()) + " PongID " + this.pongID;
        int i = 0;
        for (NavPoint nv : this.nodes) {
            answer = String.valueOf(answer) + System.getProperty("line.separator");
            answer = String.valueOf(answer) + String.valueOf(++i) + ". -> " + nv.toString();
        }
        return answer;
    }

    public void diff(KnownObjects knownObjects) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (knownObjects.contains(this.nodes.get(i).getID())) {
                this.nodes.get(i).diff(knownObjects.getObject(this.nodes.get(i).getID()));
            }
            ++i;
        }
    }

    public void update(KnownObjects knownObjects) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (this.nodes.get(i).getLocation() == null) {
                this.nodes.set(i, (NavPoint)knownObjects.getObject(this.nodes.get(i).getID()));
            }
            ++i;
        }
    }

    public String printPathIDs() {
        String content = "";
        for (NavPoint nav : this.nodes) {
            content = String.valueOf(content) + String.valueOf(nav.ID) + ", ";
        }
        return content;
    }

    public String printPathIDAndLocations() {
        String content = "";
        for (NavPoint nav : this.nodes) {
            content = String.valueOf(content) + "ID: " + String.valueOf(nav.ID) + ", Loc: " + String.valueOf(nav.location);
            content = String.valueOf(content) + ", Reach: " + String.valueOf(nav.reachable) + "\n";
        }
        return content;
    }
}

