/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.Located;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.utils.HashCode;
import java.io.Serializable;
import java.util.ArrayList;

public class NavPoint
extends MessageObject
implements Cloneable,
Serializable,
Located {
    public Triple location = null;
    public String itemClass = "None";
    public ArrayList<NeighNav> neighbours = null;
    private boolean hashComputed = false;
    private int hashCode = 0;
    public boolean reachable = false;
    public Item item = null;
    public int itemID = 0;
    public String itemUnrealID = null;
    public String flag = null;
    public Triple rotation = null;
    public boolean roamingSpot = false;
    public boolean snipingSpot = false;
    public String classOfPreferedWeapon = null;

    public NavPoint(int ID, String UnrealID, Triple location, boolean reachable, boolean visible, ArrayList<NeighNav> neighbours, int hashCode, String itemClass, Item item, int itemID, String itemUnrealID, String flag, Triple rotation, boolean snipingSpot, boolean roamingSpot, String classOfPreferedWeapon) {
        super(MessageType.NAV_POINT, ID, UnrealID, visible);
        this.location = (Triple)location.clone();
        if (neighbours != null) {
            this.neighbours = (ArrayList)neighbours.clone();
        }
        this.reachable = reachable;
        this.hashCode = hashCode;
        this.itemClass = itemClass;
        this.item = item;
        this.itemID = itemID;
        this.itemUnrealID = itemUnrealID;
        this.flag = flag;
        this.roamingSpot = roamingSpot;
        this.snipingSpot = snipingSpot;
        this.rotation = rotation;
        this.classOfPreferedWeapon = classOfPreferedWeapon;
    }

    public NavPoint(NavPoint original) {
        this(original.ID, original.UnrealID, original.location, original.reachable, original.visible, original.neighbours, original.hashCode, original.itemClass, original.item, original.itemID, original.itemUnrealID, original.flag, original.rotation, original.snipingSpot, original.roamingSpot, original.classOfPreferedWeapon);
    }

    public NavPoint() {
        super(MessageType.NAV_POINT);
    }

    @Override
    public boolean hasID() {
        return true;
    }

    private int getHashCode() {
        HashCode hc = new HashCode();
        if (this.location != null) {
            hc.add(this.location.x);
            hc.add(this.location.y);
            hc.add(this.location.z);
        } else {
            System.out.println("NavPoint doesn't have a location - error in hash code!!!");
            System.out.println(this.UnrealID);
            System.out.println(this.toString());
        }
        hc.add(this.ID);
        return hc.getHash();
    }

    public int hashCode() {
        if (!this.hashComputed) {
            this.hashCode = this.getHashCode();
        }
        return this.hashCode;
    }

    @Override
    public Object clone() {
        if (!this.hashComputed) {
            this.hashCode = this.getHashCode();
        }
        return new NavPoint(this.ID, this.UnrealID, this.location, this.reachable, this.visible, this.neighbours, this.hashCode, this.itemClass, this.item, this.itemID, this.itemUnrealID, this.flag, this.rotation, this.snipingSpot, this.roamingSpot, this.classOfPreferedWeapon);
    }

    @Override
    public Triple getLocation() {
        return this.location;
    }

    public boolean isSnipingSpot() {
        return this.snipingSpot;
    }

    public boolean isRoamingSpot() {
        return this.roamingSpot;
    }

    public String getPreferedWeaponClass() {
        return this.classOfPreferedWeapon;
    }

    public String getFlag() {
        return this.flag;
    }

    public Triple getRotation() {
        return this.rotation;
    }

    public void setLocation(Triple newLocation) {
        this.location.setTriple(newLocation);
    }

    public boolean isReachable() {
        return this.reachable;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean diff(MessageObject old) {
        boolean changed = false;
        NavPoint oldNav = (NavPoint)old;
        this.location = null;
        this.itemClass = null;
        this.neighbours = null;
        if (this.reachable != oldNav.reachable) {
            oldNav.reachable = this.reachable;
            changed = true;
        }
        if (this.visible != oldNav.visible) {
            oldNav.visible = this.visible;
            changed = true;
        }
        return changed;
    }

    @Override
    public void update(MessageObject newMsgObj) {
        NavPoint newNav = (NavPoint)newMsgObj;
        this.visible = newNav.visible;
        this.reachable = newNav.reachable;
        if (newNav.location != null) {
            this.location = (Triple)newNav.location.clone();
        }
        if (newNav.itemClass != null) {
            this.itemClass = new String(newNav.itemClass);
        }
    }

    @Override
    public String toString() {
        String content = ", Location: " + String.valueOf(this.location);
        content = String.valueOf(content) + ", item: " + this.itemClass + ", Reachability: " + this.reachable + ", Visibility: " + this.visible + ", Neighbours: ";
        if (this.neighbours != null) {
            for (NeighNav i : this.neighbours) {
                content = String.valueOf(content) + i.UnrealID + " ";
            }
        } else {
            content = String.valueOf(content) + "None";
        }
        return String.valueOf(super.toString()) + content;
    }
}

