/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Visible;
import java.io.Serializable;

public class MessageObject
implements Cloneable,
Serializable,
Visible {
    public static final String[] types = new String[]{"START", "BEGIN", "END", "SELF", "PLAYER", "MOVER", "ITEM", "ARMOR", "FLAG_INFO", "HEALTH", "WEAPON", "AMMO", "SPECIAL", "NAV_POINT", "GAME_INFO", "GAME_STATUS", "PATH", "INCOMMING_PROJECTILE", "ADD_ITEM", "ADD_AMMO", "ADD_ARMOR", "ADD_HEALTH", "ADD_WEAPON", "ADD_SPECIAL", "GLOBAL_CHAT", "TEAM_CHAT", "ZONE_CHANGED_FOOT", "ZONE_CHANGED_HEAD", "ZONE_CHANGED_BOT", "CHANGED_WEAPON", "WALL_COLLISION", "BUMPED", "HEAR_PICKUP", "HEAR_NOISE", "SEE_PLAYER", "PLAYER_KILLED", "BOT_KILLED", "BOT_DAMAGED", "PLAYER_DAMAGED", "REACHABLE", "DISCONNECTED", "FALL", "HELLO", "NAV_LIST", "NEIGH_NAV", "ITEM_LIST", "SPAWN", "TRACE", "FAST_TRACE"};
    public MessageType type = null;
    public int ID = 0;
    public String UnrealID = null;
    public boolean visible = false;

    public Object clone() {
        return new MessageObject(this.type, this.ID, this.UnrealID, this.visible);
    }

    public MessageType getType() {
        return this.type;
    }

    public int getID() {
        return this.ID;
    }

    public String getUnrealID() {
        return this.UnrealID;
    }

    @Override
    public boolean getVisibility() {
        return this.visible;
    }

    public MessageObject(MessageType type, int ID, String UnrealID) {
        this.type = type;
        this.ID = ID;
        this.UnrealID = UnrealID;
        this.visible = true;
    }

    public MessageObject(MessageType type, int ID, String UnrealID, boolean visible) {
        this.type = type;
        this.ID = ID;
        this.UnrealID = UnrealID;
        this.visible = visible;
    }

    public MessageObject() {
    }

    public MessageObject(MessageType type) {
        this.type = type;
        this.visible = false;
    }

    public boolean diff(MessageObject old) {
        if (this.UnrealID == old.UnrealID) {
            this.UnrealID = null;
            return false;
        }
        return true;
    }

    public String toString() {
        String temp = "type " + (this.type != null ? this.type.toString() : "") + ", UnrealID ";
        temp = this.UnrealID == null ? String.valueOf(temp) + "null" : String.valueOf(temp) + this.UnrealID;
        temp = String.valueOf(temp) + ", ID " + String.valueOf(this.ID);
        temp = this.visible ? String.valueOf(temp) + ", is visible " : String.valueOf(temp) + ", is not visible ";
        return temp;
    }

    public void update(MessageObject newMsgObj) {
        if (newMsgObj.UnrealID != null) {
            this.UnrealID = newMsgObj.UnrealID;
        }
    }

    public boolean equals(Object arg) {
        if (!(arg instanceof MessageObject)) {
            return false;
        }
        MessageObject mo = (MessageObject)arg;
        return mo.ID == this.ID && mo.UnrealID == this.UnrealID && mo.type == this.type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setID(int id) {
        this.ID = id;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public void setUnrealID(String unrealID) {
        this.UnrealID = unrealID;
    }

    public boolean hasID() {
        return false;
    }
}

