/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.exceptions.ScriptedAgentException;
import cz.cuni.pogamut.introspection.Introspectable;
import cz.cuni.pogamut.introspection.IntrospectableProxy;
import cz.cuni.pogamut.introspection.IntrospectableProxyUnion;
import cz.cuni.pogamut.introspection.ScriptProxyManager;
import cz.cuni.utils.Scripts;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptedAgent
extends Agent
implements Introspectable {
    protected String scriptFileName = null;
    protected ScriptEngine engine = null;
    protected Invocable invocableEngine = null;

    protected ScriptedAgent() {
    }

    protected static ScriptEngineManager createScriptEngineManager() {
        return new ScriptEngineManager();
    }

    public ScriptedAgent(String pathToScript) throws ScriptedAgentException {
        this.bindScriptFile(pathToScript);
    }

    public ScriptedAgent(File file) throws ScriptedAgentException {
        this.bindScriptFile(file);
    }

    protected void scriptFileBinded() {
        this.setAttribute("userDir", this.scriptFileName.lastIndexOf(System.getProperty("file.separator")) == -1 ? "." : this.scriptFileName.substring(0, this.scriptFileName.lastIndexOf(System.getProperty("file.separator"))));
    }

    protected void bindScriptFile(String fileName) throws ScriptedAgentException {
        if (this.scriptFileName != null) {
            return;
        }
        this.scriptFileName = fileName;
        if (this.engine == null) {
            this.bindEngineByFileName(fileName);
        }
        this.platformLog.info("Trying to load file '" + this.scriptFileName + "'.");
        this.evalFile(this.scriptFileName);
        this.platformLog.info("File evaluated.");
        this.scriptFileBinded();
    }

    protected void bindScriptFile(File file) throws ScriptedAgentException {
        if (this.scriptFileName != null) {
            return;
        }
        this.scriptFileName = file.getAbsolutePath();
        if (this.engine == null) {
            this.bindEngineByFileName(file.getPath());
        }
        this.platformLog.info("Trying to load file '" + this.scriptFileName + "'.");
        this.evalFile(this.scriptFileName);
        this.platformLog.info("File evaluated.");
        this.scriptFileBinded();
    }

    protected void engineBinded() {
        this.setAgentAttributes();
    }

    public void bindEngineByName(String name) {
        if (this.engine != null) {
            return;
        }
        this.engineIsGoingToBeBinded();
        this.engine = Scripts.getEngineManager().getEngineByName(name);
        this.invocableEngine = (Invocable)((Object)this.engine);
        this.engineBinded();
    }

    public void bindEngineByExtension(String extension) {
        if (this.engine != null) {
            return;
        }
        this.engineIsGoingToBeBinded();
        this.engine = Scripts.getEngineManager().getEngineByExtension(extension);
        this.invocableEngine = (Invocable)((Object)this.engine);
        this.engineBinded();
    }

    public void bindEngineByMimeType(String mime) {
        if (this.engine != null) {
            return;
        }
        this.engineIsGoingToBeBinded();
        this.engine = Scripts.getEngineManager().getEngineByMimeType(mime);
        this.invocableEngine = (Invocable)((Object)this.engine);
        this.engineBinded();
    }

    public void bindEngineByFileName(String fileName) {
        if (this.engine != null) {
            return;
        }
        this.engineIsGoingToBeBinded();
        String ext = fileName.lastIndexOf(".") == -1 ? "" : fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        this.engine = Scripts.getEngineManager().getEngineByExtension(ext);
        this.invocableEngine = (Invocable)((Object)this.engine);
        this.engineBinded();
    }

    protected void engineIsGoingToBeBinded() {
    }

    protected void setAgentAttributes() {
        this.setAttribute("agent", this);
        this.setAttribute("body", this.body);
        this.setAttribute("memory", this.memory);
        this.setAttribute("map", this.gameMap);
        this.setAttribute("log", this.log);
    }

    protected void setAttribute(String name, Object attribute) {
        ScriptContext context = this.engine.getContext();
        List<Integer> scopes = context.getScopes();
        context.setAttribute(name, attribute, scopes.get(0));
    }

    protected boolean evalStream(InputStream is) throws ScriptedAgentException {
        DataInputStream dis = new DataInputStream(is);
        InputStreamReader reader = new InputStreamReader(dis);
        try {
            this.engine.eval(reader);
        }
        catch (ScriptException e) {
            this.platformLog.severe("Script error -> " + e.getMessage());
            throw new ScriptedAgentException("Script error -> " + e.getMessage(), e);
        }
        return true;
    }

    protected boolean evalFile(String fileName) throws ScriptedAgentException {
        FileInputStream fstream;
        try {
            fstream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            this.platformLog.severe("Script file '" + fileName + "' not found.");
            throw new ScriptedAgentException("Script file '" + fileName + "' not found.", e);
        }
        this.platformLog.info("File " + fileName + " opened, evaluating.");
        boolean result = this.evalStream(fstream);
        try {
            fstream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    protected boolean checkPreconditions() {
        if (this.engine == null) {
            this.platformLog.severe("Can't start ScriptedAgent, no ScriptEngine binded.");
            return false;
        }
        if (this.scriptFileName == null) {
            this.platformLog.severe("Can't start ScriptedAgent, no file name with logic binded.");
            return false;
        }
        return true;
    }

    @Override
    public Thread startAgent(String botName) {
        if (!this.checkPreconditions()) {
            return null;
        }
        return super.startAgent(botName);
    }

    private boolean callFunction(String name) throws ScriptedAgentException {
        try {
            this.invocableEngine.invokeFunction(name, null);
        }
        catch (ScriptException e) {
            this.platformLog.severe("Script exception -> " + e.getMessage());
            throw new ScriptedAgentException("Script exception -> " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            this.platformLog.severe("Method '" + name + "' uninmplemented by scripts.");
            throw new ScriptedAgentException("Method '" + name + "' uninmplemented by scripts.", e);
        }
        return true;
    }

    @Override
    protected void doLogic() throws PogamutException {
        if (!this.callFunction("doLogic")) {
            this.stopAgentSoft();
        }
    }

    @Override
    protected void prePrepareAgent() throws PogamutException {
        this.callFunction("prePrepareAgent");
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
        this.callFunction("postPrepareAgent");
    }

    @Override
    protected void shutdownAgent() throws PogamutException {
        this.callFunction("shutdownAgent");
    }

    @Override
    public IntrospectableProxy getIntrospectableProxy() {
        return new IntrospectableProxyUnion(super.getIntrospectableProxy(), ScriptProxyManager.getInstance().getProxyForScriptEngine(this.engine));
    }
}

