/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.astar.AStarResult;
import cz.cuni.pogamut.Client.GameMap;
import cz.cuni.pogamut.Client.PathTypes;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Path;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class PathManager {
    protected HashMap<Integer, ArrayList<NavPoint>> collectedPaths = new HashMap();
    protected boolean isUpOnTheLift = false;
    protected ArrayList<NavPoint> pathToRunAlong = null;
    protected boolean restart = false;
    protected HashMap<PathTypes, Boolean> pathReady = new HashMap();
    protected HashMap<PathTypes, Object> targets = new HashMap();
    protected PathTypes actualPathType = null;
    protected GameMap gameMap = null;
    public int walking = 0;
    public int nextNavPointIndex = 0;
    protected int counterPathID = 10000;
    protected int pathID = 0;
    protected boolean pathRequestSent = false;

    public boolean checkPath(PathTypes type, Object target) {
        if (!type.equals((Object)this.actualPathType)) {
            this.pathReady.put(type, false);
            this.pathReady.put(this.actualPathType, false);
            this.actualPathType = type;
            this.restart = true;
        }
        if (!target.equals(this.targets.get((Object)type))) {
            this.pathReady.put(type, false);
            this.targets.put(type, target);
            this.restart = true;
        }
        return this.pathReady.get((Object)type);
    }

    public void restartPathReady() {
        Set<PathTypes> keySet = this.pathReady.keySet();
        for (PathTypes al : keySet) {
            this.pathReady.put(al, false);
        }
    }

    protected void restartPathVariables() {
        this.restart = false;
        this.pathToRunAlong = null;
        this.isUpOnTheLift = false;
        this.pathRequestSent = false;
        this.collectedPaths = new HashMap();
        this.nextNavPointIndex = 0;
        this.walking = 0;
        this.isUpOnTheLift = false;
    }

    public void preparePath(PathTypes type, Object target, boolean useAStar) {
        if (this.restart) {
            this.restartPathVariables();
        }
        boolean result = false;
        switch (type) {
            case ITEM: {
                if (useAStar && ((Item)target).navPoint != null && ((Item)target).navPoint.UnrealID != null) {
                    result = this.obtainPathAStar(((Item)target).navPoint);
                    break;
                }
                result = this.obtainPathGB(((Item)target).location);
                break;
            }
            case LOCATION: {
                result = this.obtainPathGB((Triple)target);
                break;
            }
            case PLAYER: {
                result = this.obtainPathGB(((Player)target).location);
                break;
            }
            case NAVPOINT: {
                if (useAStar) {
                    result = this.obtainPathAStar((NavPoint)target);
                    break;
                }
                result = this.obtainPathGB(((NavPoint)target).location);
                break;
            }
            default: {
                result = this.obtainPathGB((Triple)target);
            }
        }
        if (result) {
            this.pathReady.put(type, true);
        }
    }

    protected ArrayList<NavPoint> getPathToLocation(Triple location) {
        if (this.pathRequestSent) {
            if (this.collectedPaths.get(this.pathID) == null) {
                return null;
            }
            return this.collectedPaths.get(this.pathID);
        }
        ++this.counterPathID;
        if (this.counterPathID == Integer.MAX_VALUE) {
            this.counterPathID = 10000;
        }
        this.pathID = this.counterPathID;
        this.gameMap.sendGetPathToLocation(this.pathID, location);
        this.pathRequestSent = true;
        return null;
    }

    protected boolean obtainPathGB(Triple location) {
        this.pathToRunAlong = this.getPathToLocation(location);
        return this.pathToRunAlong != null;
    }

    protected boolean obtainPathAStar(NavPoint target) {
        AStarResult result = this.gameMap.getPathAStar(target);
        if (result.success) {
            this.pathToRunAlong = this.gameMap.getNavPointsAStar(result);
            return true;
        }
        return this.obtainPathGB(target.location);
    }

    public PathManager(GameMap gameMap) {
        this.gameMap = gameMap;
    }

    public NavPoint getCurrentNavPointOfPath() {
        if (this.nextNavPointIndex < this.pathToRunAlong.size()) {
            return this.pathToRunAlong.get(this.nextNavPointIndex);
        }
        return null;
    }

    public NavPoint getNextNavPointOfPath() {
        if (this.nextNavPointIndex + 1 < this.pathToRunAlong.size()) {
            return this.pathToRunAlong.get(this.nextNavPointIndex + 1);
        }
        return null;
    }

    protected void newGBPathReceived(Path path) {
        this.collectedPaths.put(Integer.valueOf(path.pongID), path.nodes);
    }

    void initializeRunAlongPathManually(ArrayList<NavPoint> path) {
        this.pathToRunAlong = path;
        this.walking = 0;
        this.isUpOnTheLift = false;
        this.pathRequestSent = false;
        this.nextNavPointIndex = 0;
    }
}

