/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.HistoryBatch;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import java.util.HashSet;
import java.util.Iterator;

public class HistoryIterator
implements Iterator {
    private int depth;
    private int actualDepth;
    private boolean unique;
    private MessageType type;
    private HistoryBatch actualBatch;
    private Iterator keySetIterator;
    private HashSet<Integer> iteratedIDs;
    private MessageObject actualMessage;

    public HistoryIterator(int depth, MessageType type, boolean unique, HistoryBatch actualBatch) {
        this.depth = depth;
        this.type = type;
        this.unique = unique;
        this.actualBatch = actualBatch;
        this.actualMessage = null;
        this.actualDepth = 0;
        this.keySetIterator = actualBatch.getAllObjectsOfType(type).keySet().iterator();
        this.iteratedIDs = new HashSet();
    }

    @Override
    public boolean hasNext() {
        if (this.unique) {
            return this.hasNextUnique();
        }
        return this.hasNextNormal();
    }

    public Object next() {
        if (this.unique) {
            return this.nextUnique();
        }
        return this.nextNormal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNextNormal() {
        HistoryBatch historyBatch = this.actualBatch;
        synchronized (historyBatch) {
            while (true) {
                if (this.actualDepth >= this.depth || this.actualBatch == null || this.keySetIterator.hasNext()) {
                    return this.keySetIterator.hasNext();
                }
                this.actualBatch = this.actualBatch.getNext();
                if (this.actualBatch == null) {
                    return false;
                }
                this.keySetIterator = this.actualBatch.getAllObjectsOfType(this.type).keySet().iterator();
                ++this.actualDepth;
            }
        }
    }

    public Object nextNormal() {
        if (this.hasNext()) {
            return this.keySetIterator.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNextUnique() {
        if (this.actualMessage == null) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            this.actualMessage = (MessageObject)this.keySetIterator.next();
            if (this.iteratedIDs.contains(this.actualMessage.ID) == false) return true;
lbl5:
            // 2 sources

            ** while (this.keySetIterator.hasNext())
        }
lbl6:
        // 1 sources

        var1_1 = this.actualBatch;
        synchronized (var1_1) {
            block4: while (true) {
                if (this.actualDepth >= this.depth) return false;
                if (this.actualBatch == null) return false;
                if (this.keySetIterator.hasNext()) {
                    return false;
                }
                this.actualBatch = this.actualBatch.getNext();
                if (this.actualBatch == null) {
                    return false;
                }
                this.keySetIterator = this.actualBatch.getAllObjectsOfType(this.type).keySet().iterator();
                ++this.actualDepth;
                while (true) {
                    if (!this.keySetIterator.hasNext()) continue block4;
                    this.actualMessage = (MessageObject)this.keySetIterator.next();
                    if (this.iteratedIDs.contains(this.actualMessage.ID) == false) return true;
                }
                break;
            }
        }
    }

    public Object nextUnique() {
        if (this.hasNextUnique()) {
            this.iteratedIDs.add(this.actualMessage.ID);
            MessageObject temp = this.actualMessage;
            this.actualMessage = null;
            return temp;
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

