/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.exceptions.BotLoadingException;
import cz.cuni.pogamut.remote.RemoteAgentWrapper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BotLauncher {
    public static Class<Agent> loadBotClass(String className, ClassLoader cl) throws BotLoadingException {
        try {
            Class<Agent> c = cl.loadClass(className);
            return c;
        }
        catch (ClassNotFoundException ex) {
            throw new BotLoadingException("Bot class not found.");
        }
    }

    public static Class<Agent> loadBotClass(String className) throws BotLoadingException {
        Class<Agent> c = BotLauncher.loadBotClass(className, Thread.currentThread().getContextClassLoader());
        return c;
    }

    public static Agent loadBot(String className, ClassLoader cl) throws BotLoadingException {
        try {
            Class<Agent> c = BotLauncher.loadBotClass(className, cl);
            return c.newInstance();
        }
        catch (InstantiationException ex) {
            throw new BotLoadingException("Bot couldn't be instantiated.");
        }
        catch (IllegalAccessException ex) {
            throw new BotLoadingException("Illegal access to the bot class.");
        }
    }

    public static Agent loadBot(String className) throws BotLoadingException {
        try {
            Class<Agent> c = BotLauncher.loadBotClass(className);
            return c.newInstance();
        }
        catch (InstantiationException ex) {
            throw new BotLoadingException("Bot couldn't be instantiated.");
        }
        catch (IllegalAccessException ex) {
            throw new BotLoadingException("Illegal access to the bot class.");
        }
    }

    public static Agent loadBotFromPogamutJar(String pathToJar) throws BotLoadingException {
        try {
            Class<Agent> c = BotLauncher.loadBotClassFromPogamutJar(pathToJar);
            return c.newInstance();
        }
        catch (InstantiationException ex) {
            throw new BotLoadingException("Bot couldn't be instantiated.");
        }
        catch (IllegalAccessException ex) {
            throw new BotLoadingException("Illegal access to the bot class.");
        }
    }

    public static Class<Agent> loadBotClass(String className, String classPath, ClassLoader parent) throws BotLoadingException {
        try {
            File f = new File(classPath);
            URL url = f.toURI().toURL();
            URLClassLoader cl = new URLClassLoader(new URL[]{url}, parent);
            Class<Agent> c = BotLauncher.loadBotClass(className, cl);
            return c;
        }
        catch (MalformedURLException ex) {
            throw new BotLoadingException("Class path not valid.");
        }
    }

    public static Class<Agent> loadBotClassFromPogamutJar(String pathToJar) throws BotLoadingException {
        try {
            File f = new File(pathToJar);
            JarFile jarFile = new JarFile(f);
            Manifest m = jarFile.getManifest();
            if (m == null) {
                throw new BotLoadingException("Manifest file not found.");
            }
            return BotLauncher.loadBotClass(m.getMainAttributes().getValue("Bot-class"), pathToJar, Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new BotLoadingException("Jar file reading error.");
        }
    }

    public static void launchRMI(Agent agent) throws RemoteException, AlreadyBoundException {
        String agentRMIname = "";
        Registry registry = LocateRegistry.getRegistry();
        registry.bind(agentRMIname, new RemoteAgentWrapper(agent));
    }
}

