/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.exceptions.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class BaseBot
extends Agent {
    protected String botName = "BaseBot";

    @Override
    protected void doLogic() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.log(Level.SEVERE, "Agent interrupted during sleep in doLogic");
            e.printStackTrace();
        }
    }

    @Override
    protected void prePrepareAgent() {
    }

    @Override
    protected void postPrepareAgent() {
    }

    @Override
    protected void shutdownAgent() {
    }

    public static void main(String[] Args) {
        BaseBot bot = new BaseBot();
        bot.log.getParent().removeHandler(bot.log.getParent().getHandlers()[0]);
        bot.log.getParent().addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.println(String.valueOf(record.getSourceClassName()) + " " + record.getSourceMethodName() + ": " + record.getMessage());
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        });
        boolean localParser = true;
        URI uri = null;
        try {
            uri = new URI("ut://artemis.ms.mff.cuni.cz:3000");
        }
        catch (URISyntaxException e2) {
            e2.printStackTrace();
            return;
        }
        if (localParser) {
            try {
                bot.bindLocalParser(uri);
            }
            catch (Exception e) {
                System.out.println("Can't connect to GameBots.");
                e.printStackTrace();
                return;
            }
        }
        try {
            bot.bindRemoteParser(uri);
        }
        catch (ConnectException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            System.exit(1);
        }
        bot.startAgent();
        try {
            while (true) {
                Thread.sleep(9999L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public String getBotName() {
        return this.botName;
    }

    public void setBotName(String newBotName) {
        this.botName = newBotName;
    }
}

