/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.BotDamaged;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.PlayerDamaged;
import cz.cuni.pogamut.MessageObjects.PlayerKilled;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentStats
implements Serializable {
    private transient Agent agent = null;
    private int frags = 0;
    private int deaths = 0;
    private int damageCaused = 0;
    private int damageSuffered = 0;
    private double teamScore = 0.0;
    private double enemyTeamScore = 0.0;

    protected Agent getAgent() {
        return this.agent;
    }

    public AgentStats(Agent agent) {
        this.agent = agent;
        this.registerListeners();
    }

    private void registerListeners() {
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            @Override
            public void receiveMessage(RcvMsgEvent e) {
                PlayerKilled killed = (PlayerKilled)e.getMessage();
                if (killed.killerID == AgentStats.this.getAgent().getMemory().getAgentID()) {
                    AgentStats agentStats = AgentStats.this;
                    agentStats.frags = agentStats.frags + 1;
                }
            }
        }, MessageType.PLAYER_KILLED);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            @Override
            public void receiveMessage(RcvMsgEvent e) {
                PlayerDamaged damaged = (PlayerDamaged)e.getMessage();
                if (damaged.hitID != AgentStats.this.getAgent().getMemory().getAgentID()) {
                    AgentStats agentStats = AgentStats.this;
                    agentStats.damageCaused = agentStats.damageCaused + damaged.damage;
                }
            }
        }, MessageType.PLAYER_DAMAGED);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            @Override
            public void receiveMessage(RcvMsgEvent e) {
                AgentStats agentStats = AgentStats.this;
                agentStats.deaths = agentStats.deaths + 1;
            }
        }, MessageType.BOT_KILLED);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            @Override
            public void receiveMessage(RcvMsgEvent e) {
                BotDamaged damaged = (BotDamaged)e.getMessage();
                AgentStats agentStats = AgentStats.this;
                agentStats.damageSuffered = agentStats.damageSuffered + damaged.damage;
            }
        }, MessageType.BOT_DAMAGED);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            @Override
            public void receiveMessage(RcvMsgEvent e) {
                double ts = AgentStats.this.getAgent().getMemory().getAgentTeamScore();
                double ets = AgentStats.this.getAgent().getMemory().getOpposingTeamScore();
                if (ts >= 0.0) {
                    AgentStats.this.teamScore = ts;
                }
                if (ets >= 0.0) {
                    AgentStats.this.enemyTeamScore = ets;
                }
            }
        }, MessageType.GAME_STATUS);
    }

    public int getFrags() {
        return this.frags;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getDamageCaused() {
        return this.damageCaused;
    }

    public int getDamageSuffered() {
        return this.damageSuffered;
    }

    public String toString() {
        String str = "";
        try {
            BeanInfo info = Introspector.getBeanInfo(this.getClass());
            PropertyDescriptor[] propertyDescriptorArray = info.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor desc = propertyDescriptorArray[n2];
                str = String.valueOf(str) + desc.getShortDescription() + " = " + desc.getReadMethod().invoke((Object)this, null).toString() + ", ";
                ++n2;
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AgentStats.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(AgentStats.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(AgentStats.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(AgentStats.class.getName()).log(Level.SEVERE, null, ex);
        }
        return str;
    }

    public double getTeamScore() {
        return this.teamScore;
    }

    public double getEnemyTeamScore() {
        return this.enemyTeamScore;
    }
}

