/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentInventory;
import cz.cuni.pogamut.Client.History;
import cz.cuni.pogamut.Client.HistoryBatch;
import cz.cuni.pogamut.Client.Inventory;
import cz.cuni.pogamut.Client.Knowledge;
import cz.cuni.pogamut.Client.KnownItems;
import cz.cuni.pogamut.Client.KnownNavPoints;
import cz.cuni.pogamut.Client.KnownPlayers;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.Client.RecentMemory;
import cz.cuni.pogamut.Client.WorldView;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.Armor;
import cz.cuni.pogamut.MessageObjects.AutoTraceRay;
import cz.cuni.pogamut.MessageObjects.BotDamaged;
import cz.cuni.pogamut.MessageObjects.BotKilled;
import cz.cuni.pogamut.MessageObjects.Bumped;
import cz.cuni.pogamut.MessageObjects.DominationPoint;
import cz.cuni.pogamut.MessageObjects.Extra;
import cz.cuni.pogamut.MessageObjects.FallEdge;
import cz.cuni.pogamut.MessageObjects.FastTrace;
import cz.cuni.pogamut.MessageObjects.FlagInfo;
import cz.cuni.pogamut.MessageObjects.GameInfo;
import cz.cuni.pogamut.MessageObjects.GameStatus;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.HearNoise;
import cz.cuni.pogamut.MessageObjects.HearPickup;
import cz.cuni.pogamut.MessageObjects.IncommingProjectile;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Mover;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.PlayerKilled;
import cz.cuni.pogamut.MessageObjects.Self;
import cz.cuni.pogamut.MessageObjects.Special;
import cz.cuni.pogamut.MessageObjects.Trace;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.WallCollision;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.MessageObjects.ZoneChangedBot;
import cz.cuni.pogamut.MessageObjects.ZoneChangedFoot;
import cz.cuni.pogamut.MessageObjects.ZoneChangedHead;
import cz.cuni.utils.Flag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class AgentMemory
implements WorldView,
RecentMemory,
Inventory,
Knowledge,
RcvMsgListener {
    private GameInfo gameInfo = null;
    private History myHistory;
    private AgentInventory myInventory;
    private Logger platformLog;
    private KnownPlayers knownPlayers;
    private KnownItems knownItems;
    private KnownNavPoints knownNavPoints;
    private AgentBody body;
    private Agent agent;
    private static final Triple zeroTriple = new Triple(0.0, 0.0, 0.0);
    private static final int MOVING_MIN_VELOCITY = 20;
    private Flag<String> name = new Flag();
    private Flag<Triple> location = new Flag();
    private Flag<Triple> rotation = new Flag();
    private Flag<Triple> velocity = new Flag();
    private Flag<Integer> team = new Flag();
    private Flag<String> weapon = new Flag();
    private Flag<Integer> health = new Flag();
    private Flag<Integer> currentAmmo = new Flag();
    private Flag<Integer> armor = new Flag();
    private Flag<Boolean> shooting = new Flag();
    public boolean memoryRestarted = false;
    private AgentInventory newMyInventory = null;
    private History newMyHistory = null;

    public AgentMemory(Logger logger, AgentBody body, Agent agent) {
        this.myHistory = new History(body, logger);
        this.myInventory = new AgentInventory(body, logger);
        this.platformLog = logger;
        this.knownPlayers = new KnownPlayers(body);
        this.knownItems = new KnownItems(body);
        this.knownNavPoints = new KnownNavPoints(body);
        this.agent = agent;
        this.body = body;
        this.body.addRcvMsgListener(this, (Collection<MessageType>)EnumSet.of(MessageType.SELF));
        this.body.addRcvMsgListener(this, (Collection<MessageType>)EnumSet.of(MessageType.BOT_KILLED));
        this.body.addRcvMsgListener(this, (Collection<MessageType>)EnumSet.of(MessageType.GAME_INFO));
        this.body.addRcvMsgListener(this, (Collection<MessageType>)EnumSet.of(MessageType.GAME_PAUSED));
        this.body.addRcvMsgListener(this, (Collection<MessageType>)EnumSet.of(MessageType.GAME_RESUMED));
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    @Override
    public void receiveMessage(RcvMsgEvent e) {
        switch (e.getMessage().type) {
            case GAME_INFO: {
                this.gameInfo = (GameInfo)e.getMessage();
                break;
            }
            case SELF: {
                Self self = (Self)e.getMessage();
                this.name.setFlag(self.name);
                this.location.setFlag(self.location);
                this.rotation.setFlag(self.rotation);
                this.velocity.setFlag(self.velocity);
                this.team.setFlag(self.team);
                this.weapon.setFlag(self.weapon);
                this.health.setFlag(self.health);
                this.currentAmmo.setFlag(self.currentAmmo);
                this.armor.setFlag(self.armor);
                this.shooting.setFlag(self.shooting);
                break;
            }
            case BOT_KILLED: {
                this.restartMemory();
                break;
            }
            case GAME_PAUSED: {
                this.gameInfo.botsPaused = true;
                break;
            }
            case GAME_RESUMED: {
                this.gameInfo.botsPaused = false;
                break;
            }
            default: {
                this.platformLog.warning("Unknown message!!! - possibly unhandled register");
            }
        }
    }

    public MessageObject getFromMyHistory(MessageType type) {
        return this.myHistory.getFirstMessageOfType(type);
    }

    public Collection<MessageObject> getAllFromCurrentBatch(MessageType type) {
        return this.myHistory.getFirstBatch().getAllObjectsOfType(type).values();
    }

    public void restartMemory() {
        this.newMyHistory = new History(this.body, this.platformLog);
        this.newMyInventory = new AgentInventory(this.body, this.platformLog);
        this.memoryRestarted = true;
    }

    public void switchMemories() {
        this.platformLog.warning("Agent KILLED. Memory and inventory restarted.");
        this.body.removeRcvMsgListener(this.myHistory);
        this.body.removeTypedRcvMsgListener(this.myInventory, MessageType.ADD_WEAPON);
        this.body.removeTypedRcvMsgListener(this.myInventory, MessageType.ADD_AMMO);
        this.body.removeTypedRcvMsgListener(this.myInventory, MessageType.ADD_SPECIAL);
        this.body.removeTypedRcvMsgListener(this.myInventory, MessageType.CHANGED_WEAPON);
        this.body.removeTypedRcvMsgListener(this.myInventory, MessageType.SELF);
        this.myHistory = this.newMyHistory;
        this.myInventory = this.newMyInventory;
        this.memoryRestarted = false;
    }

    public String toString() {
        return this.myHistory.toString();
    }

    @Override
    public int numberOfWeapons() {
        return this.myInventory.numberOfWeapons();
    }

    @Override
    public int numberOfLoadedWeapons() {
        return this.myInventory.numberOfLoadedWeapons();
    }

    @Override
    public AddWeapon getMeleeWeapon() {
        return this.myInventory.getWeapon(true);
    }

    @Override
    public AddWeapon getRangedWeapon() {
        return this.myInventory.getWeapon(false);
    }

    @Override
    public AddWeapon getAnyWeapon() {
        return this.myInventory.getWeapon();
    }

    @Override
    public boolean isAmmoSuitable(Ammo ammo) {
        return this.myInventory.suitableAmmo(ammo);
    }

    @Override
    public AddWeapon getCurrentWeapon() {
        return this.myInventory.getCurrentWeapon();
    }

    @Override
    public boolean hasLoadedWeapon() {
        return this.myInventory.getCurrentWeapon() != null && this.myInventory.getCurrentWeapon().currentAmmo != 0 && !this.myInventory.getCurrentWeapon().weaponType.equals((Object)ItemType.SHIELD_GUN);
    }

    @Override
    public boolean hasAnyLoadedWeapon() {
        return this.myInventory.anyLoaded();
    }

    @Override
    public boolean hasWeaponOfType(ItemType type) {
        return this.myInventory.hasWeaponOfType(type);
    }

    @Override
    public AddWeapon getBetterWeapon(Triple from, Triple to) {
        return this.myInventory.getBetterWeapon(from, to);
    }

    @Override
    public ArrayList<AddWeapon> getAllWeapons() {
        return this.myInventory.getAllWeapons();
    }

    @Override
    public ArrayList<AddWeapon> getCopyOfAllWeapons() {
        return this.myInventory.getCopyOfAllWeapons();
    }

    public Agent getAgent() {
        return this.agent;
    }

    public boolean hasSelf() {
        return this.myHistory.getFirstMessageOfType(MessageType.SELF) != null;
    }

    @Override
    public int getAgentAmmo() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getCurrentAmmo();
        }
        return -1;
    }

    @Override
    public int getAgentArmor() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getArmor();
        }
        return -1;
    }

    @Override
    public int getAgentHealth() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getHealth();
        }
        return -1;
    }

    @Override
    public boolean getAgentIsMoving() {
        if (this.hasSelf()) {
            return !((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getSelfVelocity().zero();
        }
        return false;
    }

    @Override
    public Triple getAgentLocation() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getSelfLocation();
        }
        return null;
    }

    @Override
    public String getAgentName() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getSelfName();
        }
        return null;
    }

    @Override
    public Triple getAgentRotation() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getSelfRotation();
        }
        return null;
    }

    @Override
    public int getAgentTeam() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getSelfTeam();
        }
        return -1;
    }

    @Override
    public Triple getAgentVelocity() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getSelfVelocity();
        }
        return null;
    }

    @Override
    public String getAgentUnrealID() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getUnrealID();
        }
        return null;
    }

    @Override
    public int getAgentID() {
        if (this.hasSelf()) {
            return ((Self)this.myHistory.getFirstMessageOfType(MessageType.SELF)).getID();
        }
        return 0;
    }

    public ArrayList<Self> selfHistory(int time) {
        ArrayList<MessageObject> lastSelfs = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.SELF);
        ArrayList<Self> selfs = new ArrayList<Self>();
        int i = 0;
        while (i < lastSelfs.size()) {
            selfs.add((Self)lastSelfs.get(i));
            ++i;
        }
        return selfs;
    }

    @Override
    public HashMap<Integer, Double> allPlayersScores() {
        return ((GameStatus)this.myHistory.getFirstMessageOfType((MessageType)MessageType.GAME_STATUS)).playerScores;
    }

    @Override
    public double getAgentTeamScore() {
        GameStatus temp = (GameStatus)this.myHistory.getFirstMessageOfType(MessageType.GAME_STATUS);
        if (temp != null && temp.teamScores.containsKey(this.getAgentTeam())) {
            return temp.teamScores.get(this.getAgentTeam());
        }
        return -1.0;
    }

    @Override
    public double getAgentScore() {
        GameStatus temp = (GameStatus)this.myHistory.getFirstMessageOfType(MessageType.GAME_STATUS);
        if (temp != null && temp.playerScores.containsKey(this.getAgentUnrealID())) {
            return temp.playerScores.get(this.getAgentUnrealID());
        }
        return -1.0;
    }

    public AgentBody getBody() {
        return this.body;
    }

    @Override
    public double getOpposingTeamScore() {
        GameStatus temp = (GameStatus)this.myHistory.getFirstMessageOfType(MessageType.GAME_STATUS);
        int team = 0;
        if (this.getAgentTeam() == 0) {
            team = 1;
        }
        if (temp != null && temp.teamScores.containsKey(team)) {
            return temp.teamScores.get(team);
        }
        return -1.0;
    }

    @Override
    public HashMap<Integer, Double> opposingTeamScores() {
        return ((GameStatus)this.myHistory.getFirstMessageOfType((MessageType)MessageType.GAME_STATUS)).teamScores;
    }

    @Override
    public double getPlayerScore(int id) {
        GameStatus temp = (GameStatus)this.myHistory.getFirstMessageOfType(MessageType.GAME_STATUS);
        if (temp != null && temp.playerScores.containsKey(id)) {
            return temp.playerScores.get(id);
        }
        return -1.0;
    }

    @Override
    public boolean getHearNoise() {
        return (HearNoise)this.myHistory.getFirstMessageOfType(MessageType.HEAR_NOISE) != null;
    }

    @Override
    public boolean getHearPickUp() {
        return (HearPickup)this.myHistory.getFirstMessageOfType(MessageType.HEAR_PICKUP) != null;
    }

    @Override
    public boolean isBeingDamaged() {
        return (BotDamaged)this.myHistory.getFirstMessageOfType(MessageType.BOT_DAMAGED) != null;
    }

    @Override
    public boolean isBumpingToAnotherActor() {
        return (Bumped)this.myHistory.getFirstMessageOfType(MessageType.BUMPED) != null;
    }

    @Override
    public boolean isColliding() {
        return (WallCollision)this.myHistory.getFirstMessageOfType(MessageType.WALL_COLLISION) != null;
    }

    @Override
    public boolean isFalling() {
        FallEdge fall = (FallEdge)this.myHistory.getFirstMessageOfType(MessageType.FALL);
        return fall != null && fall.fell;
    }

    @Override
    public boolean isProjectileComming() {
        return (IncommingProjectile)this.myHistory.getFirstMessageOfType(MessageType.INCOMMING_PROJECTILE) != null;
    }

    @Override
    public boolean isShooting() {
        Self self = (Self)this.myHistory.getFirstMessageOfType(MessageType.SELF);
        if (self == null) {
            return false;
        }
        return self.getShooting();
    }

    @Override
    public boolean isMoving() {
        Self self = (Self)this.myHistory.getFirstMessageOfType(MessageType.SELF);
        if (self == null) {
            return false;
        }
        return Triple.distanceInSpace(self.getSelfVelocity(), zeroTriple) > 20.0;
    }

    @Override
    public NavPoint getSeeNavPoint() {
        ArrayList<NavPoint> navPoints = this.getSeeNavPoints();
        Iterator<NavPoint> iterator = navPoints.iterator();
        NavPoint candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.visible) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public NavPoint getSeeReachableNavPoint() {
        ArrayList<NavPoint> navPoints = this.getSeeNavPoints();
        Iterator<NavPoint> iterator = navPoints.iterator();
        NavPoint candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable || !candidate.visible) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public ArrayList<NavPoint> getSeeReachableNavPoints() {
        ArrayList<NavPoint> navPoints = this.getSeeNavPoints();
        ArrayList<NavPoint> reachableNavPoints = new ArrayList<NavPoint>();
        Iterator<NavPoint> iterator = navPoints.iterator();
        NavPoint candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable || !candidate.visible) continue;
            reachableNavPoints.add(candidate);
        }
        return reachableNavPoints;
    }

    @Override
    public boolean getSeeAnyReachableNavPoint() {
        ArrayList<NavPoint> navPoints = this.getSeeNavPoints();
        Iterator<NavPoint> iterator = navPoints.iterator();
        NavPoint candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable || !candidate.visible) continue;
            return true;
        }
        return false;
    }

    @Override
    public NavPoint getSeeNavPoint(int navPointID) {
        HistoryBatch batch = this.myHistory.getFirstBatch();
        if (batch == null) {
            return null;
        }
        NavPoint nv = (NavPoint)batch.getMessage(MessageType.NAV_POINT, navPointID);
        if (nv == null) {
            return null;
        }
        return nv;
    }

    @Override
    public Player getSeePlayer(int playerID) {
        HistoryBatch batch = this.myHistory.getFirstBatch();
        if (batch == null) {
            return null;
        }
        return (Player)batch.getMessage(MessageType.PLAYER, playerID);
    }

    @Override
    public Mover getSeeMover(int moverID) {
        HistoryBatch batch = this.myHistory.getFirstBatch();
        if (batch == null) {
            return null;
        }
        return (Mover)batch.getMessage(MessageType.MOVER, moverID);
    }

    @Override
    public Item getSeeItem(int itemID) {
        HistoryBatch batch = this.myHistory.getFirstBatch();
        if (batch == null) {
            return null;
        }
        return (Item)batch.getMessage(MessageType.ITEM, itemID);
    }

    @Override
    public Ammo getSeeAmmo() {
        return (Ammo)this.myHistory.getFirstMessageOfType(MessageType.AMMO);
    }

    @Override
    public Ammo getSeeReachableAmmo() {
        ArrayList<Ammo> ammos = this.getSeeAmmos();
        Iterator<Ammo> iterator = ammos.iterator();
        Ammo candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public ArrayList<Ammo> getSeeAmmos() {
        ArrayList<MessageObject> seenAmmos = this.myHistory.getMessagesOfType(MessageType.AMMO);
        ArrayList<Ammo> ammos = new ArrayList<Ammo>();
        int i = 0;
        while (i < seenAmmos.size()) {
            ammos.add((Ammo)seenAmmos.get(i));
            ++i;
        }
        return ammos;
    }

    @Override
    public ArrayList<Ammo> getSeeReachableAmmos() {
        ArrayList<Ammo> ammos = this.getSeeAmmos();
        ArrayList<Ammo> result = new ArrayList<Ammo>();
        Iterator<Ammo> iterator = ammos.iterator();
        Ammo candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            result.add(candidate);
        }
        return result;
    }

    @Override
    public boolean getSeeAnyAmmo() {
        return (Ammo)this.myHistory.getFirstMessageOfType(MessageType.AMMO) != null;
    }

    @Override
    public boolean getSeeAnyReachableAmmo() {
        ArrayList<Ammo> ammos = this.getSeeAmmos();
        Iterator<Ammo> iterator = ammos.iterator();
        Ammo candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getSeeAnyArmor() {
        return (Armor)this.myHistory.getFirstMessageOfType(MessageType.ARMOR) != null;
    }

    @Override
    public Armor getSeeReachableArmor() {
        ArrayList<Armor> armors = this.getSeeArmors();
        Iterator<Armor> iterator = armors.iterator();
        Armor candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean getSeeAnyEnemy() {
        return this.getSeeEnemy() != null;
    }

    @Override
    public boolean getSeeAnyFriend() {
        return this.getSeeFriend() != null;
    }

    @Override
    public boolean getSeeAnyItem() {
        return (Item)this.myHistory.getFirstMessageOfType(MessageType.ITEM) != null;
    }

    @Override
    public boolean getSeeAnyReachableItem() {
        ArrayList<Item> items = this.getSeeItems();
        Iterator<Item> iterator = items.iterator();
        Item candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return true;
        }
        return false;
    }

    public Item seeReachableItem() {
        ArrayList<Item> items = this.getSeeItems();
        Iterator<Item> iterator = items.iterator();
        Item candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean getSeeAnyHealth() {
        return (Health)this.myHistory.getFirstMessageOfType(MessageType.HEALTH) != null;
    }

    @Override
    public Health getSeeReachableHealth() {
        ArrayList<Health> healths = this.getSeeHealths();
        Iterator<Health> iterator = healths.iterator();
        Health candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean getSeeAnyReachableHealth() {
        ArrayList<Health> healths = this.getSeeHealths();
        Iterator<Health> iterator = healths.iterator();
        Health candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getSeeAnyMover() {
        return (Mover)this.myHistory.getFirstMessageOfType(MessageType.MOVER) != null;
    }

    @Override
    public boolean getSeeAnyNavPoint() {
        ArrayList<NavPoint> navPoints = this.getSeeNavPoints();
        Iterator<NavPoint> iterator = navPoints.iterator();
        NavPoint candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.visible) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getSeeAnyPlayer() {
        return (Player)this.myHistory.getFirstMessageOfType(MessageType.PLAYER) != null;
    }

    @Override
    public boolean getSeeAnyWeapon() {
        return (Weapon)this.myHistory.getFirstMessageOfType(MessageType.WEAPON) != null;
    }

    @Override
    public Armor getSeeArmor() {
        return (Armor)this.myHistory.getFirstMessageOfType(MessageType.ARMOR);
    }

    @Override
    public boolean getSeeAnyReachableArmor() {
        ArrayList<Armor> armors = this.getSeeArmors();
        Iterator<Armor> iterator = armors.iterator();
        Armor candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Armor> getSeeArmors() {
        ArrayList<MessageObject> seenArmors = this.myHistory.getMessagesOfType(MessageType.ARMOR);
        ArrayList<Armor> armors = new ArrayList<Armor>();
        int i = 0;
        while (i < seenArmors.size()) {
            armors.add((Armor)seenArmors.get(i));
            ++i;
        }
        return armors;
    }

    @Override
    public Player getSeeEnemy() {
        ArrayList<Player> listOfVisiblePlayers = this.getSeePlayers();
        if (listOfVisiblePlayers.isEmpty()) {
            return null;
        }
        for (Player plr : listOfVisiblePlayers) {
            if (plr.team == this.getAgentTeam() && plr.team != 255) continue;
            return plr;
        }
        return null;
    }

    @Override
    public Player getSeeFriend() {
        ArrayList<Player> listOfVisiblePlayers = this.getSeePlayers();
        if (listOfVisiblePlayers.isEmpty()) {
            return null;
        }
        for (Player plr : listOfVisiblePlayers) {
            if (plr.team != this.getAgentTeam()) continue;
            return plr;
        }
        return null;
    }

    @Override
    public Item getSeeItem() {
        return (Item)this.myHistory.getFirstMessageOfType(MessageType.ITEM);
    }

    @Override
    public ArrayList<Item> getSeeItems() {
        ArrayList<MessageObject> seenItems = this.myHistory.getMessagesOfType(MessageType.ITEM);
        ArrayList<Item> items = new ArrayList<Item>();
        int i = 0;
        while (i < seenItems.size()) {
            items.add((Item)seenItems.get(i));
            ++i;
        }
        return items;
    }

    @Override
    public Health getSeeHealth() {
        return (Health)this.myHistory.getFirstMessageOfType(MessageType.HEALTH);
    }

    @Override
    public ArrayList<Health> getSeeHealths() {
        ArrayList<MessageObject> seenHealths = this.myHistory.getMessagesOfType(MessageType.HEALTH);
        ArrayList<Health> healths = new ArrayList<Health>();
        int i = 0;
        while (i < seenHealths.size()) {
            healths.add((Health)seenHealths.get(i));
            ++i;
        }
        return healths;
    }

    @Override
    public Mover getSeeMover() {
        return (Mover)this.myHistory.getFirstMessageOfType(MessageType.MOVER);
    }

    @Override
    public ArrayList<Mover> getSeeMovers() {
        ArrayList<MessageObject> seenMovers = this.myHistory.getMessagesOfType(MessageType.MOVER);
        ArrayList<Mover> movers = new ArrayList<Mover>();
        int i = 0;
        while (i < seenMovers.size()) {
            movers.add((Mover)seenMovers.get(i));
            ++i;
        }
        return movers;
    }

    @Override
    public ArrayList<NavPoint> getSeeNavPoints() {
        ArrayList<MessageObject> seeNavPoints = this.myHistory.getMessagesOfType(MessageType.NAV_POINT);
        ArrayList<NavPoint> navPoints = new ArrayList<NavPoint>();
        int i = 0;
        while (i < seeNavPoints.size()) {
            NavPoint temp = (NavPoint)seeNavPoints.get(i);
            if (temp.isVisible()) {
                navPoints.add(temp);
            }
            ++i;
        }
        return navPoints;
    }

    public ArrayList<NavPoint> seeAllNavPoints() {
        ArrayList<MessageObject> seeNavPoints = this.myHistory.getMessagesOfType(MessageType.NAV_POINT);
        ArrayList<NavPoint> navPoints = new ArrayList<NavPoint>();
        int i = 0;
        while (i < seeNavPoints.size()) {
            NavPoint temp = (NavPoint)seeNavPoints.get(i);
            navPoints.add(temp);
            ++i;
        }
        return navPoints;
    }

    @Override
    public Player getSeePlayer() {
        return (Player)this.myHistory.getFirstMessageOfType(MessageType.PLAYER);
    }

    @Override
    public ArrayList<Player> getSeePlayers() {
        ArrayList<MessageObject> seenPlayers = this.myHistory.getMessagesOfType(MessageType.PLAYER);
        ArrayList<Player> players = new ArrayList<Player>();
        int i = 0;
        while (i < seenPlayers.size()) {
            players.add((Player)seenPlayers.get(i));
            ++i;
        }
        return players;
    }

    @Override
    public Weapon getSeeWeapon() {
        return (Weapon)this.myHistory.getFirstMessageOfType(MessageType.WEAPON);
    }

    @Override
    public Weapon getSeeReachableWeapon() {
        ArrayList<Weapon> weapons = this.getSeeWeapons();
        Iterator<Weapon> iterator = weapons.iterator();
        Weapon candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean getSeeAnyReachableWeapon() {
        ArrayList<Weapon> weapons = this.getSeeWeapons();
        Iterator<Weapon> iterator = weapons.iterator();
        Weapon candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Weapon> getSeeReachableWeapons() {
        ArrayList<Weapon> weapons = this.getSeeWeapons();
        ArrayList<Weapon> result = new ArrayList<Weapon>();
        Iterator<Weapon> iterator = weapons.iterator();
        Weapon candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            result.add(candidate);
        }
        return result;
    }

    @Override
    public ArrayList<Weapon> getSeeWeapons() {
        ArrayList<MessageObject> seenWeapons = this.myHistory.getMessagesOfType(MessageType.WEAPON);
        ArrayList<Weapon> weapons = new ArrayList<Weapon>();
        int i = 0;
        while (i < seenWeapons.size()) {
            weapons.add((Weapon)seenWeapons.get(i));
            ++i;
        }
        return weapons;
    }

    @Override
    public int getWasKilledBy() {
        if ((BotKilled)this.myHistory.getFirstMessageOfType(MessageType.BOT_KILLED) != null) {
            return ((BotKilled)this.myHistory.getFirstMessageOfType((MessageType)MessageType.BOT_KILLED)).killerID;
        }
        return 0;
    }

    @Override
    public int getWhoAgentKilled() {
        if ((PlayerKilled)this.myHistory.getFirstMessageOfType(MessageType.PLAYER_KILLED) != null) {
            return ((PlayerKilled)this.myHistory.getFirstMessageOfType((MessageType)MessageType.PLAYER_KILLED)).playerID;
        }
        return 0;
    }

    @Override
    public boolean getSeeAnyExtra() {
        return (Extra)this.myHistory.getFirstMessageOfType(MessageType.EXTRA) != null;
    }

    @Override
    public boolean getSeeAnyReachableExtra() {
        ArrayList<Extra> extras = this.getSeeExtras();
        Iterator<Extra> iterator = extras.iterator();
        Extra candidate = null;
        while (iterator.hasNext()) {
            candidate = iterator.next();
            if (!candidate.reachable) continue;
            return true;
        }
        return false;
    }

    @Override
    public Extra getSeeExtra() {
        return (Extra)this.myHistory.getFirstMessageOfType(MessageType.EXTRA);
    }

    @Override
    public ArrayList<Extra> getSeeExtras() {
        ArrayList<MessageObject> seenExtras = this.myHistory.getMessagesOfType(MessageType.ARMOR);
        ArrayList<Extra> extras = new ArrayList<Extra>();
        int i = 0;
        while (i < seenExtras.size()) {
            extras.add((Extra)seenExtras.get(i));
            ++i;
        }
        return extras;
    }

    @Override
    public ArrayList<NavPoint> seenNavPoints(int time) {
        ArrayList<MessageObject> seenNavPoints = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.NAV_POINT);
        ArrayList<NavPoint> navPoints = new ArrayList<NavPoint>();
        if (seenNavPoints.isEmpty()) {
            return navPoints;
        }
        int i = 0;
        while (i < seenNavPoints.size()) {
            navPoints.add((NavPoint)seenNavPoints.get(i));
            ++i;
        }
        return navPoints;
    }

    @Override
    public ArrayList<Ammo> seenAmmos(int time) {
        ArrayList<MessageObject> seenAmmos = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.AMMO);
        ArrayList<Ammo> ammos = new ArrayList<Ammo>();
        int i = 0;
        while (i < seenAmmos.size()) {
            ammos.add((Ammo)seenAmmos.get(i));
            ++i;
        }
        return ammos;
    }

    @Override
    public ArrayList<Armor> seenArmors(int time) {
        ArrayList<MessageObject> seenArmors = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.ARMOR);
        ArrayList<Armor> armors = new ArrayList<Armor>();
        int i = 0;
        while (i < seenArmors.size()) {
            armors.add((Armor)seenArmors.get(i));
            ++i;
        }
        return armors;
    }

    @Override
    public ArrayList<Health> seenHealths(int time) {
        ArrayList<MessageObject> seenHealths = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.HEALTH);
        ArrayList<Health> healths = new ArrayList<Health>();
        int i = 0;
        while (i < seenHealths.size()) {
            healths.add((Health)seenHealths.get(i));
            ++i;
        }
        return healths;
    }

    @Override
    public ArrayList<Item> seenItems(int time) {
        ArrayList<MessageObject> seenItems = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.ITEM);
        ArrayList<Item> items = new ArrayList<Item>();
        int i = 0;
        while (i < seenItems.size()) {
            items.add((Item)seenItems.get(i));
            ++i;
        }
        return items;
    }

    @Override
    public ArrayList<Mover> seenMovers(int time) {
        ArrayList<MessageObject> seenMovers = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.MOVER);
        ArrayList<Mover> movers = new ArrayList<Mover>();
        int i = 0;
        while (i < seenMovers.size()) {
            movers.add((Mover)seenMovers.get(i));
            ++i;
        }
        return movers;
    }

    @Override
    public ArrayList<Player> seenPlayers(int time) {
        ArrayList<MessageObject> seenPlayers = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.PLAYER);
        ArrayList<Player> players = new ArrayList<Player>();
        int i = 0;
        while (i < seenPlayers.size()) {
            players.add((Player)seenPlayers.get(i));
            ++i;
        }
        return players;
    }

    @Override
    public ArrayList<Weapon> seenWeapons(int time) {
        ArrayList<MessageObject> seenWeapons = this.myHistory.getSeenMessageObjectsInTime(time, MessageType.WEAPON);
        ArrayList<Weapon> weapons = new ArrayList<Weapon>();
        int i = 0;
        while (i < seenWeapons.size()) {
            weapons.add((Weapon)seenWeapons.get(i));
            ++i;
        }
        return weapons;
    }

    @Override
    public ArrayList<NavPoint> getKnownNavPoints() {
        return this.knownNavPoints.getStoredNavPoints();
    }

    @Override
    public ArrayList<Player> getKnownPlayers() {
        return this.knownPlayers.getStoredPlayers();
    }

    @Override
    public Triple lastPlayerPosition(int ID) {
        return this.knownPlayers.getPlayersLastKnownPosition(ID);
    }

    @Override
    public Player lastPlayerInfo(int ID) {
        return this.knownPlayers.getPlayerInfo(ID);
    }

    @Override
    public ArrayList<Ammo> getKnownAmmos() {
        return this.knownItems.getKnownAmmos();
    }

    @Override
    public ArrayList<Armor> getKnownArmors() {
        return this.knownItems.getKnownArmors();
    }

    @Override
    public ArrayList<Health> getKnownHealths() {
        return this.knownItems.getKnownHealths();
    }

    public ArrayList<Item> getKnownItemsOfType(MessageType type) {
        return this.knownItems.getKnownItemsByType(type);
    }

    @Override
    public ArrayList<Special> getKnownSpecials() {
        return this.knownItems.getKnownSpecials();
    }

    @Override
    public ArrayList<Weapon> getKnownWeapons() {
        return this.knownItems.getKnownWeapons();
    }

    @Override
    public FastTrace getFastTraceResult(int id) {
        return (FastTrace)this.myHistory.getFirstMessageOfType(MessageType.FAST_TRACE);
    }

    @Override
    public ZoneChangedBot getBotZoneChanged() {
        return (ZoneChangedBot)this.myHistory.getFirstMessageOfType(MessageType.ZONE_CHANGED_BOT);
    }

    @Override
    public ZoneChangedFoot getFootZoneChanged() {
        return (ZoneChangedFoot)this.myHistory.getFirstMessageOfType(MessageType.ZONE_CHANGED_FOOT);
    }

    @Override
    public ZoneChangedHead getHeadZoneChanged() {
        return (ZoneChangedHead)this.myHistory.getFirstMessageOfType(MessageType.ZONE_CHANGED_HEAD);
    }

    @Override
    public boolean isBotChangedZone() {
        return (ZoneChangedBot)this.myHistory.getFirstMessageOfType(MessageType.ZONE_CHANGED_BOT) != null;
    }

    @Override
    public boolean isFootChangedZone() {
        return (ZoneChangedFoot)this.myHistory.getFirstMessageOfType(MessageType.ZONE_CHANGED_FOOT) != null;
    }

    @Override
    public boolean isHeadChangedZone() {
        return (ZoneChangedHead)this.myHistory.getFirstMessageOfType(MessageType.ZONE_CHANGED_HEAD) != null;
    }

    @Override
    public Trace getTraceResult(int id) {
        return (Trace)this.myHistory.getFirstMessageOfType(MessageType.TRACE);
    }

    @Override
    public AutoTraceRay getAutoTraceByID(int ID) {
        ArrayList<MessageObject> autoTraces = this.myHistory.getMessagesOfType(MessageType.AUTO_TRACE_RAY);
        for (MessageObject ray : autoTraces) {
            if (ray.ID != ID) continue;
            return (AutoTraceRay)ray;
        }
        return null;
    }

    @Override
    public ArrayList<Integer> getAutoTraceIDs() {
        ArrayList<MessageObject> autoTraces = this.myHistory.getMessagesOfType(MessageType.AUTO_TRACE_RAY);
        ArrayList<Integer> traces = new ArrayList<Integer>();
        for (MessageObject ray : autoTraces) {
            traces.add(((AutoTraceRay)ray).ID);
        }
        return traces;
    }

    @Override
    public ArrayList<AutoTraceRay> getAutoTraces() {
        ArrayList<MessageObject> autoTraces = this.myHistory.getMessagesOfType(MessageType.AUTO_TRACE_RAY);
        ArrayList<AutoTraceRay> traces = new ArrayList<AutoTraceRay>();
        for (MessageObject ray : autoTraces) {
            traces.add((AutoTraceRay)ray);
        }
        return traces;
    }

    @Override
    public boolean isFlagStolen() {
        FlagInfo temp = (FlagInfo)this.myHistory.getFirstMessageOfType(MessageType.FLAG_INFO);
        return temp != null && temp.state.equals("Home");
    }

    @Override
    public boolean isHoldingFlag() {
        FlagInfo temp = (FlagInfo)this.myHistory.getFirstMessageOfType(MessageType.FLAG_INFO);
        return temp.holderID == this.getAgentID();
    }

    @Override
    public boolean getSeeAnyDomPoint() {
        return this.myHistory.getFirstMessageOfType(MessageType.DOM_POINT) != null;
    }

    @Override
    public DominationPoint getSeeDomPoint() {
        return (DominationPoint)this.myHistory.getFirstMessageOfType(MessageType.DOM_POINT);
    }

    public Flag<String> getName() {
        return this.name;
    }

    public Flag<Triple> getLocation() {
        return this.location;
    }

    public Flag<Triple> getRotation() {
        return this.rotation;
    }

    public Flag<Triple> getVelocity() {
        return this.velocity;
    }

    public Flag<Integer> getTeam() {
        return this.team;
    }

    public Flag<String> getWeapon() {
        return this.weapon;
    }

    public Flag<Integer> getHealth() {
        return this.health;
    }

    public Flag<Integer> getCurrentAmmo() {
        return this.currentAmmo;
    }

    public Flag<Integer> getArmor() {
        return this.armor;
    }

    public Flag<Boolean> getShooting() {
        return this.shooting;
    }

    @Override
    public Ammo getSeeAmmo(String UnrealID) {
        ArrayList<Ammo> candidates = this.getSeeAmmos();
        for (Ammo it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    @Override
    public Armor getSeeArmor(String UnrealID) {
        ArrayList<Armor> candidates = this.getSeeArmors();
        for (Armor it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    @Override
    public Extra getSeeExtra(String UnrealID) {
        ArrayList<Extra> candidates = this.getSeeExtras();
        for (Extra it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    @Override
    public Health getSeeHealth(String UnrealID) {
        ArrayList<Health> candidates = this.getSeeHealths();
        for (Health it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    @Override
    public Item getSeeItem(String UnrealID) {
        ArrayList<Item> candidates = this.getSeeItems();
        for (Item it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    @Override
    public Weapon getSeeWeapon(String UnrealID) {
        ArrayList<Weapon> candidates = this.getSeeWeapons();
        for (Weapon it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    @Override
    public Player getSeePlayer(String UnrealID) {
        ArrayList<Player> candidates = this.getSeePlayers();
        for (Player it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    @Override
    public NavPoint getSeeNavPoint(String UnrealID) {
        ArrayList<NavPoint> candidates = this.getSeeNavPoints();
        for (NavPoint it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    @Override
    public Mover getSeeMover(String UnrealID) {
        ArrayList<Mover> candidates = this.getSeeMovers();
        for (Mover it : candidates) {
            if (!it.UnrealID.equals(UnrealID)) continue;
            return it;
        }
        return null;
    }

    protected void clearListeners() {
        this.armor.clearListeners();
        this.currentAmmo.clearListeners();
        this.health.clearListeners();
        this.location.clearListeners();
        this.name.clearListeners();
        this.rotation.clearListeners();
        this.shooting.clearListeners();
        this.team.clearListeners();
        this.shooting.clearListeners();
        this.velocity.clearListeners();
        this.weapon.clearListeners();
    }
}

