/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddAmmo;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.ChangedWeapon;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Self;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.communication.CommunicationState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class AgentInventory
implements RcvMsgListener {
    private ArrayList<AddWeapon> weapons = new ArrayList();
    private ArrayList<AddAmmo> extraAmmo = new ArrayList();
    private Logger platformLog = null;
    private int currentWeapon = -1;
    private static int melee = 5000;

    public AgentInventory(AgentBody body, Logger logger) {
        this.platformLog = logger;
        body.addTypedRcvMsgListener(this, MessageType.ADD_WEAPON);
        body.addTypedRcvMsgListener(this, MessageType.ADD_AMMO);
        body.addTypedRcvMsgListener(this, MessageType.ADD_SPECIAL);
        body.addTypedRcvMsgListener(this, MessageType.CHANGED_WEAPON);
        body.addTypedRcvMsgListener(this, MessageType.SELF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartInventory() {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            this.currentWeapon = -1;
            this.weapons = new ArrayList();
            this.extraAmmo = new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean anyLoaded() {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            AddWeapon weapon;
            Iterator<AddWeapon> iterator = this.weapons.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                weapon = iterator.next();
            } while (weapon.weaponType.equals((Object)ItemType.SHIELD_GUN) || weapon.currentAmmo <= 0);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWeapon(AddWeapon newWeapon) {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            ArrayList<AddAmmo> arrayList2 = this.extraAmmo;
            synchronized (arrayList2) {
                int i = 0;
                while (i < this.extraAmmo.size()) {
                    if (this.extraAmmo.get((int)i).weaponType.equals((Object)newWeapon.weaponType)) {
                        newWeapon.currentAmmo += this.extraAmmo.get((int)i).ammoAmount;
                        this.extraAmmo.remove(i);
                    }
                    ++i;
                }
                if (newWeapon.currentAmmo > newWeapon.maxAmmo) {
                    newWeapon.currentAmmo = newWeapon.maxAmmo;
                }
            }
        }
        this.addWeaponToWeapons(newWeapon);
    }

    protected void addWeaponToWeapons(AddWeapon newWeapon) {
        AddWeapon temp = null;
        for (AddWeapon weapon : this.weapons) {
            if (!weapon.weaponType.equals((Object)newWeapon.weaponType)) continue;
            temp = weapon;
            break;
        }
        if (temp != null) {
            temp.currentAmmo += newWeapon.currentAmmo;
            if (temp.currentAmmo > temp.maxAmmo) {
                temp.currentAmmo = temp.maxAmmo;
            }
        } else {
            this.weapons.add(newWeapon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddWeapon getWeapon(boolean isMelee) {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            for (AddWeapon weapon : this.weapons) {
                if (weapon.isMelee() != isMelee || weapon.currentAmmo <= 0 || weapon.getWeaponType().equals((Object)ItemType.SHIELD_GUN)) continue;
                return weapon;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddWeapon getWeapon() {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            for (AddWeapon weapon : this.weapons) {
                if (weapon.currentAmmo <= 0 || weapon.weaponType.equals((Object)ItemType.SHIELD_GUN)) continue;
                return weapon;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zeroAmmo(int ID) {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            for (AddWeapon weapon : this.weapons) {
                if (ID != weapon.getID()) continue;
                weapon.currentAmmo = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectAmmo(AddAmmo ammo) {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            boolean hasTheWeaponInInventory = false;
            for (AddWeapon weapon : this.weapons) {
                if (!ammo.weaponType.equals((Object)weapon.getWeaponType())) continue;
                weapon.currentAmmo += ammo.ammoAmount;
                if (weapon.currentAmmo > weapon.maxAmmo) {
                    weapon.currentAmmo = weapon.maxAmmo;
                }
                hasTheWeaponInInventory = true;
            }
            ArrayList<AddAmmo> arrayList2 = this.extraAmmo;
            synchronized (arrayList2) {
                if (!hasTheWeaponInInventory) {
                    this.extraAmmo.add(ammo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean suitableAmmo(Ammo ammo) {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            AddWeapon weapon;
            Iterator<AddWeapon> iterator = this.weapons.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                weapon = iterator.next();
            } while (!ammo.getAmmoType().equals((Object)weapon.getWeaponType()));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeWeapon(ChangedWeapon change) {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            int position = 0;
            boolean correct = false;
            position = 0;
            while (position < this.weapons.size()) {
                if (change.cls.equals(this.weapons.get((int)position).cls)) {
                    this.currentWeapon = position;
                    correct = true;
                    break;
                }
                ++position;
            }
            if (!correct) {
                this.platformLog.warning("Trying to change to weapon which is not in the inventory - possibly corrupted inventory!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddWeapon getCurrentWeapon() {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            block4: {
                if (this.currentWeapon >= 0) break block4;
                return null;
            }
            return this.weapons.get(this.currentWeapon);
        }
    }

    public String toString() {
        return this.weapons.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSelf(Self selfMsg) {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            if (selfMsg.weapon == "None") {
                this.platformLog.info("Weapon is NONE!!!");
                this.currentWeapon = -1;
            }
            if (this.currentWeapon >= 0) {
                int ammo = selfMsg.currentAmmo;
                String curSelfWeapon = selfMsg.weapon;
                AddWeapon curWeap = this.weapons.get(this.currentWeapon);
                if (curWeap.UnrealID.equals(curSelfWeapon)) {
                    if (ammo != curWeap.currentAmmo) {
                        curWeap.currentAmmo = ammo;
                    }
                } else {
                    int prevWeaponIndex = this.currentWeapon;
                    int i = 0;
                    while (i < this.weapons.size()) {
                        if (this.weapons.get((int)i).UnrealID.equals(curSelfWeapon)) {
                            this.platformLog.fine("search for Weapon - the one set (" + this.currentWeapon + "} is incorrect: " + i);
                            this.currentWeapon = i;
                        }
                        ++i;
                    }
                    if (prevWeaponIndex == this.currentWeapon) {
                        this.currentWeapon = -1;
                        this.platformLog.warning("incorrect Inventory status. CurrentWeapon index: " + this.currentWeapon);
                        this.platformLog.warning("Current inventory contains: " + this.weapons.toString());
                    }
                }
            }
        }
    }

    @Override
    public void receiveMessage(RcvMsgEvent e) {
        if (e.getCommunicationState() != CommunicationState.BOT_RUNNING) {
            return;
        }
        MessageObject temp = e.getMessage();
        switch (temp.type) {
            case ADD_AMMO: {
                this.collectAmmo((AddAmmo)temp);
                break;
            }
            case ADD_WEAPON: {
                this.addWeapon((AddWeapon)temp);
                this.platformLog.fine("Obtained weapon: " + temp + "\n Inventory: " + this.weapons.toString());
                break;
            }
            case ADD_SPECIAL: {
                break;
            }
            case SELF: {
                this.processSelf((Self)temp);
                break;
            }
            case CHANGED_WEAPON: {
                this.changeWeapon((ChangedWeapon)temp);
                this.platformLog.info("Switch to weapon: " + temp + "\n Inventory: " + this.weapons.toString());
                this.platformLog.info("Inventory Status!!!: " + this.weapons.toString());
                break;
            }
            default: {
                this.platformLog.warning("Unexpected message received: " + temp.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasWeaponOfType(ItemType type) {
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            AddWeapon weapon;
            Iterator<AddWeapon> iterator = this.weapons.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                weapon = iterator.next();
            } while (weapon.weaponType != type);
            return true;
        }
    }

    public int numberOfWeapons() {
        return this.weapons.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfLoadedWeapons() {
        int counter = 0;
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            for (AddWeapon weapon : this.weapons) {
                if (weapon.currentAmmo <= 0) continue;
                ++counter;
            }
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddWeapon getBetterWeapon(Triple from, Triple to) {
        double distance = Triple.distanceInSpace(from, to);
        if (this.currentWeapon == -1) {
            return null;
        }
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            AddWeapon choosenWeapon;
            block6: {
                choosenWeapon = null;
                for (AddWeapon weapon : this.weapons) {
                    if (!((double)weapon.maxDist > distance) || !weapon.isLoaded() || choosenWeapon != null && choosenWeapon.effectiveDist <= weapon.effectiveDist) continue;
                    choosenWeapon = weapon;
                }
                if (choosenWeapon != null && !choosenWeapon.UnrealID.equals(this.weapons.get((int)this.currentWeapon).UnrealID)) break block6;
                return null;
            }
            return choosenWeapon;
        }
    }

    public ArrayList<AddWeapon> getAllWeapons() {
        return this.weapons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AddWeapon> getCopyOfAllWeapons() {
        ArrayList<AddWeapon> result = new ArrayList<AddWeapon>();
        ArrayList<AddWeapon> arrayList = this.weapons;
        synchronized (arrayList) {
            for (AddWeapon weapon : this.weapons) {
                result.add((AddWeapon)weapon.clone());
            }
        }
        return result;
    }
}

