/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.AgentInitializer;
import cz.cuni.pogamut.Client.Commands;
import cz.cuni.pogamut.Client.KnownObjects;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.Client.SendCmdEvent;
import cz.cuni.pogamut.Client.SendCmdListener;
import cz.cuni.pogamut.MessageObjects.AddAmmo;
import cz.cuni.pogamut.MessageObjects.AddArmor;
import cz.cuni.pogamut.MessageObjects.AddExtra;
import cz.cuni.pogamut.MessageObjects.AddHealth;
import cz.cuni.pogamut.MessageObjects.AddItem;
import cz.cuni.pogamut.MessageObjects.AddSpecial;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Command;
import cz.cuni.pogamut.MessageObjects.CommandTypes;
import cz.cuni.pogamut.MessageObjects.DominationPoint;
import cz.cuni.pogamut.MessageObjects.Extra;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.ItemCathegories;
import cz.cuni.pogamut.MessageObjects.ItemCathegory;
import cz.cuni.pogamut.MessageObjects.ItemList;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavList;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.SynchronousMessages;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.communication.CommunicationState;
import cz.cuni.pogamut.communication.Mediator;
import cz.cuni.pogamut.communication.MediatorClientInterface;
import cz.cuni.pogamut.exceptions.CantCloseConnectionException;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.utils.Flag;
import cz.cuni.utils.UnrealUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;

public class AgentBody
implements MediatorClientInterface,
Commands {
    protected Mediator mediator = null;
    protected String desiredName = null;
    public AgentInitializer initializer = new AgentInitializer();
    protected String lastSentCommand = null;
    protected int moveCounter = 0;
    protected Flag<CommunicationState> communicationState = new Flag<CommunicationState>(CommunicationState.START);
    protected CountDownLatch fireLogicLatch = new CountDownLatch(1);
    protected CountDownLatch navpointsItemsReceivedLatch = new CountDownLatch(1);
    protected Flag<Boolean> exceptionOccured = new Flag<Boolean>(false);
    public KnownObjects knownObjects;
    protected Logger platformLog = null;
    private ArrayList<RcvMsgListener> messageListeners = new ArrayList();
    private HashMap<MessageType, ArrayList<RcvMsgListener>> typeMessageListeners = new HashMap(MessageType.values().length);
    private ArrayList<SendCmdListener> commandListeners = new ArrayList();

    protected void bindMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    public void addRcvMsgListener(RcvMsgListener listener) {
        this.messageListeners.add(listener);
    }

    public void addTypedRcvMsgListener(RcvMsgListener listener, MessageType type) {
        if (this.typeMessageListeners.get((Object)type) == null) {
            this.typeMessageListeners.put(type, new ArrayList());
        }
        this.typeMessageListeners.get((Object)type).add(listener);
    }

    public void addRcvMsgListener(RcvMsgListener listener, Collection<MessageType> types) {
        Iterator<MessageType> x = types.iterator();
        while (x.hasNext()) {
            this.typeMessageListeners.get((Object)x.next()).add(listener);
        }
    }

    public void removeRcvMsgListener(RcvMsgListener listener) {
        this.messageListeners.remove(listener);
    }

    public void removeTypedRcvMsgListener(RcvMsgListener listener, MessageType type) {
        this.typeMessageListeners.get((Object)type).remove(listener);
    }

    public void addSendCmdListener(SendCmdListener listener) {
        this.commandListeners.add(listener);
    }

    public void removeSendCmdListener(SendCmdListener listener) {
        this.commandListeners.remove(listener);
    }

    public void fireEvent(RcvMsgEvent e) {
        int i = 0;
        while (i < this.messageListeners.size()) {
            this.messageListeners.get(i).receiveMessage(e);
            ++i;
        }
        MessageType type = e.getMessage().getType();
        if (this.typeMessageListeners.get((Object)type) != null) {
            int i2 = 0;
            while (i2 < this.typeMessageListeners.get((Object)type).size()) {
                this.typeMessageListeners.get((Object)type).get(i2).receiveMessage(e);
                ++i2;
            }
        } else {
            this.platformLog.warning("Typed message listener not in the present: " + String.valueOf((Object)type));
        }
    }

    public void fireCommandEvent(SendCmdEvent e) {
        int i = 0;
        while (i < this.commandListeners.size()) {
            this.commandListeners.get(i).receiveMessage(e);
            ++i;
        }
    }

    public AgentBody(Logger logger) {
        this.knownObjects = new KnownObjects();
        this.platformLog = logger;
        MessageType[] messageTypeArray = MessageType.values();
        int n = messageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageType type = messageTypeArray[n2];
            this.typeMessageListeners.put(type, new ArrayList());
            ++n2;
        }
    }

    protected void bindName(String name) {
        this.initializer.setName(name);
    }

    protected String getBindedName() {
        return this.initializer.getName();
    }

    public boolean isNameBinded() {
        return this.initializer.getName() != null;
    }

    protected void fixNeighNavs() {
        this.platformLog.config("Processing neighbours navpoint.");
        ArrayList<MessageObject> navPoints = this.knownObjects.getObjectsOfType(MessageType.NAV_POINT);
        int i = 0;
        while (i < navPoints.size()) {
            NavPoint nv = (NavPoint)navPoints.get(i);
            if (nv.neighbours == null) {
                nv.neighbours = new ArrayList();
            }
            int j = 0;
            while (j < nv.neighbours.size()) {
                NeighNav nn = nv.neighbours.get(j);
                nn.neighbour = (NavPoint)this.knownObjects.getObject(nn.ID);
                ++j;
            }
            ++i;
        }
    }

    private void searchNavsForItems() {
        this.platformLog.config("Searching navpoints for items.");
        ArrayList<MessageObject> navs = this.knownObjects.getObjectsOfType(MessageType.NAV_POINT);
        for (NavPoint navPoint : navs) {
            if (navPoint.itemID != 0) {
                navPoint.item = (Item)this.knownObjects.getObject(navPoint.itemID);
                navPoint.item.navPoint = navPoint;
                navPoint.item.visible = false;
                navPoint.item.reachable = false;
                this.fireEvent(new RcvMsgEvent(this, navPoint.item, this.communicationState.getFlag()));
                Item item = this.processItem(navPoint.item);
                if (item != null) {
                    this.fireEvent(new RcvMsgEvent(this, item, this.communicationState.getFlag()));
                }
            }
            navPoint.visible = false;
            navPoint.reachable = false;
        }
    }

    @Override
    public String receiveMessageFromClient() {
        return null;
    }

    public Flag<CommunicationState> getCommunicationStateFlag() {
        return this.communicationState;
    }

    @Override
    public void sendMessageToClient(MessageObject msg) {
        if (this.exceptionOccured.getFlag().booleanValue()) {
            return;
        }
        if (msg.type == MessageType.DISCONNECTED) {
            this.platformLog.severe("Communication socket closed by remote side.");
            this.exceptionOccured.setFlag(true);
            return;
        }
        NavList nl = null;
        ItemList il = null;
        switch (this.communicationState.getFlag()) {
            case START: {
                if (msg.type != MessageType.HELLO_BOT) {
                    this.platformLog.severe("CommunicationState is START but different message then HELLO received - terminating.");
                    this.platformLog.finest("Switching communication state to FAIL.");
                    this.communicationState.setFlag(CommunicationState.FAIL);
                    return;
                }
                this.platformLog.info("HELLO message received, sending READY and switching to MAP_RECEIVE_NFO");
                this.sendCommand(new Command("READY", CommandTypes.READY));
                this.platformLog.finest("Switching communication state to MAP_RECEIVE_NFO.");
                this.communicationState.setFlag(CommunicationState.MAP_RECEIVE_NFO);
                return;
            }
            case MAP_RECEIVE_NFO: {
                if (msg.type != MessageType.GAME_INFO) {
                    this.platformLog.severe("CommunicationState is MAP_RECEIVE_NFO but different message then NFO received - terminating.");
                    this.platformLog.finest("Switching communication state to FAIL.");
                    this.communicationState.setFlag(CommunicationState.FAIL);
                    return;
                }
                this.platformLog.info("NFO message received -> switching to MAP_RECEIVE_NAVPOINTS_EXPECTED");
                this.messageReceived(msg);
                this.platformLog.finest("Switching communication state to MAP_RECEIVE_NAVPOINTS_EXPECTED.");
                this.communicationState.setFlag(CommunicationState.MAP_RECEIVE_NAVPOINTS_EXPECTED);
                return;
            }
            case MAP_RECEIVE_NAVPOINTS_EXPECTED: {
                if (msg.type != MessageType.NAV_LIST) {
                    this.platformLog.severe("CommunicationState is MAP_RECEIVE_NAVPOINTS_EXPECTED but different message then NAVLIST received - terminating.");
                    this.platformLog.finest("Switching communication state to FAIL.");
                    this.communicationState.setFlag(CommunicationState.FAIL);
                    return;
                }
                nl = (NavList)msg;
                if (!nl.sending) {
                    this.platformLog.info("NAVLIST message received but it has wrong 'sending' flag (false) -> terminating.");
                    this.platformLog.finest("Switching communication state to FAIL.");
                    this.communicationState.setFlag(CommunicationState.FAIL);
                    return;
                }
                this.platformLog.info("NAVLIST message received -> switching to MAP_RECEIVING_NAVPOINTS");
                this.platformLog.finest("Switching communication state to MAP_RECEIVING_NAVPOINTS");
                this.communicationState.setFlag(CommunicationState.MAP_RECEIVING_NAVPOINTS);
                return;
            }
            case MAP_RECEIVING_NAVPOINTS: {
                if (msg.type == MessageType.NAV_LIST) {
                    nl = (NavList)msg;
                    if (nl.sending) {
                        this.platformLog.info("NAVLIST message received but it has wrong 'sending' flag (true) -> terminating.");
                        this.platformLog.finest("Switching communication state to FAIL");
                        this.communicationState.setFlag(CommunicationState.FAIL);
                        return;
                    }
                    this.platformLog.info("Map's navigation points received. Switching to MAP_RECEIVE_ITEMS_EXPECTED");
                    this.platformLog.finest("Switching communication state to MAP_RECEIVE_ITEMS_EXPECTED");
                    this.communicationState.setFlag(CommunicationState.MAP_RECEIVE_ITEMS_EXPECTED);
                    return;
                }
                if (msg.type != MessageType.NAV_POINT) {
                    this.platformLog.severe("CommunicationState is MAP_RECEIVING_NAVPOINTS but different message then NAV_POINT received - terminating.");
                    this.platformLog.finest("Switching communication state to FAIL");
                    this.communicationState.setFlag(CommunicationState.FAIL);
                    return;
                }
                this.messageReceived(msg);
                return;
            }
            case MAP_RECEIVE_ITEMS_EXPECTED: {
                if (msg.type != MessageType.ITEM_LIST) {
                    this.platformLog.severe("CommunicationState is MAP_RECEIVE_ITEM_EXPECTED but different message then ITEM_LIST received - terminating.");
                    this.platformLog.finest("Switching communication state to FAIL");
                    this.communicationState.setFlag(CommunicationState.FAIL);
                    return;
                }
                il = (ItemList)msg;
                if (!il.sending) {
                    this.platformLog.info("ITEM_LIST message received but it has wrong 'sending' flag (false) -> terminating.");
                    this.platformLog.finest("Switching communication state to FAIL");
                    this.communicationState.setFlag(CommunicationState.FAIL);
                    return;
                }
                this.platformLog.info("ITEM_LIST message received -> switching to MAP_RECEIVEING_ITEMS");
                this.platformLog.finest("Switching communication state to MAP_RECEIVING_ITEMS");
                this.communicationState.setFlag(CommunicationState.MAP_RECEIVING_ITEMS);
                return;
            }
            case MAP_RECEIVING_ITEMS: {
                if (msg.type == MessageType.ITEM_LIST) {
                    il = (ItemList)msg;
                    if (il.sending) {
                        this.platformLog.info("ITEM_LIST message received but it has wrong 'sending' flag (true) -> terminating.");
                        this.platformLog.finest("Switching communication state to FAIL");
                        this.communicationState.setFlag(CommunicationState.FAIL);
                        return;
                    }
                    this.platformLog.info("Map's items received. Proccessing navpoints and items.");
                    this.fixNeighNavs();
                    this.searchNavsForItems();
                    this.platformLog.info("Navpoints and items processed, switching to AWAITING_LOGIC. Going to sleep until logic is ready.");
                    this.platformLog.finest("Switching communication state to AWAITING_LOGIC");
                    this.communicationState.setFlag(CommunicationState.AWAITING_LOGIC);
                    this.navpointsItemsReceivedLatch.countDown();
                    try {
                        this.fireLogicLatch.await();
                    }
                    catch (InterruptedException e) {
                        this.platformLog.info("Thread interrupted while awaiting logic to run -> terminating.");
                        this.communicationState.setFlag(CommunicationState.FAIL);
                        return;
                    }
                    this.platformLog.info("Logic is ready - sending INIT and switching to BOT_RUNNING..");
                    this.sendCommand(new Command(this.initializer.constructInitMessage(), CommandTypes.INIT));
                    this.platformLog.finest("Switching communication state to BOT_RUNNING");
                    this.communicationState.setFlag(CommunicationState.BOT_RUNNING);
                    return;
                }
                if (msg.type != MessageType.ITEM) {
                    this.platformLog.severe("CommunicationState is MAP_RECEIVING_ITEMS but different message then ITEM received - terminating.");
                    this.platformLog.finest("Switching communication state to FAIL");
                    this.communicationState.setFlag(CommunicationState.FAIL);
                    return;
                }
                this.messageReceived(msg);
                return;
            }
            case BOT_RUNNING: {
                this.messageReceived(msg);
                return;
            }
            case PAUSED: {
                if (msg.type == MessageType.GAME_RESUMED || msg.type == MessageType.GAME_PAUSED) {
                    this.messageReceived(msg);
                    return;
                }
                this.platformLog.severe("CommunicationState is " + this.communicationState.getFlag().toString() + " - and message came (" + msg.toString() + ") something is wrong...");
                break;
            }
            default: {
                this.platformLog.severe("CommunicationState is " + this.communicationState.getFlag().toString() + " - forbidden, terminating.");
            }
        }
    }

    protected void messageReceived(MessageObject msg) {
        MessageObject newMessage = this.processNewMessage(msg);
        if (newMessage != null) {
            switch (newMessage.type) {
                case ITEM: {
                    Item itemEvent = (Item)newMessage;
                    if (itemEvent.isEventSee()) {
                        Item item = this.processItem((Item)newMessage);
                        if (item != null) {
                            this.fireEvent(new RcvMsgEvent(this, item, this.communicationState.getFlag()));
                            break;
                        }
                        item = (Item)newMessage;
                        Extra ext = new Extra(item.ID, item.UnrealID, item.cls, item.location, item.reachable, item.visible, item.navPoint);
                        this.fireEvent(new RcvMsgEvent(this, ext, this.communicationState.getFlag()));
                        break;
                    }
                    if (itemEvent.isEventPickup()) {
                        AddItem addItem = this.processAddItem((Item)newMessage);
                        if (addItem != null) {
                            this.fireEvent(new RcvMsgEvent(this, addItem, this.communicationState.getFlag()));
                            break;
                        }
                        AddExtra addExt = new AddExtra(itemEvent.ID, itemEvent.UnrealID, itemEvent.ID, itemEvent.cls);
                        this.fireEvent(new RcvMsgEvent(this, addExt, this.communicationState.getFlag()));
                        break;
                    }
                    this.platformLog.severe("Wrong item event (" + itemEvent.event + "), message: " + itemEvent.toString());
                    break;
                }
                case ADD_ITEM: {
                    AddItem addItem = this.processAddItem((AddItem)newMessage);
                    if (addItem != null) {
                        this.fireEvent(new RcvMsgEvent(this, addItem, this.communicationState.getFlag()));
                        break;
                    }
                    addItem = (AddItem)newMessage;
                    AddExtra addExt = new AddExtra(addItem.ID, addItem.UnrealID, addItem.itemID, addItem.cls);
                    this.fireEvent(new RcvMsgEvent(this, addExt, this.communicationState.getFlag()));
                    break;
                }
                case PLAYER: {
                    if (newMessage.visible) break;
                    System.out.println("FALSE");
                }
            }
            this.fireEvent(new RcvMsgEvent(this, newMessage, this.communicationState.getFlag()));
        }
    }

    public MessageObject processNewMessage(MessageObject newMessage) {
        if (newMessage.getID() == 0) {
            return newMessage;
        }
        switch (newMessage.type) {
            case PATH: {
                return newMessage;
            }
        }
        if (SynchronousMessages.synchroMessages.contains((Object)newMessage.getType())) {
            if (this.knownObjects.contains(newMessage.getID())) {
                if (newMessage.getClass() == DominationPoint.class) {
                    return newMessage;
                }
                MessageObject old = this.knownObjects.getObject(newMessage.getID());
                old.update(newMessage);
                return (MessageObject)old.clone();
            }
            this.knownObjects.addObject(newMessage);
            return (MessageObject)newMessage.clone();
        }
        return newMessage;
    }

    public Item processItem(Item newMessage) {
        return ItemCathegories.processItem(newMessage);
    }

    public AddItem processAddItem(AddItem newMessage) {
        String name = newMessage.cls;
        ItemCathegory properties = ItemCathegories.cathegories.get(name = name.substring(name.indexOf(46) + 1));
        if (properties == null) {
            return null;
        }
        switch (properties.msgType) {
            case AMMO: {
                return new AddAmmo(newMessage.ID, newMessage.UnrealID, newMessage.itemID, newMessage.cls, properties.data[0], properties.itemType);
            }
            case ARMOR: {
                return new AddArmor(newMessage.ID, newMessage.UnrealID, newMessage.itemID, newMessage.cls, properties.data[0], properties.itemType);
            }
            case HEALTH: {
                boolean boostable = false;
                if (properties.data[1] > 0) {
                    boostable = true;
                }
                return new AddHealth(newMessage.ID, newMessage.UnrealID, newMessage.itemID, newMessage.cls, properties.data[0], properties.itemType, boostable);
            }
            case WEAPON: {
                boolean melee = false;
                if (properties.data[0] > 0) {
                    melee = true;
                }
                return new AddWeapon(newMessage.ID, newMessage.UnrealID, newMessage.itemID, newMessage.cls, melee, properties.data[1], properties.data[2], properties.itemType, properties.data[3], properties.data[4]);
            }
            case SPECIAL: {
                return new AddSpecial(newMessage.ID, newMessage.UnrealID, newMessage.itemID, properties.itemType, newMessage.cls);
            }
        }
        return null;
    }

    public AddItem processAddItem(Item newMessage) {
        String name = newMessage.cls;
        ItemCathegory properties = ItemCathegories.cathegories.get(name = name.substring(name.indexOf(46) + 1));
        if (properties == null) {
            return null;
        }
        switch (properties.msgType) {
            case AMMO: {
                return new AddAmmo(newMessage.ID, newMessage.UnrealID, newMessage.ID, newMessage.cls, properties.data[0], properties.itemType);
            }
            case ARMOR: {
                return new AddArmor(newMessage.ID, newMessage.UnrealID, newMessage.ID, newMessage.cls, properties.data[0], properties.itemType);
            }
            case HEALTH: {
                boolean boostable = false;
                if (properties.data[1] > 0) {
                    boostable = true;
                }
                return new AddHealth(newMessage.ID, newMessage.UnrealID, newMessage.ID, newMessage.cls, properties.data[0], properties.itemType, boostable);
            }
            case WEAPON: {
                boolean melee = false;
                if (properties.data[0] > 0) {
                    melee = true;
                }
                return new AddWeapon(newMessage.ID, newMessage.UnrealID, newMessage.ID, newMessage.cls, melee, properties.data[1], properties.data[2], properties.itemType, properties.data[3], properties.data[4]);
            }
            case SPECIAL: {
                return new AddSpecial(newMessage.ID, newMessage.UnrealID, newMessage.ID, properties.itemType, newMessage.cls);
            }
        }
        return null;
    }

    public void sendCommand(Command content) {
        if (this.exceptionOccured.getFlag().booleanValue()) {
            this.platformLog.severe("Can't send command to GameBot, connection down. Cmd: " + content + ")");
            return;
        }
        if (content.toString().indexOf("MOVE") != -1 && content.toString().compareTo(this.lastSentCommand) == 0 && this.moveCounter < 5) {
            ++this.moveCounter;
            return;
        }
        this.moveCounter = 0;
        this.fireCommandEvent(new SendCmdEvent(this, content));
        try {
            this.mediator.sendMessageToGB(content);
            this.lastSentCommand = content.toString();
        }
        catch (CantWriteException e) {
            this.platformLog.severe("Can't send command to GameBot, connection down. Cmd: " + content + ")");
            this.exceptionOccured.setFlag(true);
        }
    }

    @Override
    public void turn(int pitch, int yaw, int roll) {
        pitch = UnrealUtils.degreeToUnrealDegrees(pitch);
        yaw = UnrealUtils.degreeToUnrealDegrees(yaw);
        roll = UnrealUtils.degreeToUnrealDegrees(roll);
        String content = "TURNTO {Rotation " + String.valueOf(pitch) + " " + String.valueOf(yaw) + " ";
        content = String.valueOf(content) + String.valueOf(roll) + "}";
        this.sendCommand(new Command(content, CommandTypes.TURN_TO));
    }

    @Override
    public void turnToLocation(Triple location) {
        if (location != null) {
            this.sendCommand(new Command("TURNTO {Location " + location.toString() + "}", CommandTypes.TURN_TO));
        } else {
            this.platformLog.warning("Invalid location!");
        }
    }

    @Override
    public void turnToTarget(MessageObject target) {
        if (target != null && target.getUnrealID() != null) {
            this.sendCommand(new Command("TURNTO {Target " + target.getUnrealID() + "}", CommandTypes.TURN_TO));
        } else {
            this.platformLog.warning("Invalid target!");
        }
    }

    public void getPath(Triple location, int ID) {
        if (location != null) {
            this.sendCommand(new Command("GETPATH {ID " + ID + "}" + " {Location " + location.toString() + "}", CommandTypes.GET_PATH));
        } else {
            this.platformLog.warning("Invalid location!");
        }
    }

    @Override
    public void changeToBestWeapon() {
        String content = "CHANGEWEAPON {Id Best}";
        this.sendCommand(new Command(content, CommandTypes.CHANGE_WEAPON));
    }

    @Override
    public void changeWeapon(AddWeapon newWeapon) {
        if (newWeapon != null && newWeapon.getUnrealID() != null) {
            this.sendCommand(new Command("CHANGEWEAPON {Id " + newWeapon.getUnrealID() + "}", CommandTypes.CHANGE_WEAPON));
        } else {
            this.platformLog.warning("Invalid weapon!");
        }
    }

    @Override
    public void getPathToLocation(int ID, Triple location) {
        if (location != null) {
            String content = "GETPATH {Id " + String.valueOf(ID) + "}";
            content = String.valueOf(content) + " {Location " + location.toString() + "}";
            this.sendCommand(new Command(content, CommandTypes.GET_PATH));
        } else {
            this.platformLog.warning("Invalid location!");
        }
    }

    @Override
    public void getPathToNavPoint(int ID, NavPoint navPoint) {
        if (navPoint != null && navPoint.location != null) {
            String content = "GETPATH {Id " + String.valueOf(ID) + "}";
            content = String.valueOf(content) + " {Location " + navPoint.location.toString() + "}";
            this.sendCommand(new Command(content, CommandTypes.GET_PATH));
        } else {
            this.platformLog.warning("Invalid navPoint!");
        }
    }

    @Override
    public void jump() {
        this.sendCommand(new Command("JUMP", CommandTypes.JUMP));
    }

    @Override
    public void doubleJump() {
        this.sendCommand(new Command("JUMP", CommandTypes.JUMP));
    }

    @Override
    public void ping() {
        this.sendCommand(new Command("PING", CommandTypes.PING));
    }

    @Override
    public void requestReachcheckLocation(int ID, Triple to, Triple from) {
        if (to != null && from != null) {
            String content = "CHECKREACH {Id " + String.valueOf(ID) + "}";
            content = String.valueOf(content) + " {Location " + to.toString() + "}";
            content = String.valueOf(content) + " {From " + from.toString() + "}";
            this.sendCommand(new Command(content, CommandTypes.CHECK_REACH));
        } else {
            this.platformLog.warning("Invalid to or from!");
        }
    }

    @Override
    public void requestReachcheckTargetFrom(int ID, MessageObject target, Triple from) {
        if (target != null && target.getUnrealID() != null && from != null) {
            String content = "CHECKREACH {Id " + String.valueOf(ID) + "}";
            content = String.valueOf(content) + " {Target " + target.getUnrealID() + "}";
            content = String.valueOf(content) + " {From " + from.toString() + "}";
            this.sendCommand(new Command(content, CommandTypes.CHECK_REACH));
        } else {
            this.platformLog.warning("Invalid target or from!");
        }
    }

    @Override
    public void turnHorizontal(int amount) {
        amount = UnrealUtils.degreeToUnrealDegrees(amount);
        String content = "ROTATE {Amount " + String.valueOf(amount) + "}";
        content = String.valueOf(content) + " {Axis Horizontal}";
        this.sendCommand(new Command(content, CommandTypes.ROTATE));
    }

    @Override
    public void turnVertical(int amount) {
        amount = UnrealUtils.degreeToUnrealDegrees(amount);
        String content = "ROTATE {Amount " + String.valueOf(amount) + "}";
        content = String.valueOf(content) + " {Axis Vertical}";
        this.sendCommand(new Command(content, CommandTypes.ROTATE));
    }

    protected void generalRunToLocation(Triple location) {
        String content = "MOVE {Speed 1.0} {Location1 " + location.toString() + "} " + "{Location2 " + location.toString() + "}";
        this.sendCommand(new Command(content, CommandTypes.MOVE));
    }

    @Override
    public void runToLocation(Triple location) {
        if (location != null) {
            this.generalRunToLocation(location);
        } else {
            this.platformLog.warning("Invalid location!");
        }
    }

    @Override
    public void runToNavPoint(NavPoint target) {
        if (target != null && target.getUnrealID() != null && target.getLocation() != null) {
            this.generalRunToLocation(target.getLocation());
        } else {
            this.platformLog.warning("Invalid target!");
        }
    }

    @Override
    public void runToTarget(MessageObject target) {
        if (target != null && target.getUnrealID() != null) {
            String content = "RUNTO {Target " + target.getUnrealID() + "}";
            content = String.valueOf(content) + " {Speed 800}";
            content = String.valueOf(content) + " {Accel 600}";
            this.sendCommand(new Command(content, CommandTypes.RUN_TO));
        } else {
            this.platformLog.warning("Invalid target!");
        }
    }

    public void runToTarget(Item target) {
        if (target != null && target.getUnrealID() != null) {
            this.generalRunToLocation(target.location);
        } else {
            this.platformLog.warning("Invalid target!");
        }
    }

    public void runToTarget(Player target) {
        if (target != null && target.getUnrealID() != null) {
            this.generalRunToLocation(target.location);
        } else {
            this.platformLog.warning("Invalid target!");
        }
    }

    @Override
    public void sendGlobalMessage(String text) {
        this.sendCommand(new Command("MESSAGE {Text " + text + "} {Global True}", CommandTypes.MESSAGE));
    }

    @Override
    public void sendPrivateMessage(String text) {
        this.sendCommand(new Command("MESSAGE {Text " + text + "}", CommandTypes.MESSAGE));
    }

    @Override
    public void setRun() {
        this.sendCommand(new Command("SETWALK { WalkTrue}", CommandTypes.SET_WALK));
    }

    @Override
    public void setWalk() {
        this.sendCommand(new Command("SETWALK { WalkFalse}", CommandTypes.SET_WALK));
    }

    @Override
    public void shoot(Player target) {
        if (target != null) {
            String content = "SHOOT {Location " + target.location.toString() + "}";
            content = String.valueOf(content) + " {Target " + target.getUnrealID() + "}";
            this.sendCommand(new Command(content, CommandTypes.SHOOT));
        } else {
            this.platformLog.warning("Invalid target or location!");
        }
    }

    @Override
    public void shootAlternate(Player target) {
        if (target != null) {
            String content = "SHOOT {Location " + target.location.toString() + "}";
            content = String.valueOf(content) + " {Target " + target.getUnrealID() + "}";
            content = String.valueOf(content) + " {Alt True}";
            this.sendCommand(new Command(content, CommandTypes.SHOOT));
        } else {
            this.platformLog.warning("Invalid target or location!");
        }
    }

    @Override
    public void shoot(Triple location) {
        if (location != null) {
            String content = "SHOOT {Location " + location.toString() + "}";
            this.sendCommand(new Command(content, CommandTypes.SHOOT));
        } else {
            this.platformLog.warning("Invalid target or location!");
        }
    }

    @Override
    public void shootAlternate(Triple location) {
        if (location != null) {
            String content = "SHOOT {Location " + location.toString() + "}";
            content = String.valueOf(content) + " {Alt True}";
            this.sendCommand(new Command(content, CommandTypes.SHOOT));
        } else {
            this.platformLog.warning("Invalid target or location!");
        }
    }

    @Override
    public void stop() {
        this.sendCommand(new Command("STOP", CommandTypes.STOP));
    }

    @Override
    public void stopShoot() {
        this.sendCommand(new Command("STOPSHOOT", CommandTypes.STOP_SHOOT));
    }

    @Override
    public void strafeToLocation(Triple whereToGo, Triple whereToStrafeTo) {
        if (whereToGo != null && whereToStrafeTo != null) {
            String content = "STRAFE {Location " + whereToGo.toString() + "}";
            content = String.valueOf(content) + " {Focus " + whereToStrafeTo.toString() + "}";
            this.sendCommand(new Command(content, CommandTypes.STRAFE));
        } else {
            this.platformLog.warning("Invalid whereToGo or whereToStrafeTo!");
        }
    }

    @Override
    public void strafeToTarget(MessageObject target, Triple whereToGo) {
        if (target != null && target.getUnrealID() != null && whereToGo != null) {
            String content = "STRAFE {Location " + whereToGo.toString() + "}";
            content = String.valueOf(content) + " {Target " + target.getUnrealID() + "}";
            this.sendCommand(new Command(content, CommandTypes.STRAFE));
        } else {
            this.platformLog.warning("Invalid whereToGo or whereToStrafeTo!");
        }
    }

    public void moveInch() {
        this.sendCommand(new Command("INCH", CommandTypes.INCH));
    }

    public void contMove(float speed) {
        this.sendCommand(new Command("CMOVE {Speed " + speed + "}", CommandTypes.CMOVE));
    }

    public void init(String name) {
        if (name == null) {
            name = "name_not_binded";
        }
        String content = "INIT {Name " + name + "}";
        this.sendCommand(new Command(content, CommandTypes.INIT));
    }

    @Override
    public void init(String name, Triple location) {
        String content = "INIT {Name " + name + "} {Team " + "0" + "} {ManualSpawn " + "false" + "}";
        content = String.valueOf(content) + " {Location " + location.toString() + "} {Rotation " + "0,0,0" + "}";
        this.sendCommand(new Command(content, CommandTypes.INIT));
    }

    @Override
    public void init(String name, int team, Triple location) {
        String content = "INIT {Name " + name + "} {Team " + String.valueOf(team) + "} {ManualSpawn " + "false" + "}";
        content = String.valueOf(content) + " {Location " + location.toString() + "} {Rotation " + "0,0,0" + "}";
        this.sendCommand(new Command(content, CommandTypes.INIT));
    }

    @Override
    public void init(String name, int team, boolean manualSpawn, Triple location, Triple rotation) {
        String content = "INIT {Name " + name + "} {Team " + String.valueOf(team) + "} {ManualSpawn " + manualSpawn + "}";
        content = String.valueOf(content) + " {Location " + location.toString() + "} {Rotation " + rotation.toString() + "}";
        this.sendCommand(new Command(content, CommandTypes.INIT));
    }

    @Override
    public void init(String name, int team, boolean manualSpawn, Triple location, Triple rotation, String skin, double accuracy, boolean targetLead) {
        String content = "INIT {Name " + name + "} {Team " + String.valueOf(team) + "} {ManualSpawn " + manualSpawn + "}";
        content = String.valueOf(content) + " {Location " + location.toString() + "} {Rotation " + rotation.toString() + "}";
        content = String.valueOf(content) + " {Skin " + skin + "} {DesiredAccuracy " + accuracy + "} {ShouldLeadTarget " + targetLead + "}";
        this.sendCommand(new Command(content, CommandTypes.INIT));
    }

    @Override
    public void move(double speed, Triple location1, Triple location2) {
        String content = "MOVE {Speed " + String.valueOf(speed) + "} {Location1 " + location1.toString() + "}";
        content = String.valueOf(content) + " {Location2 " + location2.toString() + "}";
        this.sendCommand(new Command(content, CommandTypes.MOVE));
    }

    @Override
    public void moveAlongNavPoints(double speed, NavPoint nav1, NavPoint nav2) {
        String content = "MOVE {Speed " + String.valueOf(speed) + "} {Location1 " + nav1.location.toString() + "}";
        content = String.valueOf(content) + " {Location2 " + nav2.location.toString() + "}";
        this.sendCommand(new Command(content, CommandTypes.MOVE));
    }

    @Override
    public void respawn(Triple location, Triple rotation) {
        this.sendCommand(new Command("RESPAWN {StartLocation " + location.toString() + " } {Rotation " + rotation.toString() + "}", CommandTypes.RESPAWN));
    }

    @Override
    public void respawn() {
        this.sendCommand(new Command("RESPAWN", CommandTypes.RESPAWN));
    }

    @Override
    public void setCrouch(boolean crouch) {
        this.sendCommand(new Command("SETCROUCH {Crouch" + crouch + "}", CommandTypes.SET_CROUCH));
    }

    @Override
    public void startRecording(String fileName) {
        this.sendCommand(new Command("REC {FileName " + fileName + "}", CommandTypes.REC));
    }

    @Override
    public void stopRecording() {
        this.sendCommand(new Command("STOPREC", CommandTypes.STOP_REC));
    }

    @Override
    public void throwWeapon() {
        this.sendCommand(new Command("THROW", CommandTypes.THROW));
    }

    @Override
    public void trace(int id, Triple to, boolean traceActors) {
        String content = "TRACE {Id " + String.valueOf(id) + "} {To " + to.toString() + "}";
        content = String.valueOf(content) + " {TraceActors " + traceActors + "}";
        this.sendCommand(new Command(content, CommandTypes.TRACE));
    }

    @Override
    public void trace(int id, Triple from, Triple to, boolean traceActors) {
        String content = "TRACE {Id " + String.valueOf(id) + "} {From " + from.toString() + "} {To " + to.toString() + "}";
        content = String.valueOf(content) + " {TraceActors " + traceActors + "}";
        this.sendCommand(new Command(content, CommandTypes.TRACE));
    }

    @Override
    public void fastTrace(int id, Triple from, Triple to) {
        String content = "FTRACE {Id " + String.valueOf(id) + "} {From " + from.toString() + "} {To " + to.toString() + "}";
        this.sendCommand(new Command(content, CommandTypes.FAST_TRACE));
    }

    @Override
    public void fastTrace(int id, Triple to) {
        String content = "FTRACE {Id " + String.valueOf(id) + "} {To " + to.toString() + "}";
        this.sendCommand(new Command(content, CommandTypes.FAST_TRACE));
    }

    @Override
    public void closeClient() throws CantCloseConnectionException {
    }

    @Override
    public void addInventory(String inventoryClass) {
        String content = "ADDINV {Class " + inventoryClass + "}";
        this.sendCommand(new Command(content, CommandTypes.ADD_INV));
    }

    @Override
    public void addRayToAutoTrace(int ID, Triple direction, Double length, boolean fastTrace, boolean traceActors) {
        String content = "ADDRAY {Id " + String.valueOf(ID) + "} {Direction " + direction.toString();
        content = String.valueOf(content) + "} {Length " + String.valueOf(length) + "} {FastTrace " + String.valueOf(fastTrace);
        content = String.valueOf(content) + "} {TraceActors " + String.valueOf(traceActors) + "}";
        this.sendCommand(new Command(content, CommandTypes.ADD_RAY));
    }

    @Override
    public void configure(boolean autoTrace, boolean manualSpawn, String name, boolean invulnerable, double visionTime, boolean showFocalPoint, boolean drawTraceLines, boolean synchronousOff) {
        String content = "CONF {AutoTrace " + String.valueOf(autoTrace) + "} {ManualSpawn ";
        content = String.valueOf(content) + String.valueOf(manualSpawn) + "} {Name " + name + "} {Invulnerable " + String.valueOf(invulnerable);
        content = String.valueOf(content) + "} {VisionTime " + String.valueOf(visionTime) + "} ";
        content = String.valueOf(content) + "{ShowFocalPoint " + String.valueOf(showFocalPoint) + "} ";
        content = String.valueOf(content) + "{DrawTraceLines " + String.valueOf(drawTraceLines) + "} ";
        content = String.valueOf(content) + "{SynchronousOff " + String.valueOf(synchronousOff) + "}";
        this.sendCommand(new Command(content, CommandTypes.CONF));
    }

    @Override
    public void configureAutoTrace(boolean autoTrace) {
        String content = "CONF {AutoTrace " + String.valueOf(autoTrace) + "}";
        this.sendCommand(new Command(content, CommandTypes.CONF));
    }

    @Override
    public void configureInvulnerable(boolean invulnerable) {
        String content = "CONF {Invulnerable " + String.valueOf(invulnerable) + "}";
        this.sendCommand(new Command(content, CommandTypes.CONF));
    }

    @Override
    public void configureManualSpawn(boolean manualSpawn) {
        String content = "CONF {ManualSpawn ";
        content = String.valueOf(content) + String.valueOf(manualSpawn) + "}";
        this.sendCommand(new Command(content, CommandTypes.CONF));
    }

    @Override
    public void configureName(String name) {
        String content = "CONF {Name " + name + "}";
        this.sendCommand(new Command(content, CommandTypes.CONF));
    }

    @Override
    public void configureVisionTime(double visionTime) {
        String content = "CONF {VisionTime " + String.valueOf(visionTime) + "}";
        this.sendCommand(new Command(content, CommandTypes.CONF));
    }

    @Override
    public void removeRayFromAutoTrace(int ID) {
        String content = "REMOVERAY {Id " + String.valueOf(ID) + "}";
        this.sendCommand(new Command(content, CommandTypes.REMOVE_RAY));
    }

    @Override
    public void moveContinuous() {
        this.sendCommand(new Command("CMOVE {Speed 1}", CommandTypes.CMOVE));
    }

    @Override
    public void pauseTheGame() {
        this.sendCommand(new Command("PAUSE {Pause True}", CommandTypes.PAUSE));
    }

    @Override
    public void unpauseTheGame() {
        this.sendCommand(new Command("PAUSE {Pause False}", CommandTypes.PAUSE));
    }

    @Override
    public void removeAllRaysFromAutoTrace() {
        this.sendCommand(new Command("REMOVERAY {Id All}", CommandTypes.REMOVE_RAY));
    }

    @Override
    public void restartAutoTraceRays() {
        this.sendCommand(new Command("ADDRAY {Id Default}", CommandTypes.ADD_RAY));
    }

    @Override
    public void startAutoTrace() {
        this.configureAutoTrace(true);
    }

    @Override
    public void stopAutoTrace() {
        this.configureAutoTrace(false);
    }

    @Override
    public void setLenghtOAutoTrace(int lenght, int ID) {
        this.sendCommand(new Command("ADDRAY {Id " + ID + "} {Lenght " + lenght + "}", CommandTypes.ADD_RAY));
    }

    @Override
    public void setSkin(String name) {
        this.sendCommand(new Command("SETSKIN {Skin " + name + "}", CommandTypes.SETSKIN));
    }

    protected void clearListeners() {
        this.communicationState.clearListeners();
        this.exceptionOccured.clearListeners();
        this.messageListeners.clear();
        this.typeMessageListeners.clear();
        this.commandListeners.clear();
    }
}

