/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.AgentIterationEndEvent;
import cz.cuni.pogamut.Client.AgentIterationEndListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class AgentAux {
    protected Agent agent = null;
    protected static final int STREAM_LOG_FLUSH_INTERVAL = 10;
    protected int streamLogFlushCounter = 0;
    protected Collection<StreamHandler> streamHandlers = new ArrayList<StreamHandler>();
    protected AgentIterationEndListener flushingListener = null;

    public AgentAux(Agent agent) {
        this.agent = agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToStream(Logger log, StreamHandler handler) {
        log.addHandler(handler);
        Collection<StreamHandler> collection = this.streamHandlers;
        synchronized (collection) {
            this.streamHandlers.add(handler);
        }
        if (this.flushingListener == null) {
            this.flushingListener = new AgentIterationEndListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void iterationEnds(AgentIterationEndEvent event) {
                    if (10 < ++AgentAux.this.streamLogFlushCounter) {
                        Collection<StreamHandler> collection = AgentAux.this.streamHandlers;
                        synchronized (collection) {
                            for (StreamHandler h : AgentAux.this.streamHandlers) {
                                h.flush();
                            }
                        }
                        AgentAux.this.streamLogFlushCounter = 0;
                    }
                }
            };
            this.agent.addIterationEndListener(this.flushingListener);
        }
    }

    public void logUserLogToFile(String filePath) throws IOException {
        this.logToStream(this.agent.getLogger(), new FileHandler(filePath));
    }

    public void logPlatformLogToFile(String filePath) throws IOException {
        this.logToStream(this.agent.getPlatformLog(), new FileHandler(filePath));
    }

    public void logUserLogToStream(StreamHandler handler) {
        this.logToStream(this.agent.getLogger(), handler);
    }

    public void logPlatformLogToStream(StreamHandler handler) {
        this.logToStream(this.agent.getPlatformLog(), handler);
    }
}

