/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.astar;

import cz.cuni.astar.AStarHeapIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class AStarHeap
implements Collection {
    private Object[] nodes;
    private int count;
    private int items;
    private HashMap references;
    private Comparator cmp;

    private void grow() {
        Object[] tempNodes = new Object[this.count * 2];
        int i = 0;
        while (i <= this.items) {
            tempNodes[i] = this.nodes[i];
            ++i;
        }
        this.nodes = tempNodes;
        this.count *= 2;
    }

    private int left(int reference) {
        return 2 * reference;
    }

    private int right(int reference) {
        return 2 * reference + 1;
    }

    private int upRef(int reference) {
        return reference / 2;
    }

    private Object getNode(int reference) {
        while (reference >= this.count) {
            this.grow();
        }
        return this.nodes[reference];
    }

    private int downNode(int reference) {
        Object currentNode = this.getNode(reference);
        if (currentNode == null) {
            return reference;
        }
        Object leftNode = null;
        Object rightNode = null;
        int way = 0;
        while (true) {
            way = 0;
            leftNode = this.getNode(this.left(reference));
            rightNode = this.getNode(this.right(reference));
            if (leftNode == null && rightNode == null) {
                this.references.put(currentNode, reference);
                return reference;
            }
            if (rightNode == null) {
                way = -1;
            } else if (leftNode == null) {
                way = 1;
            }
            if (way == 0) {
                way = this.cmp.compare(leftNode, rightNode);
            }
            if (way < 0) {
                if (this.cmp.compare(currentNode, leftNode) > 0) {
                    this.nodes[reference] = leftNode;
                    this.references.put(leftNode, new Integer(reference));
                    reference = this.left(reference);
                    this.nodes[reference] = currentNode;
                    continue;
                }
                this.references.put(currentNode, reference);
                return reference;
            }
            if (this.cmp.compare(currentNode, rightNode) <= 0) break;
            this.nodes[reference] = rightNode;
            this.references.put(rightNode, new Integer(reference));
            reference = this.right(reference);
            this.nodes[reference] = currentNode;
        }
        this.references.put(currentNode, reference);
        return reference;
    }

    private int upNode(int reference) {
        if (reference == 1) {
            return reference;
        }
        Object currentNode = this.getNode(reference);
        if (currentNode == null) {
            return reference;
        }
        Object upNode = null;
        while (reference > 1) {
            upNode = this.getNode(this.upRef(reference));
            if (this.cmp.compare(currentNode, upNode) >= 0) break;
            this.nodes[reference] = upNode;
            this.references.put(upNode, reference);
            reference = this.upRef(reference);
        }
        this.nodes[reference] = currentNode;
        this.references.put(currentNode, reference);
        return reference;
    }

    private void initHeap(int capacity) {
        if (capacity < 2) {
            capacity = 2;
        }
        this.nodes = new Object[capacity];
        this.count = capacity;
        this.items = 0;
        this.references = new HashMap(capacity);
    }

    public AStarHeap(Comparator comp, int capacity) {
        this.initHeap(capacity);
        this.cmp = comp;
    }

    public AStarHeap(Comparator comp) {
        this.initHeap(20);
        this.cmp = comp;
    }

    public Object getMin() {
        return this.nodes[1];
    }

    public boolean deleteMin() {
        if (this.items == 0) {
            return false;
        }
        return this.remove(this.nodes[1], 1);
    }

    public boolean decreaseKey(Object arg0) {
        Integer reference = (Integer)this.references.get(arg0);
        if (reference == null) {
            return this.add(arg0);
        }
        this.upNode(reference);
        return true;
    }

    public boolean add(Object arg0) {
        Integer reference = (Integer)this.references.get(arg0);
        if (reference == null) {
            this.getNode(this.items + 1);
            this.nodes[this.items + 1] = arg0;
            this.upNode(this.items + 1);
            ++this.items;
            return true;
        }
        int tempRef = this.upNode(reference);
        if (tempRef == reference) {
            this.downNode(reference);
        }
        return true;
    }

    public boolean addAll(Collection arg0) {
        Iterator iter = arg0.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return true;
    }

    public boolean addAll(Object[] arg0) {
        boolean ok = true;
        int i = 0;
        while (i < arg0.length) {
            ok = this.add(arg0[i]) && ok;
            ++i;
        }
        return ok;
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.count) {
            this.nodes[i] = null;
            this.references.clear();
            ++i;
        }
    }

    @Override
    public boolean contains(Object arg0) {
        return this.references.containsKey(arg0);
    }

    public boolean containsAll(Collection arg0) {
        return this.references.containsKey(arg0);
    }

    public boolean containsAll(Object[] arg0) {
        int i = 0;
        while (i < arg0.length) {
            if (!this.contains(arg0[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.references.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new AStarHeapIterator(this.nodes, this.items, this);
    }

    private boolean remove(Object arg0, int reference) {
        this.references.remove(arg0);
        if (this.items == 1) {
            this.nodes[1] = null;
            this.items = 0;
            return true;
        }
        this.nodes[reference] = this.nodes[this.items];
        this.nodes[this.items] = null;
        --this.items;
        this.downNode(reference);
        return true;
    }

    @Override
    public boolean remove(Object arg0) {
        Integer reference = (Integer)this.references.get(arg0);
        if (reference == null) {
            return false;
        }
        return this.remove((int)reference);
    }

    public boolean removeAll(Collection arg0) {
        Iterator iter = arg0.iterator();
        while (iter.hasNext()) {
            this.remove(iter.next());
        }
        return true;
    }

    public boolean retainAll(Collection arg0) {
        for (Object item : this.references.keySet()) {
            Integer reference = (Integer)this.references.get(item);
            if (arg0.contains(item)) continue;
            this.remove(item, reference);
        }
        return true;
    }

    @Override
    public int size() {
        return this.items;
    }

    public boolean empty() {
        return this.items == 0;
    }

    @Override
    public Object[] toArray() {
        return this.references.keySet().toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.references.keySet().toArray(arg0);
    }

    public Set toSet() {
        return this.references.keySet();
    }

    public static String mainToStr(Integer[] nums) {
        if (nums.length == 0) {
            return "";
        }
        String str = nums[0].toString();
        int i = 1;
        while (i < nums.length) {
            str = String.valueOf(str) + ", " + nums[i].toString();
            ++i;
        }
        return str;
    }

    public static boolean mainCheck(AStarHeap heap, Integer[] nums) {
        System.out.println("Removing and checking " + AStarHeap.mainToStr(nums));
        ArrayList<Object> heapInts = new ArrayList<Object>();
        ArrayList<Integer> desiredInts = new ArrayList<Integer>();
        int i = 0;
        while (i < nums.length) {
            desiredInts.add(nums[i]);
            heapInts.add(heap.getMin());
            heap.deleteMin();
            ++i;
        }
        if (heapInts.containsAll(desiredInts)) {
            System.out.println("OK");
            return true;
        }
        System.out.println("KO!");
        System.exit(1);
        return false;
    }

    public static void mainAdd(AStarHeap heap, Integer[] nums) {
        System.out.println("Adding: " + AStarHeap.mainToStr(nums));
        int i = 0;
        while (i < nums.length) {
            heap.add(nums[i]);
            ++i;
        }
    }

    public static void main(String[] args) {
    }
}

