/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class StraightStreamReader
extends Reader {
    private InputStream in;
    private byte[] buffer;

    public StraightStreamReader(InputStream in) {
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.in.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.buffer == null || this.buffer.length < len) {
            this.buffer = new byte[len];
        }
        int length = this.in.read(this.buffer, 0, len);
        int i = 0;
        while (i < length) {
            cbuf[off + i] = (char)(0xFF & this.buffer[i]);
            ++i;
        }
        return length;
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.available() > 0;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    private static void main(String[] args) {
        try {
            int read;
            File f = new File("test.txt");
            if (f.exists()) {
                throw new IOException(f + " already exists.  I don't want to overwrite it.");
            }
            char[] cbuf = new char[4096];
            FileOutputStream out = new FileOutputStream(f);
            int i = 0;
            while (i < 256) {
                out.write(i);
                ++i;
            }
            out.close();
            StraightStreamReader in = new StraightStreamReader(new FileInputStream(f));
            i = 0;
            while (i < 256) {
                read = in.read();
                if (read != i) {
                    System.err.println("Error: " + i + " read as " + read);
                }
                ++i;
            }
            in.close();
            in = new StraightStreamReader(new FileInputStream(f));
            int totRead = in.read(cbuf);
            if (totRead != 256) {
                System.err.println("Simple buffered read did not read the full amount: 0x" + Integer.toHexString(totRead));
            }
            i = 0;
            while (i < totRead) {
                if (cbuf[i] != i) {
                    System.err.println("Error: 0x" + i + " read as 0x" + cbuf[i]);
                }
                ++i;
            }
            in.close();
            in = new StraightStreamReader(new FileInputStream(f));
            totRead = 0;
            while (totRead <= 256 && (read = in.read(cbuf, totRead, 256 - totRead)) > 0) {
                totRead += read;
            }
            if (totRead != 256) {
                System.err.println("Not enough read. Bytes read: " + Integer.toHexString(totRead));
            }
            i = 0;
            while (i < totRead) {
                if (cbuf[i] != i) {
                    System.err.println("Error: 0x" + i + " read as 0x" + cbuf[i]);
                }
                ++i;
            }
            in.close();
            in = new StraightStreamReader(new FileInputStream(f));
            totRead = 0;
            while (totRead <= 256 && (read = in.read(cbuf, totRead + 291, 256 - totRead)) > 0) {
                totRead += read;
            }
            if (totRead != 256) {
                System.err.println("Not enough read. Bytes read: " + Integer.toHexString(totRead));
            }
            i = 0;
            while (i < totRead) {
                if (cbuf[i + 291] != i) {
                    System.err.println("Error: 0x" + i + " read as 0x" + cbuf[i + 291]);
                }
                ++i;
            }
            in.close();
            in = new StraightStreamReader(new FileInputStream(f));
            totRead = 0;
            while (totRead <= 256 && (read = in.read(cbuf, totRead + 291, 7)) > 0) {
                totRead += read;
            }
            if (totRead != 256) {
                System.err.println("Not enough read. Bytes read: " + Integer.toHexString(totRead));
            }
            i = 0;
            while (i < totRead) {
                if (cbuf[i + 291] != i) {
                    System.err.println("Error: 0x" + i + " read as 0x" + cbuf[i + 291]);
                }
                ++i;
            }
            in.close();
            f.delete();
        }
        catch (IOException x) {
            System.err.println(x.getMessage());
        }
    }
}

