/*
 * Decompiled with CFR 0.152.
 */
package JFlex.gui;

import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.Main;
import JFlex.Options;
import JFlex.Out;
import JFlex.gui.MainFrame;
import java.io.File;

public class GeneratorThread
extends Thread {
    private static volatile boolean running = false;
    String inputFile;
    String outputDir;
    MainFrame parent;

    public GeneratorThread(MainFrame parent, String inputFile, String outputDir) {
        this.parent = parent;
        this.inputFile = inputFile;
        this.outputDir = outputDir;
    }

    @Override
    public void run() {
        if (running) {
            Out.error(ErrorMessages.ALREADY_RUNNING);
            this.parent.generationFinished(false);
        } else {
            running = true;
            this.setPriority(1);
            try {
                try {
                    if (!this.outputDir.equals("")) {
                        Options.setDir(this.outputDir);
                    }
                    Main.generate(new File(this.inputFile));
                    Out.statistics();
                    this.parent.generationFinished(true);
                }
                catch (GeneratorException e) {
                    Out.statistics();
                    this.parent.generationFinished(false);
                    running = false;
                }
            }
            finally {
                running = false;
            }
        }
    }
}

