/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

public class Timer {
    private long startTime = System.currentTimeMillis();
    private long stopTime;
    private boolean running = true;

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.running = true;
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
        this.running = false;
    }

    public long diff() {
        if (this.running) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public String toString() {
        long diff = this.diff();
        long millis = diff % 1000L;
        long secs = diff / 1000L % 60L;
        long mins = diff / 60000L % 60L;
        long hs = diff / 3600000L % 24L;
        long days = diff / 86400000L;
        if (days > 0L) {
            return String.valueOf(days) + "d " + hs + "h " + mins + "m " + secs + "s " + millis + "ms";
        }
        if (hs > 0L) {
            return String.valueOf(hs) + "h " + mins + "m " + secs + "s " + millis + "ms";
        }
        if (mins > 0L) {
            return String.valueOf(mins) + "m " + secs + "s " + millis + "ms";
        }
        if (secs > 0L) {
            return String.valueOf(secs) + "s " + millis + "ms";
        }
        return String.valueOf(millis) + "ms";
    }
}

