/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.Macros;
import JFlex.Out;
import JFlex.RegExp;
import java.util.Enumeration;
import java.util.Vector;

public class RegExps {
    Vector lines;
    Vector states = new Vector();
    Vector regExps = new Vector();
    Vector actions = new Vector();
    Vector BOL = new Vector();
    Vector look = new Vector();

    public RegExps() {
        this.lines = new Vector();
    }

    public int insert(int line, Vector stateList, RegExp regExp, Action action, Boolean isBOL, RegExp lookAhead) {
        this.states.addElement(stateList);
        this.regExps.addElement(regExp);
        this.actions.addElement(action);
        this.BOL.addElement(isBOL);
        this.look.addElement(lookAhead);
        this.lines.addElement(new Integer(line));
        return this.states.size() - 1;
    }

    public int insert(Vector stateList, Action action) {
        this.states.addElement(stateList);
        this.regExps.addElement(null);
        this.actions.addElement(action);
        this.BOL.addElement(null);
        this.look.addElement(null);
        this.lines.addElement(null);
        return this.states.size() - 1;
    }

    public void addStates(int regNum, Vector newStates) {
        Enumeration s = newStates.elements();
        while (s.hasMoreElements()) {
            ((Vector)this.states.elementAt(regNum)).addElement(s.nextElement());
        }
    }

    public int getNum() {
        return this.states.size();
    }

    public boolean isBOL(int num) {
        return (Boolean)this.BOL.elementAt(num);
    }

    public RegExp getLookAhead(int num) {
        return (RegExp)this.look.elementAt(num);
    }

    public boolean isEOF(int num) {
        return this.BOL.elementAt(num) == null;
    }

    public Vector getStates(int num) {
        return (Vector)this.states.elementAt(num);
    }

    public RegExp getRegExp(int num) {
        return (RegExp)this.regExps.elementAt(num);
    }

    public int getLine(int num) {
        return (Integer)this.lines.elementAt(num);
    }

    public void checkActions() {
        if (this.actions.elementAt(this.actions.size() - 1) == null) {
            Out.error(ErrorMessages.NO_LAST_ACTION);
            throw new GeneratorException();
        }
    }

    public Action getAction(int num) {
        while (num < this.actions.size() && this.actions.elementAt(num) == null) {
            ++num;
        }
        return (Action)this.actions.elementAt(num);
    }

    public int NFASize(Macros macros) {
        RegExp r;
        int size = 0;
        Enumeration e = this.regExps.elements();
        while (e.hasMoreElements()) {
            r = (RegExp)e.nextElement();
            if (r == null) continue;
            size += r.size(macros);
        }
        e = this.look.elements();
        while (e.hasMoreElements()) {
            r = (RegExp)e.nextElement();
            if (r == null) continue;
            size += r.size(macros);
        }
        return size;
    }
}

