/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.CharClasses;
import JFlex.DFA;
import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.IntPair;
import JFlex.LexScan;
import JFlex.Macros;
import JFlex.Options;
import JFlex.Out;
import JFlex.RegExp;
import JFlex.RegExp1;
import JFlex.RegExp2;
import JFlex.RegExps;
import JFlex.StateSet;
import JFlex.StateSetEnumerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class NFA {
    StateSet[][] table;
    StateSet[] epsilon;
    boolean[] isFinal;
    boolean[] isPushback;
    Action[] action;
    int numStates;
    int numInput;
    int numLexStates;
    int estSize = 256;
    Macros macros;
    CharClasses classes;
    LexScan scanner;
    RegExps regExps;
    private static StateSetEnumerator states = new StateSetEnumerator();
    private static StateSet tempStateSet = new StateSet();
    private boolean[] live;
    private boolean[] visited;
    private int _end;
    private Vector _dfaStates;
    private int _dfaStart;

    public NFA(int numInput, int estSize) {
        this.numInput = numInput;
        this.estSize = estSize;
        this.numStates = 0;
        this.epsilon = new StateSet[estSize];
        this.action = new Action[estSize];
        this.isFinal = new boolean[estSize];
        this.isPushback = new boolean[estSize];
        this.table = new StateSet[estSize][numInput];
    }

    public NFA(int numInput, LexScan scanner, RegExps regExps, Macros macros, CharClasses classes) {
        this(numInput, regExps.NFASize(macros) + 2 * scanner.states.number());
        this.scanner = scanner;
        this.regExps = regExps;
        this.macros = macros;
        this.classes = classes;
        this.numLexStates = scanner.states.number();
        this.ensureCapacity(2 * this.numLexStates);
        this.numStates = 2 * this.numLexStates;
    }

    public void addStandaloneRule() {
        int start = this.numStates;
        int end = this.numStates + 1;
        int c = 0;
        while (c < this.classes.getNumClasses()) {
            this.addTransition(start, c, end);
            ++c;
        }
        int i = 0;
        while (i < this.numLexStates * 2) {
            this.addEpsilonTransition(i, start);
            ++i;
        }
        this.action[end] = new Action("System.out.print(yytext());", Integer.MAX_VALUE);
        this.isFinal[end] = true;
    }

    public void addRegExp(int regExpNum) {
        IntPair nfa = this.insertNFA(this.regExps.getRegExp(regExpNum));
        Enumeration lexStates = this.regExps.getStates(regExpNum).elements();
        if (!lexStates.hasMoreElements()) {
            lexStates = this.scanner.states.getInclusiveStates();
        }
        while (lexStates.hasMoreElements()) {
            int stateNum = (Integer)lexStates.nextElement();
            if (!this.regExps.isBOL(regExpNum)) {
                this.addEpsilonTransition(2 * stateNum, nfa.start);
            }
            this.addEpsilonTransition(2 * stateNum + 1, nfa.start);
        }
        if (this.regExps.getLookAhead(regExpNum) != null) {
            IntPair look = this.insertNFA(this.regExps.getLookAhead(regExpNum));
            this.addEpsilonTransition(nfa.end, look.start);
            Action a = this.regExps.getAction(regExpNum);
            a.setLookAction(true);
            this.isPushback[nfa.end] = true;
            this.action[look.end] = a;
            this.isFinal[look.end] = true;
        } else {
            this.action[nfa.end] = this.regExps.getAction(regExpNum);
            this.isFinal[nfa.end] = true;
        }
    }

    private void ensureCapacity(int newNumStates) {
        int oldLength = this.epsilon.length;
        if (newNumStates < oldLength) {
            return;
        }
        int newStatesLength = Math.max(oldLength * 2, newNumStates);
        boolean[] newFinal = new boolean[newStatesLength];
        boolean[] newIsPush = new boolean[newStatesLength];
        Action[] newAction = new Action[newStatesLength];
        StateSet[][] newTable = new StateSet[newStatesLength][this.numInput];
        StateSet[] newEpsilon = new StateSet[newStatesLength];
        System.arraycopy(this.isFinal, 0, newFinal, 0, this.numStates);
        System.arraycopy(this.isPushback, 0, newIsPush, 0, this.numStates);
        System.arraycopy(this.action, 0, newAction, 0, this.numStates);
        System.arraycopy(this.epsilon, 0, newEpsilon, 0, this.numStates);
        System.arraycopy(this.table, 0, newTable, 0, this.numStates);
        this.isFinal = newFinal;
        this.isPushback = newIsPush;
        this.action = newAction;
        this.epsilon = newEpsilon;
        this.table = newTable;
    }

    public void addTransition(int start, int input, int dest) {
        Out.debug("Adding transition (" + start + ", " + input + ", " + dest + ")");
        int maxS = Math.max(start, dest) + 1;
        this.ensureCapacity(maxS);
        if (maxS > this.numStates) {
            this.numStates = maxS;
        }
        if (this.table[start][input] != null) {
            this.table[start][input].addState(dest);
        } else {
            this.table[start][input] = new StateSet(this.estSize, dest);
        }
    }

    public void addEpsilonTransition(int start, int dest) {
        int max = Math.max(start, dest) + 1;
        this.ensureCapacity(max);
        if (max > this.numStates) {
            this.numStates = max;
        }
        if (this.epsilon[start] != null) {
            this.epsilon[start].addState(dest);
        } else {
            this.epsilon[start] = new StateSet(this.estSize, dest);
        }
    }

    private boolean containsFinal(StateSet set) {
        states.reset(set);
        while (states.hasMoreElements()) {
            if (!this.isFinal[states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    private boolean containsPushback(StateSet set) {
        states.reset(set);
        while (states.hasMoreElements()) {
            if (!this.isPushback[states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    private Action getAction(StateSet set) {
        states.reset(set);
        Action maxAction = null;
        Out.debug("Determining action of : " + set);
        while (states.hasMoreElements()) {
            Action currentAction = this.action[states.nextElement()];
            if (currentAction == null) continue;
            maxAction = maxAction == null ? currentAction : maxAction.getHigherPriority(currentAction);
        }
        return maxAction;
    }

    private StateSet closure(int startState) {
        StateSet notvisited = tempStateSet;
        StateSet closure = new StateSet(this.numStates, startState);
        notvisited.clear();
        notvisited.addState(startState);
        while (notvisited.containsElements()) {
            int state = notvisited.getAndRemoveElement();
            notvisited.add(closure.complement(this.epsilon[state]));
            closure.add(this.epsilon[state]);
        }
        return closure;
    }

    private StateSet closure(StateSet startStates) {
        StateSet result = new StateSet(this.numStates);
        if (startStates != null) {
            states.reset(startStates);
            while (states.hasMoreElements()) {
                result.add(this.closure(states.nextElement()));
            }
        }
        return result;
    }

    private void epsilonFill() {
        int i = 0;
        while (i < this.numStates) {
            this.epsilon[i] = this.closure(i);
            ++i;
        }
    }

    private StateSet DFAEdge(StateSet start, char input) {
        tempStateSet.clear();
        states.reset(start);
        while (states.hasMoreElements()) {
            tempStateSet.add(this.table[states.nextElement()][input]);
        }
        StateSet result = new StateSet(tempStateSet);
        states.reset(tempStateSet);
        while (states.hasMoreElements()) {
            result.add(this.epsilon[states.nextElement()]);
        }
        return result;
    }

    public DFA getDFA() {
        StateSet newState;
        Hashtable<StateSet, Integer> dfaStates = new Hashtable<StateSet, Integer>(this.numStates);
        Vector<StateSet> dfaVector = new Vector<StateSet>(this.numStates);
        DFA dfa = new DFA(2 * this.numLexStates, this.numInput);
        int numDFAStates = 0;
        int currentDFAState = 0;
        Out.println("Converting NFA to DFA : ");
        this.epsilonFill();
        int i = 0;
        while (i < 2 * this.numLexStates) {
            newState = this.epsilon[i];
            dfaStates.put(newState, new Integer(numDFAStates));
            dfaVector.addElement(newState);
            dfa.setLexState(i, numDFAStates);
            dfa.setFinal(numDFAStates, this.containsFinal(newState));
            dfa.setPushback(numDFAStates, this.containsPushback(newState));
            dfa.setAction(numDFAStates, this.getAction(newState));
            ++numDFAStates;
            ++i;
        }
        --numDFAStates;
        currentDFAState = 0;
        StateSet tempStateSet = NFA.tempStateSet;
        StateSetEnumerator states = NFA.states;
        newState = new StateSet(this.numStates);
        while (currentDFAState <= numDFAStates) {
            StateSet currentState = (StateSet)dfaVector.elementAt(currentDFAState);
            char input = '\u0000';
            while (input < this.numInput) {
                tempStateSet.clear();
                states.reset(currentState);
                while (states.hasMoreElements()) {
                    tempStateSet.add(this.table[states.nextElement()][input]);
                }
                newState.copy(tempStateSet);
                states.reset(tempStateSet);
                while (states.hasMoreElements()) {
                    newState.add(this.epsilon[states.nextElement()]);
                }
                if (newState.containsElements()) {
                    Integer nextDFAState = (Integer)dfaStates.get(newState);
                    if (nextDFAState != null) {
                        dfa.addTransition(currentDFAState, input, nextDFAState);
                    } else {
                        if (Options.progress) {
                            Out.print(".");
                        }
                        StateSet storeState = new StateSet(newState);
                        dfaStates.put(storeState, new Integer(++numDFAStates));
                        dfaVector.addElement(storeState);
                        dfa.addTransition(currentDFAState, input, numDFAStates);
                        dfa.setFinal(numDFAStates, this.containsFinal(storeState));
                        dfa.setPushback(numDFAStates, this.containsPushback(storeState));
                        dfa.setAction(numDFAStates, this.getAction(storeState));
                    }
                }
                input = (char)(input + 1);
            }
            ++currentDFAState;
        }
        if (Options.verbose) {
            Out.println("");
        }
        return dfa;
    }

    public void dumpTable() {
        Out.dump(this.toString());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.numStates) {
            result.append("State");
            if (this.isFinal[i]) {
                result.append("[FINAL]");
            }
            if (this.isPushback[i]) {
                result.append(" [PUSHBACK]");
            }
            result.append(" " + i + Out.NL);
            int input = 0;
            while (input < this.numInput) {
                if (this.table[i][input] != null && this.table[i][input].containsElements()) {
                    result.append("  with " + input + " in " + this.table[i][input] + Out.NL);
                }
                input = (char)(input + 1);
            }
            if (this.epsilon[i] != null && this.epsilon[i].containsElements()) {
                result.append("  with epsilon in " + this.epsilon[i] + Out.NL);
            }
            ++i;
        }
        return result.toString();
    }

    public void writeDot(File file) {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            writer.println(this.dotFormat());
            writer.close();
        }
        catch (IOException e) {
            Out.error(ErrorMessages.FILE_WRITE, file);
            throw new GeneratorException();
        }
    }

    public String dotFormat() {
        StringBuffer result = new StringBuffer();
        result.append("digraph NFA {" + Out.NL);
        result.append("rankdir = LR" + Out.NL);
        int i = 0;
        while (i < this.numStates) {
            if (this.isFinal[i] || this.isPushback[i]) {
                result.append(i);
            }
            if (this.isFinal[i]) {
                result.append(" [shape = doublecircle]");
            }
            if (this.isPushback[i]) {
                result.append(" [shape = box]");
            }
            if (this.isFinal[i] || this.isPushback[i]) {
                result.append(Out.NL);
            }
            ++i;
        }
        i = 0;
        while (i < this.numStates) {
            int input = 0;
            while (input < this.numInput) {
                if (this.table[i][input] != null) {
                    StateSetEnumerator states = this.table[i][input].states();
                    while (states.hasMoreElements()) {
                        int s = states.nextElement();
                        result.append(String.valueOf(i) + " -> " + s);
                        result.append(" [label=\"" + this.classes.toString(input) + "\"]" + Out.NL);
                    }
                }
                ++input;
            }
            if (this.epsilon[i] != null) {
                StateSetEnumerator states = this.epsilon[i].states();
                while (states.hasMoreElements()) {
                    int s = states.nextElement();
                    result.append(String.valueOf(i) + " -> " + s + " [style=dotted]" + Out.NL);
                }
            }
            ++i;
        }
        result.append("}" + Out.NL);
        return result.toString();
    }

    private void insertLetterNFA(boolean caseless, char letter, int start, int end) {
        if (caseless) {
            int lower = this.classes.getClassCode(Character.toLowerCase(letter));
            int upper = this.classes.getClassCode(Character.toUpperCase(letter));
            this.addTransition(start, lower, end);
            if (upper != lower) {
                this.addTransition(start, upper, end);
            }
        } else {
            this.addTransition(start, this.classes.getClassCode(letter), end);
        }
    }

    private IntPair insertStringNFA(boolean caseless, String letters) {
        int start = this.numStates;
        int i = 0;
        while (i < letters.length()) {
            if (caseless) {
                char c = letters.charAt(i);
                int lower = this.classes.getClassCode(Character.toLowerCase(c));
                int upper = this.classes.getClassCode(Character.toUpperCase(c));
                this.addTransition(i + start, lower, i + start + 1);
                if (upper != lower) {
                    this.addTransition(i + start, upper, i + start + 1);
                }
            } else {
                this.addTransition(i + start, this.classes.getClassCode(letters.charAt(i)), i + start + 1);
            }
            ++i;
        }
        return new IntPair(start, i + start);
    }

    private void insertClassNFA(Vector intervalls, int start, int end) {
        if (intervalls == null) {
            return;
        }
        int[] cl = this.classes.getClassCodes(intervalls);
        int i = 0;
        while (i < cl.length) {
            this.addTransition(start, cl[i], end);
            ++i;
        }
    }

    private void insertNotClassNFA(Vector intervalls, int start, int end) {
        int[] cl = this.classes.getNotClassCodes(intervalls);
        int i = 0;
        while (i < cl.length) {
            this.addTransition(start, cl[i], end);
            ++i;
        }
    }

    private IntPair complement(IntPair nfa) {
        StateSet currentState;
        int dfaStart = nfa.end + 1;
        this.epsilonFill();
        Hashtable<StateSet, Integer> dfaStates = new Hashtable<StateSet, Integer>(this.numStates);
        Vector<StateSet> dfaVector = new Vector<StateSet>(this.numStates);
        int numDFAStates = 0;
        int currentDFAState = 0;
        StateSet newState = this.epsilon[nfa.start];
        dfaStates.put(newState, new Integer(numDFAStates));
        dfaVector.addElement(newState);
        currentDFAState = 0;
        while (currentDFAState <= numDFAStates) {
            currentState = (StateSet)dfaVector.elementAt(currentDFAState);
            char input = '\u0000';
            while (input < this.numInput) {
                newState = this.DFAEdge(currentState, input);
                if (newState.containsElements()) {
                    Integer nextDFAState = (Integer)dfaStates.get(newState);
                    if (nextDFAState != null) {
                        this.addTransition(dfaStart + currentDFAState, input, dfaStart + nextDFAState);
                    } else {
                        if (Options.dump) {
                            Out.print("+");
                        }
                        dfaStates.put(newState, new Integer(++numDFAStates));
                        dfaVector.addElement(newState);
                        this.addTransition(dfaStart + currentDFAState, input, dfaStart + numDFAStates);
                    }
                }
                input = (char)(input + '\u0001');
            }
            ++currentDFAState;
        }
        int start = dfaStart + numDFAStates + 1;
        int error = dfaStart + numDFAStates + 2;
        int end = dfaStart + numDFAStates + 3;
        this.addEpsilonTransition(start, dfaStart);
        int i = 0;
        while (i < this.numInput) {
            this.addTransition(error, i, error);
            ++i;
        }
        this.addEpsilonTransition(error, end);
        int s = 0;
        while (s <= numDFAStates) {
            currentState = (StateSet)dfaVector.elementAt(s);
            currentDFAState = dfaStart + s;
            if (!currentState.isElement(nfa.end)) {
                this.addEpsilonTransition(currentDFAState, end);
            }
            int i2 = 0;
            while (i2 < this.numInput) {
                if (this.table[currentDFAState][i2] == null) {
                    this.addTransition(currentDFAState, i2, error);
                }
                ++i2;
            }
            ++s;
        }
        if (this.live == null || this.live.length < this.numStates) {
            this.live = new boolean[2 * this.numStates];
            this.visited = new boolean[2 * this.numStates];
        }
        this._end = end;
        this._dfaStates = dfaVector;
        this._dfaStart = dfaStart;
        this.removeDead(dfaStart);
        return new IntPair(start, end);
    }

    private void removeDead(int start) {
        if (this.visited[start] || this.live[start]) {
            return;
        }
        this.visited[start] = true;
        if (this.closure(start).isElement(this._end)) {
            this.live[start] = true;
        }
        int i = 0;
        while (i < this.numInput) {
            StateSet nextState = this.closure(this.table[start][i]);
            StateSetEnumerator states = nextState.states();
            while (states.hasMoreElements()) {
                int next = states.nextElement();
                if (next == start) continue;
                this.removeDead(next);
                if (this.live[next]) {
                    this.live[start] = true;
                    continue;
                }
                this.table[start][i] = null;
            }
            ++i;
        }
        StateSet nextState = this.closure(this.epsilon[start]);
        StateSetEnumerator states = nextState.states();
        while (states.hasMoreElements()) {
            int next = states.nextElement();
            if (next == start) continue;
            this.removeDead(next);
            if (!this.live[next]) continue;
            this.live[start] = true;
        }
    }

    private void insertNFA(RegExp regExp, int start, int end) {
        switch (regExp.type) {
            case 34: {
                RegExp2 r = (RegExp2)regExp;
                this.insertNFA(r.r1, start, end);
                this.insertNFA(r.r2, start, end);
                return;
            }
            case 42: {
                this.insertClassNFA((Vector)((RegExp1)regExp).content, start, end);
                return;
            }
            case 43: {
                this.insertNotClassNFA((Vector)((RegExp1)regExp).content, start, end);
                return;
            }
            case 39: {
                this.insertLetterNFA(false, ((Character)((RegExp1)regExp).content).charValue(), start, end);
                return;
            }
            case 46: {
                this.insertLetterNFA(true, ((Character)((RegExp1)regExp).content).charValue(), start, end);
                return;
            }
            case 41: {
                this.insertNFA(this.macros.getDefinition((String)((RegExp1)regExp).content), start, end);
                return;
            }
        }
        throw new Error("Unknown expression type " + regExp.type + " in NFA construction");
    }

    public IntPair insertNFA(RegExp regExp) {
        if (regExp.isCharClass(this.macros)) {
            int start = this.numStates;
            int end = this.numStates + 1;
            this.ensureCapacity(end + 1);
            if (end + 1 > this.numStates) {
                this.numStates = end + 1;
            }
            this.insertNFA(regExp, start, end);
            return new IntPair(start, end);
        }
        switch (regExp.type) {
            case 34: {
                RegExp2 r = (RegExp2)regExp;
                IntPair nfa1 = this.insertNFA(r.r1);
                IntPair nfa2 = this.insertNFA(r.r2);
                int start = nfa2.end + 1;
                int end = nfa2.end + 2;
                this.addEpsilonTransition(start, nfa1.start);
                this.addEpsilonTransition(start, nfa2.start);
                this.addEpsilonTransition(nfa1.end, end);
                this.addEpsilonTransition(nfa2.end, end);
                return new IntPair(start, end);
            }
            case 44: {
                RegExp2 r = (RegExp2)regExp;
                IntPair nfa1 = this.insertNFA(r.r1);
                IntPair nfa2 = this.insertNFA(r.r2);
                this.addEpsilonTransition(nfa1.end, nfa2.start);
                return new IntPair(nfa1.start, nfa2.end);
            }
            case 32: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int start = nfa1.end + 1;
                int end = nfa1.end + 2;
                this.addEpsilonTransition(nfa1.end, end);
                this.addEpsilonTransition(start, nfa1.start);
                this.addEpsilonTransition(start, end);
                this.addEpsilonTransition(nfa1.end, nfa1.start);
                return new IntPair(start, end);
            }
            case 33: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int start = nfa1.end + 1;
                int end = nfa1.end + 2;
                this.addEpsilonTransition(nfa1.end, end);
                this.addEpsilonTransition(start, nfa1.start);
                this.addEpsilonTransition(nfa1.end, nfa1.start);
                return new IntPair(start, end);
            }
            case 35: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                this.addEpsilonTransition(nfa1.start, nfa1.end);
                return new IntPair(nfa1.start, nfa1.end);
            }
            case 37: {
                return this.complement(this.insertNFA((RegExp)((RegExp1)regExp).content));
            }
            case 38: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int start = nfa1.end + 1;
                int s1 = start + 1;
                int s2 = s1 + 1;
                int end = s2 + 1;
                int i = 0;
                while (i < this.numInput) {
                    this.addTransition(s1, i, s1);
                    this.addTransition(s2, i, s2);
                    ++i;
                }
                this.addEpsilonTransition(start, s1);
                this.addEpsilonTransition(s1, nfa1.start);
                this.addEpsilonTransition(nfa1.end, s2);
                this.addEpsilonTransition(s2, end);
                nfa1 = this.complement(new IntPair(start, end));
                IntPair nfa2 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                this.addEpsilonTransition(nfa1.end, nfa2.start);
                return new IntPair(nfa1.start, nfa2.end);
            }
            case 40: {
                return this.insertStringNFA(false, (String)((RegExp1)regExp).content);
            }
            case 45: {
                return this.insertStringNFA(true, (String)((RegExp1)regExp).content);
            }
            case 41: {
                return this.insertNFA(this.macros.getDefinition((String)((RegExp1)regExp).content));
            }
        }
        throw new Error("Unknown expression type " + regExp.type + " in NFA construction");
    }
}

