/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.CharClassInterval;
import JFlex.IntCharSet;
import JFlex.Interval;
import JFlex.Out;
import java.util.Vector;

public class CharClasses {
    private static final boolean DEBUG = false;
    public static final char maxChar = '\uffff';
    private Vector classes;
    private char maxCharUsed;

    public CharClasses(int maxCharCode) {
        if (maxCharCode < 0 || maxCharCode > 65535) {
            throw new IllegalArgumentException();
        }
        this.maxCharUsed = (char)maxCharCode;
        this.classes = new Vector();
        this.classes.addElement(new IntCharSet(new Interval('\u0000', '\uffff')));
    }

    public char getMaxCharCode() {
        return this.maxCharUsed;
    }

    public void setMaxCharCode(int charCode) {
        if (charCode < 0 || charCode > 65535) {
            throw new IllegalArgumentException();
        }
        this.maxCharUsed = (char)charCode;
    }

    public int getNumClasses() {
        return this.classes.size();
    }

    public void makeClass(IntCharSet set, boolean caseless) {
        if (caseless) {
            set = set.getCaseless();
        }
        int oldSize = this.classes.size();
        int i = 0;
        while (i < oldSize) {
            IntCharSet x = (IntCharSet)this.classes.elementAt(i);
            if (x.equals(set)) {
                return;
            }
            IntCharSet and = x.and(set);
            if (and.containsElements()) {
                if (x.equals(and)) {
                    set.sub(and);
                } else {
                    if (set.equals(and)) {
                        x.sub(and);
                        this.classes.addElement(and);
                        return;
                    }
                    set.sub(and);
                    x.sub(and);
                    this.classes.addElement(and);
                }
            }
            ++i;
        }
    }

    public int getClassCode(char letter) {
        IntCharSet x;
        int i = -1;
        while (!(x = (IntCharSet)this.classes.elementAt(++i)).contains(letter)) {
        }
        return i;
    }

    public void dump() {
        Out.dump(this.toString());
    }

    public String toString(int theClass) {
        return this.classes.elementAt(theClass).toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("CharClasses:");
        result.append(Out.NL);
        int i = 0;
        while (i < this.classes.size()) {
            result.append("class " + i + ":" + Out.NL + this.classes.elementAt(i) + Out.NL);
            ++i;
        }
        return result.toString();
    }

    public void makeClass(char singleChar, boolean caseless) {
        this.makeClass(new IntCharSet(singleChar), caseless);
    }

    public void makeClass(String str, boolean caseless) {
        int i = 0;
        while (i < str.length()) {
            this.makeClass(str.charAt(i), caseless);
            ++i;
        }
    }

    public void makeClass(Vector v, boolean caseless) {
        this.makeClass(new IntCharSet(v), caseless);
    }

    public void makeClassNot(Vector v, boolean caseless) {
        this.makeClass(new IntCharSet(v), caseless);
    }

    private int[] getClassCodes(IntCharSet set, boolean negate) {
        int size = this.classes.size();
        int[] temp = new int[size];
        int length = 0;
        int i = 0;
        while (i < size) {
            IntCharSet x = (IntCharSet)this.classes.elementAt(i);
            if (negate) {
                if (!set.and(x).containsElements()) {
                    temp[length++] = i;
                }
            } else if (set.and(x).containsElements()) {
                temp[length++] = i;
            }
            ++i;
        }
        int[] result = new int[length];
        System.arraycopy(temp, 0, result, 0, length);
        return result;
    }

    public int[] getClassCodes(Vector intervallVec) {
        return this.getClassCodes(new IntCharSet(intervallVec), false);
    }

    public int[] getNotClassCodes(Vector intervallVec) {
        return this.getClassCodes(new IntCharSet(intervallVec), true);
    }

    public void check() {
        int i = 0;
        while (i < this.classes.size()) {
            int j = i + 1;
            while (j < this.classes.size()) {
                IntCharSet y;
                IntCharSet x = (IntCharSet)this.classes.elementAt(i);
                if (x.and(y = (IntCharSet)this.classes.elementAt(j)).containsElements()) {
                    System.out.println("Error: non disjoint char classes " + i + " and " + j);
                    System.out.println("class " + i + ": " + x);
                    System.out.println("class " + j + ": " + y);
                }
                ++j;
            }
            ++i;
        }
        char c = '\u0000';
        while (c < '\uffff') {
            this.getClassCode(c);
            if (c % 100 == 0) {
                System.out.print(".");
            }
            c = (char)(c + '\u0001');
        }
        this.getClassCode('\uffff');
    }

    public CharClassInterval[] getIntervalls() {
        int size = this.classes.size();
        int numIntervalls = 0;
        int i = 0;
        while (i < size) {
            numIntervalls += ((IntCharSet)this.classes.elementAt(i)).numIntervalls();
            ++i;
        }
        CharClassInterval[] result = new CharClassInterval[numIntervalls];
        i = 0;
        int c = 0;
        while (i < numIntervalls) {
            int code = this.getClassCode((char)c);
            IntCharSet set = (IntCharSet)this.classes.elementAt(code);
            Interval iv = set.getNext();
            result[i++] = new CharClassInterval(iv.start, iv.end, code);
            c = iv.end + '\u0001';
        }
        return result;
    }
}

