// Here we create new GB HUD, which can show names of NavPoints and draw
// player location on the screen - controlled by keys:
//	- HOME (enables/disables NavPoints names)
//	- PageUp/PageDown (increase/decrease radius of drawing NavPoint names)
// Also in this class we draw NavPoints reachability grid in the map
//  - Insert key enables/disables NavPoints reachability grid
class GBHUDInteraction extends Interaction;

var HUD ThisHudOfMine;
var TraceLine Line1;
var config bool bDrawNavPointsGrid;
var bool bNavPointsGridDrawn;

event Initialized()
{
	bNavPointsGridDrawn = false;
	InitHud();
	if (bDrawNavPointsGrid)
	{
		DrawNavPointsGrid();
	}
}


event NotifyLevelChange()
{
	ViewportOwner.Actor.ClearStayingDebugLines();
	bNavPointsGridDrawn = false;

	ThisHudOfMine.Destroy();
    if (ViewportOwner.Actor.isA('GBxPlayer'))
    {
		GBxPlayer(ViewportOwner.Actor).GBHUD = None;
	}
    ViewportOwner.InteractionMaster.RemoveInteraction(self);
	/*
	InitHud();
	if (bDrawNavPointsGrid)
	{
		DrawNavPointsGrid();
	}
	*/
}

function InitHud()
{
    ThisHudOfMine = ViewportOwner.Actor.spawn(class'BotAPI.GBHud', ViewportOwner.Actor);

    if (ViewportOwner.Actor.isA('GBxPlayer'))
    {
		GBxPlayer(ViewportOwner.Actor).GBHUD = GBHud(ThisHudOfMine);
		//GBxPlayer(ViewportOwner.Actor).GBHUDInter = self;
	}
}

function DrawNavPointsGrid()
{
	local NavigationPoint N;
	local int i, PathListLength;

	for ( N=ViewportOwner.Actor.Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		i = 0;
		PathListLength = N.PathList.Length;
		for (i=0; i < PathListLength; i++)
		{
			ViewportOwner.Actor.DrawStayingDebugLine(N.Location,N.PathList[i].End.Location,255,30,30);
		}
	}
	bNavPointsGridDrawn = true;

}

function bool KeyEvent(EInputKey Key, EInputAction Action, FLOAT Delta )
{
    if ((Action == IST_Press) && (Key == IK_PageUp))
    {
		if (GBHUD(ThisHudOfMine).NavPointBeaconDrawDistance < 4000)
			GBHUD(ThisHudOfMine).NavPointBeaconDrawDistance += 100;
	}

    if ((Action == IST_Press) && (Key == IK_PageDown))
    {
		if (GBHUD(ThisHudOfMine).NavPointBeaconDrawDistance > 100)
			GBHUD(ThisHudOfMine).NavPointBeaconDrawDistance -= 100;
	}

    if ((Action == IST_Press) && (Key == IK_Home))
    {
		GBHUD(ThisHudOfMine).DrawNavPointBeacons = !GBHUD(ThisHudOfMine).DrawNavPointBeacons;

		//ViewportOwner.Actor.DrawDebugLine(ViewportOwner.Actor.Pawn.Location,ViewportOwner.Actor.Pawn.Location + 500 * vector(ViewportOwner.Actor.Pawn.Rotation),255,0,0);
		/*
		Line1 = ViewportOwner.Actor.spawn(class'BotAPI.TraceLine',ViewportOwner.Actor,,ViewportOwner.Actor.Pawn.Location);
		Line1.StartEffect = ViewportOwner.Actor.Pawn.Location;
		Line1.EndEffect = ViewportOwner.Actor.Pawn.Location + 1000 * vector(ViewportOwner.Actor.Pawn.Rotation);
		Line1.SetBeamLocation();
		Line1.SetBeamRotation();
		  */
		//BotHUD(ThisHudOfMine).DrawNavPointBeacons = !BotHUD(ThisHudOfMine).DrawNavPointBeacons;
	}
	if ((Action == IST_Press) && (Key == IK_Insert))
    {
		if( bNavPointsGridDrawn )
		{
			ViewportOwner.Actor.ClearStayingDebugLines();
			bNavPointsGridDrawn = false;
		}
		else
			DrawNavPointsGrid();
    	//log("DOING IT");
    	//DrawTraceLine(ViewportOwner.Actor.Pawn.Location,ViewportOwner.Actor.Pawn.Location + 1000 * vector(ViewportOwner.Actor.Pawn.Rotation),true);
		//ViewportOwner.Actor.DrawStayingDebugLine(ViewportOwner.Actor.Pawn.Location,ViewportOwner.Actor.Pawn.Location + 1000 * vector(ViewportOwner.Actor.Pawn.Rotation),255,0,0);
	}

    return false;
}

function DrawTraceLine(vector LineStart,vector LineEnd,bool LineHit)
{
	if (LineHit)
	{
		ViewportOwner.Actor.DrawDebugLine(LineStart,LineEnd,255,0,0);
		log("Draw Line hit");
	}
	else
	{
		ViewportOwner.Actor.DrawDebugLine(LineStart,LineEnd,0,255,0);
		log("Draw Line miss");
	}
//	if (GBHUD != none)
//		GBHUD(GBHUD).DrawTraceLine(LineStart,LineEnd,LineHit);
}

function PostRender( canvas Canvas )
{
	if (ThisHudOfMine != none)
    	ThisHudOfMine.PostRender(Canvas);
}

defaultproperties
{
	bDrawNavPointsGrid=false
    bVisible=true
    bActive=true
}
