//This class spawns GBHudInteraction class for every player in the game
class GBHUDMutator extends Mutator;

var bool bAffectSpectators; // If this is set to true, an interaction will be created for spectators
var bool bAffectPlayers; // If this is set to true, an interaction will be created for players
var bool bHasInteraction;

function PreBeginPlay()
{
    //Log("ICU Mutator Started"); // Always comment out your logs unless they're errors
}

simulated function Tick(float DeltaTime)
{
    local PlayerController PC;

    // If the player has an interaction already, exit function.
    if (bHasInteraction)
        Return;
    PC = Level.GetLocalPlayerController();

    // Run a check to see whether this mutator should create an interaction for the player
    if ( PC != None && ((PC.PlayerReplicationInfo.bIsSpectator && bAffectSpectators) || (bAffectPlayers && !PC.PlayerReplicationInfo.bIsSpectator)) )
    {
        PC.Player.InteractionMaster.AddInteraction("BotAPI.GBHUDInteraction", PC.Player); // Create the interaction
        bHasInteraction = True; // Set the variable so this lot isn't called again
    }
	Disable('Tick');
}

function ServerTraveling(string URL, bool bItems)
{
	bHasInteraction = false;
    Enable('Tick');
	super.ServerTraveling(URL,bItems);
}

DefaultProperties
{
     bAffectSpectators=true
     bAffectPlayers=true
     RemoteRole=ROLE_SimulatedProxy
     bAlwaysRelevant=true
}
