// This is the class, where we add additional functionality to Player HUD.
// Currently we draw NavPoints names above them nad player location
class GBHud extends HudBase
	config(BotAPI);

var float NavPointBeaconDrawDistance;
var bool DrawNavPointBeacons;

//var Controller RemoteBots[20];
/*
struct RemBotInfo{
	var() config string Id;
	var() config string BotName;
	var() config vector Location;
};*/
var config string RemBotId[20];
//var vector RemBotLoc[20];
//var array<RemBotInfo> RemBotInfoList;


simulated function PostRender(Canvas C)
{
	if (DrawNavPointBeacons)
		DrawNavPoints(C);
	//DrawRemoteBots(C); //Test
	DrawPlayerLocation(C);

}
/*
function PostBeginPlay()
{
	super.PostBeginPlay();
	PlayerOwner.myHUD = self; //why is this necesssary?
}
*/

/*
function UpdateHUDBotPos()
{
	local Controller C;
	local int i;
	i = 0;
	for (C = Level.ControllerList; C != none; C = C.NextController)
	{

			RemBotId[i] = string(C);
			i++;

	}

}   */



function SetFont(Canvas C)
{
	C.DrawColor = class'Canvas'.Static.MakeColor(0,155,55);

	if (C.SizeX <= 800)
	{
		C.Font = C.SmallFont;
		C.FontScaleX=1;
		C.FontScaleY=1;
	}
	else
	{
		if (C.SizeX <= 1280 )
		{
			C.Font = C.MedFont;
			C.FontScaleX=1;
			C.FontScaleY=1;
		}
		else //TODO: Set some large font for 1280 and <, problem with FontScale here - wtf?
		{
			C.Font = C.MedFont;
			C.FontScaleX=1;
			C.FontScaleY=1;
		}
	}

}

function DrawNavPointBeacon(Canvas C, NavigationPoint N, vector ObserverPosition, float ScreenLocX, float ScreenLocY)
{

	local float XL,YL,floatDist;
	local vector distance;


	distance = N.Location - ObserverPosition;
	floatDist = sqrt(square(N.Location.x - ObserverPosition.x) + square(N.Location.y - ObserverPosition.y) + square(N.Location.z - ObserverPosition.z));

	if (floatDist > NavPointBeaconDrawDistance)
		return;

	SetFont(C);
	//C.FontScaleX=1 - floatDist/5000;
    //C.FontScaleY=1 - floatDist/5000;

	//if (C.FontScaleX < 0.2)
	//	C.FontScaleX = 0.2;
	//if (C.FontScaleY < 0.2)
	//	C.FontScaleY = 0.2;

	C.StrLen(string(N), XL, YL);
	C.SetPos(ScreenLocX - 0.5*XL , ScreenLocY - YL);
	C.DrawText(string(N),true);
	log("Drawing: "$string(N));
	//C.SetPos(ScreenLocX - 0.125 * BeaconTex.USize, ScreenLocY - 0.125 * BeaconTex.VSize);
	/*C.DrawTile(BeaconTex,
		0.25 * BeaconTex.USize,
		0.25 * BeaconTex.VSize,
		0.0,
		0.0,
		BeaconTex.USize,
		BeaconTex.VSize);
	*/
}

function DrawPlayerLocation(canvas C)
{
	local vector PlayerLocation;

	if (PlayerOwner.Pawn != none)
	{
		PlayerLocation = PlayerOwner.Pawn.Location;
	}
	else if (PlayerOwner.ViewTarget != none)
	{
		PLayerLocation = PlayerOwner.ViewTarget.Location;
	}
	else
	{
		PlayerLocation = PlayerOwner.Location;
	}
	SetFont(C);
	C.SetPos(250 , 40);
	C.DrawText("My Location: "$PlayerLocation,true);


}

function DrawRemoteBots(canvas C)
{
	local float ScreenLocX, ScreenLocY, shift;
//	local string temp;
	local int i;

	shift = 15;
	ScreenLocX = 25;
	ScreenLocY = 40;
    SetFont(C);
    C.SetPos(ScreenLocX, ScreenLocY);
	C.DrawText("RemoteBot List: ",true);
	//UpdateHUDBotPos();

	for (i = 0; i < 20; i++)
	{

		//L = RemoteBots[i];
    	//if (L != none)
    	//{
		ScreenLocY += shift;
		C.SetPos(ScreenLocX, ScreenLocY);
		//temp = L $ L.PlayerReplicationInfo.PlayerId;
		//if (L.Pawn != none)
			//temp = temp $ " Location " $ L.Pawn.Location;
		C.DrawText("Bot: "$RemBotId[i],true);
		//}else{
		//ScreenLocY += shift;
		//C.SetPos(ScreenLocX, ScreenLocY);
		//C.DrawText("None",true);

		//}
	}
}


function DrawNavPoints(canvas Canvas)
{
	local NavigationPoint N;
	local vector CanvasPosition, ObserverPosition, ViewLocation;
	local rotator ViewRotation;
	local bool bIsCamera;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{

		if (PlayerOwner.Pawn != none)
		{
			ObserverPosition = PlayerOwner.Pawn.Location;
			ViewLocation = PlayerOwner.Pawn.Location;
			ViewRotation = PlayerOwner.Pawn.Rotation;
			bIsCamera = false;
		}
		else if (PlayerOwner.ViewTarget != none)
		{
			ObserverPosition = PlayerOwner.ViewTarget.Location;
			ViewLocation = PlayerOwner.CalcViewLocation;
			ViewRotation = PlayerOwner.CalcViewRotation;
			bIsCamera = true;
		}
		else
		{
			ObserverPosition = PlayerOwner.Location;
			ViewLocation = PlayerOwner.Location;
			ViewRotation = PlayerOwner.Rotation;
			bIsCamera = false;
		}

		if( PlayerOwner.FastTrace(N.Location, ViewLocation) && inFront(N.Location, ViewLocation, ViewRotation, bIsCamera))
		{
			CanvasPosition = Canvas.WorldToScreen(N.Location);
			DrawNavPointBeacon(Canvas,N,ObserverPosition,CanvasPosition.X,CanvasPosition.Y);
		}

	}
}

function bool inFront(Vector A, vector CameraLocation, rotator CameraRotation, bool bIsCamera)
{
	local rotator angle;
    local float remoteVisionLimit;
    remoteVisionLimit = 0.707;
	//can't be infront if inside bot

   	if( VSize(CameraLocation - A) < CollisionRadius)
   		return false;

	angle = ( CameraRotation - rotator(A - CameraLocation) );

	if (bIsCamera) //TODO: Still problems whe watching navpoints from above
	{
		if( (cos(angle.Yaw / 10435.0) < remoteVisionLimit))
			return false;
		else
			return true;
	}
	else
	{
		if( (cos(angle.Yaw / 10435.0) < remoteVisionLimit) ||
			(cos(angle.Pitch / 10435.0) < remoteVisionLimit) )
			return false;
		else
			return true;
	}

}

defaultproperties
{
	DrawNavPointBeacons = true;
	NavPointBeaconDrawDistance = 500;
}
