class GBClientClass extends TcpLink
	config(BotAPI);

// the main variables where we have incoming messages stored
var string ReceivedData;
var string ReceivedArgs[9];
var string ReceivedVals[9];

//used to store info inside function where local wont work
//set property text dosent seem to work with a local
var actor tempActor;

// set true for verbose debug logs
var config bool bDebug;

// set true for iterative mode
var config bool bIterative;

// enables disables cheating - invulnerability, spawning items for bots
var config bool bAllowCheats;

// if control server or bots can or cannot pause the game
var config bool bAllowPause;

var config bool bNewProtocol;

//For bot exporting (ExportPlayers())
var bool bExportHumanPlayers;
var bool bExportRemoteBots;
var bool bExportUnrealBots;

var GBClientClass Next; //create list of all classes

// delimeters for strings sent to clients. set to match those of the server
// as = identifies the start of an attribute
var string as;
// ae = attribute end
var string ae;
// ib = item break
var string ib;

//Here is where we handle incoming commands
/* Commands expected to look like:
runto {Argument value} {Arg value}...
Currently hard coded to take no more than 9 args
Command type and arguments can be
any length, but first space terminates the name. Values can
have spaces or any other kind of character.
*/
function ReceivedLine(string S)
{
	local string cmdType, argBody, rem;
	local int endloc, wordsplit, attrNum;

	if(bDebug)
		log(S);

	wordsplit = InStr(S,ib);
	if( wordsplit == -1)
		wordsplit = Len(S);

	cmdType = left(S,wordsplit);
	rem = mid(S,InStr(S,as));

	attrNum = 0;
	// clear previously received attr/val pairs
	while(attrNum < 9)
	{
		if (ReceivedArgs[attrNum] == "")
			break;

		ReceivedArgs[attrNum] = "";
		ReceivedVals[attrNum] = "";

		attrNum++;
	}

	attrNum = 0;

	//iterate through attr/val pairs, storring them in the
	//parallel arrays ReceivedArgs and ReceivedVals
	while(attrNum < 9 && rem != "")
	{
		endloc = InStr(rem,ae);
		argBody = mid(rem,1,(endloc - 1));

		wordsplit = InStr(argBody,ib);
		ReceivedArgs[attrNum] = left(argBody,wordsplit);
		ReceivedVals[attrNum] = mid(argBody,(wordsplit + 1));

		rem = mid(rem,1); //advance
		rem = mid(rem,InStr(rem,as));
		attrNum++;
	}

	cmdType = Caps(cmdType);

	ProcessAction(cmdType);
}

//Recieve info - parse into lines and call RecievedLine
event ReceivedText( string Text )
{
	local int i;
	local string S;

    if(bDebug)
    	log("Recieved - "$Text);

	ReceivedData = ReceivedData $ Text;

	// remove a LF which arrived in a new packet
	// and thus didn't get cleaned up by the code below
	if(Left(ReceivedData, 1) == Chr(10))
		ReceivedData = Mid(ReceivedData, 1);
	i = InStr(ReceivedData, Chr(13));
	while(i != -1)
	{
		S = Left(ReceivedData, i);
		i++;
		// check for any LF following the CR.
		if(Mid(ReceivedData, i, 1) == Chr(10))
			i++;

		ReceivedData = Mid(ReceivedData, i);

		ReceivedLine(S);

		if(LinkState != STATE_Connected)
			return;

		i = InStr(ReceivedData, Chr(13));
	}
}

function ProcessAction(string cmdType)
{
	//Shouldnt be called, just for inheritance
	log("Error - we are in GBClientClass, ProcessAction() ");
}

// function for getting string value of input received attribute
function string GetArgVal(string argName)
{

	local int i;
	while (i < 9 && ReceivedArgs[i] != "")
	{
		if (ReceivedArgs[i] ~= argName)
			return ReceivedVals[i];
		i++;
	}

	return "";
}

// should use int's for locations rather than floats
// we don't need to be that precise
function ParseVector(out vector v, string vecName)
{
	local int i;
	local string rem;
	local string delim;

	delim = ib;

	rem = GetArgVal(vecName);
	if(rem != "")
	{
		if( InStr(rem,delim) == -1 )
			delim = ",";
		i = InStr(rem,delim);
		v.X = float(left(rem,i));
		rem = mid(rem,i+1);
		i = InStr(rem,delim);
		v.Y = float(left(rem,i));
		v.Z = float(mid(rem,i+1));
	}
	else
	{
		v.x = float( GetArgVal("x") );
		v.y = float( GetArgVal("y") );
		v.z = float( GetArgVal("z") );
	}
}

// function for parsing rotation
function ParseRot(out rotator rot, string rotName)
{
    local int i;
    local string rem;
    //local float y,p,r;
    local string delim;

    delim = ib;

	rem = GetArgVal(rotName);
	if(rem != "")
	{
        if( InStr(rem,delim) == -1 )
        	delim = ",";
        i = InStr(rem,delim);
        rot.Pitch = float(left(rem,i));
        rem = mid(rem,i+1);
        i = InStr(rem,delim);
        rot.Yaw = float(left(rem,i));
        rot.Roll = float(mid(rem,i+1));
	}
	else
	{
		rot.Pitch = float( GetArgVal("pitch") );
		rot.Yaw = float( GetArgVal("yaw") );
		rot.Roll = float( GetArgVal("roll") );
	}
}

//Send a line to the client
function SendLine(string Text, optional bool bNoCRLF)
{
    if(bDebug)
    	log("    Sending: "$Text);
	if(bNoCRLF)
		SendText(Text);
	else
		SendText(Text$Chr(13)$Chr(10));
}

//Concat two strings togeather with our list bookends
function string MakeItem(string first, string second)
{
	return (as$first$ib$second$ae);
}

function SendGameInfo()
{
	local string gameInfoStr, levelName, PauseResult;
	local int i;

	gameInfoStr = BotDeathMatch(Level.Game).GetGameInfo();
	levelName = string(Level);
	i = InStr(Caps(levelName), ".LEVELINFO");

	if(i != -1)
		levelName = Left(levelName, i);

	if (Level.Pauser != None)
		PauseResult = "True";
	else
		PauseResult = "False";

	SendLine("NFO" $ib$as$ "Gametype" $ib$ BotDeathMatch(Level.Game).GameClass $ae$ib$as$
		"GamePaused" $ib$ PauseResult $ae$ib$as$
		"BotsPaused" $ib$ Level.bPlayersOnly $ae$ib$as$
		"Level" $ib$ levelName $ae$ gameInfoStr);
}

//Exports all navpoints in a level also with their reachable graph
function ExportNavPoints()
{
	local string message, item, itemClass, flag;
	local NavigationPoint N, First;
	local int i,PathListLength;

	SendLine("SNAV");
	First = Level.NavigationPointList.NextNavigationPoint; //will be used in second loop, to eliminate already procesed objects

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		item = "None";
		itemClass = "None";
		flag = "PathNode";
		if (N.IsA('InventorySpot'))
		{
			flag = "InventorySpot";

			// The items, which have pickup base DOES NOT have unique id.
			// We need to send unique id, so sending id of pickup base.
			if (InventorySpot(N).markedItem.PickUpBase == none)
				item = string(InventorySpot(N).markedItem);
			else
				item = string(InventorySpot(N).markedItem.PickUpBase);
			itemClass = string(InventorySpot(N).markedItem.class);
		}

		if (N.IsA('PlayerStart'))
		{
			flag = "PlayerStart";
		}


		if (N.IsA('AIMarker') && AIMarker(N).markedScript.IsA('UnrealScriptedSequence'))
		{

			flag = "AIMarker";

			message="INAV" $ib$as$ "Id" $ib$ N $ae$ib$as$
					"Location" $ib$ N.Location $ae$ib$as$
					"Flag" $ib$ flag $ae$ib$as$
					"Item" $ib$ item $ae$ib$as$
					"ItemClass" $ib$ itemClass $ae$ib$as$
					"Rotation" $ib$ UnrealScriptedSequence(AIMarker(N).markedScript).Rotation $ae$ib$as$
					"RoamingSpot" $ib$ UnrealScriptedSequence(AIMarker(N).markedScript).bRoamingScript $ae$ib$as$
					"SnipingSpot" $ib$ UnrealScriptedSequence(AIMarker(N).markedScript).bSniping $ae$ib$as$
					"PreferedWeapon" $ib$ UnrealScriptedSequence(AIMarker(N).markedScript).WeaponPreference $ae;

		}
		else
		{

			message="INAV" $ib$as$ "Id" $ib$ N $ae$ib$as$
					"Location" $ib$ N.Location $ae$ib$as$
					"Flag" $ib$ flag $ae$ib$as$
					"Item" $ib$ item $ae$ib$as$
					"ItemClass" $ib$ itemClass $ae;
		}

		i = 0;
		PathListLength = N.PathList.Length;
		while (i < PathListLength)
		{
			message = message$ib$as$"Neigh"$i$ib$as$"Id"$ib$N.PathList[i].End$ae$ib$as$"Flags"$ib$N.PathList[i].reachFlags$ae$ib$as$"CollisionR"$ib$N.PathList[i].CollisionRadius$ae$ib$as$"CollisionH"$ib$N.PathList[i].CollisionHeight$ae$ae;
			i++;
		}
		SendLine(message);
	}
	SendLine("ENAV");

}

function ExportInventory()
{
	local NavigationPoint N;
	local string uniqueId;

	SendLine("SINV");

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
	{
		if (N.IsA('InventorySpot'))
		{
			// The items, which have pickup base DOES NOT have unique id.
			// We need to send unique id, so sending id of pickup base.
			if (InventorySpot(N).markedItem.PickUpBase == none)
				uniqueId = string(InventorySpot(N).markedItem);
			else
				uniqueId = string(InventorySpot(N).markedItem.PickUpBase);

			SendLine("IINV" $ib$as$ "Id" $ib$ uniqueId $ae$ib$as$
				"Location" $ib$ String(InventorySpot(N).markedItem.Location) $ae$ib$as$
				"Class" $ib$ String(InventorySpot(N).markedItem.Class) $ae);
		}
	}
	SendLine("EINV");

}

//Exports all players in a level
function ExportPlayers()
{
	local Controller C;
	local string message;

	SendLine("SPLR");
	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if ((bExportRemoteBots && C.IsA('RemoteBot')) || (bExportHumanPlayers && C.IsA('GBxPlayer')) || (bExportUnrealBots && C.IsA('GBxBot')))
		{
			message = "IPLR"$ib$as$"Id"$ib$C$C.PlayerReplicationInfo.PlayerID$ae$ib$as$
							"Name"$ib$C.PlayerReplicationInfo.PlayerName$ae;
			if (C.Pawn != none)
				message = message$ib$as$
					"Location"$ib$C.Pawn.Location$ae$ib$as$
					"Rotation"$ib$C.Pawn.Rotation$ae;
			if (C.IsA('RemoteBot'))
				message = message$ib$as$
						"ManualSpawn" $ib$ !RemoteBot(C).bAutoSpawn $ae$ib$as$
						"AutoTrace" $ib$ RemoteBot(C).bAutoTrace $ae$ib$as$
						"Invulnerable" $ib$ RemoteBot(C).bGodMode $ae$ib$as$
						"VisionTime" $ib$ RemoteBot(C).myConnection.VisionTime $ae$ib$as$
						"ShowDebug" $ib$ RemoteBot(C).bDebug $ae$ib$as$
						"ShowFocalPoint" $ib$ RemoteBot(C).bShowFocalPoint $ae$ib$as$
						"DrawTraceLines" $ib$ RemoteBot(C).bDrawTraceLines $ae;
			SendLine(message);
		}

    }
    SendLine("EPLR");

}

function GetPlayers()
{
	local Controller C;
	local string message;
	local string Dead;

	for(C = Level.ControllerList; C != None; C = C.NextController )
	{
		if (C.IsA('RemoteBot') || C.IsA('GBxPlayer') || C.IsA('GBxBot'))
		{
			/*if (C.IsA('RemoteBot')
			{
				Type = "RemoteBot";
			}*/

			if (C.Pawn == None)
				Dead = "True";
			else
				Dead = "False";

			message = "PLR"$ib$as$"Id"$ib$C$C.PlayerReplicationInfo.PlayerID$ae$ib$as$
							"Name"$ib$C.PlayerReplicationInfo.PlayerName$ae$ib$as$
							"PlayerType" $ib$ C $ae$ib$as$
							"PlayerDead" $ib$ Dead $ae;
			if (C.Pawn != none)
			{
				message = message$ib$as$
					"Location" $ib$ C.Pawn.Location $ae$ib$as$
					"Rotation" $ib$ C.Pawn.Rotation $ae;
			}

			SendLine(message);
		}

    }
}

defaultproperties
{
	bAllowPause=true
	bNewProtocol=true
	bExportHumanPlayers=true
	bExportRemoteBots=true
	bExportUnrealBots=true
	as="{"
	ae="}"
	ib=" "
}
