/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.pogamut.Client.Agent;
import java.util.prefs.Preferences;

public class Settings {
    public static final String SERVER_UPDATE_FREQUENCY = "ServerUpdateFrequency";
    public static final String PREFERRED_PARSER_TYPE = "PreferredParserType";
    public static final String PLATFORM_DIR = "PlatformDir";
    public static final String LOG_WIN_BEHAVIOR = "LogWinBehavior";
    public static final String LAUNCHER_PORT = "LauncherPort";
    protected static final Preferences pref = Preferences.userNodeForPackage(Agent.class);

    public static Preferences getPrefecences() {
        return pref;
    }

    public static Object get(Setting setting) {
        Object def = setting.def;
        if (String.class.isInstance(def)) {
            return pref.get(setting.key, (String)def);
        }
        if (Integer.class.isInstance(def)) {
            return pref.getInt(setting.key, (Integer)def);
        }
        if (Float.class.isInstance(def)) {
            return Float.valueOf(pref.getFloat(setting.key, ((Float)def).floatValue()));
        }
        return null;
    }

    public static void set(Setting setting, Object val) {
        if (String.class.isInstance(val)) {
            pref.put(setting.key, (String)val);
        } else if (Integer.class.isInstance(val)) {
            pref.putInt(setting.key, (Integer)val);
        } else if (Float.class.isInstance(val)) {
            pref.putFloat(setting.key, ((Float)val).floatValue());
        } else {
            System.err.println("Trying to write wrong setting.");
        }
    }

    public static enum Setting {
        SERVER_UPDATE_FREQUENCY("ServerUpdateFrequency", Float.valueOf(0.5f)),
        PREFERRED_PARSER_TYPE("PreferredParserType", "REMOTE"),
        PLATFORM_DIR("PlatformDir", ""),
        LOG_WIN_BEHAVIOR("LogWinBehavior", "NEW"),
        LAUNCHER_PORT("LauncherPort", 3974);

        public String key = null;
        public Object def = null;

        private Setting(String key, Object def) {
            this.key = key;
            this.def = def;
        }
    }
}

