/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.utils.Config;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class BotProjectsClassLoader
extends URLClassLoader {
    public BotProjectsClassLoader() {
        super(BotProjectsClassLoader.getUrlsOfBotJars(new File(Config.getProjectsPath())), ClassLoader.getSystemClassLoader());
    }

    public BotProjectsClassLoader(File projectsDir, ClassLoader parent) {
        super(BotProjectsClassLoader.getUrlsOfBotJars(projectsDir), parent);
    }

    public static URL[] getUrlsOfBotJars(File rootDir) {
        if (rootDir == null) {
            return new URL[0];
        }
        File[] projectDirs = rootDir.listFiles();
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        for (File potencialProjectDir : projectDirs) {
            URL jarFile = BotProjectsClassLoader.getBotJar(potencialProjectDir);
            if (jarFile == null) continue;
            jarUrls.add(jarFile);
        }
        return jarUrls.toArray(new URL[0]);
    }

    public static URL getBotJar(File projectDir) {
        File potencialJar = new File(projectDir, "dist" + File.separator + projectDir.getName() + ".jar");
        if (potencialJar.exists()) {
            try {
                return potencialJar.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

