/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.server;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.GameInfo;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.UTMap;
import cz.cuni.pogamut.communication.CommunicationState;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.experiments.Experiment;
import cz.cuni.pogamut.server.BotEnteredWorldListener;
import cz.cuni.pogamut.server.BotLeftWorldListener;
import cz.cuni.pogamut.server.ParserType;
import cz.cuni.pogamut.server.UTServerConnection;
import cz.cuni.pogamut.server.UTServerInfoSnapshot;
import cz.cuni.pogamut.server.UTServerState;
import cz.cuni.pogamut.server.UTWorld;
import cz.cuni.pogamut.server.requests.ConfigurationParameter;
import cz.cuni.pogamut.server.requests.UTServerRequest;
import cz.cuni.pogamut.server.requests.UTServerRequestConfigChange;
import cz.cuni.pogamut.server.requests.UTServerRequestInventory;
import cz.cuni.pogamut.server.requests.UTServerRequestItems;
import cz.cuni.pogamut.server.requests.UTServerRequestMaps;
import cz.cuni.pogamut.server.requests.UTServerRequestNavPoints;
import cz.cuni.pogamut.server.requests.UTServerRequestPlayers;
import cz.cuni.pogamut.server.requests.UTServerRequestReconnect;
import cz.cuni.utils.Flag;
import cz.cuni.utils.FlagListener;
import cz.cuni.utils.Settings;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class UTServer
implements UTWorld,
Serializable,
FlagListener {
    private transient Logger log = null;
    private transient Logger rawGBLog = null;
    private transient UTServerConnection connection = null;
    private transient Set<BotEnteredWorldListener> botEnteredWorldListeners = null;
    private transient Set<BotLeftWorldListener> botLeftWorldListeners = null;
    protected UTServerInfoSnapshot info = new UTServerInfoSnapshot();
    protected transient CountDownLatch waitNavPoints = null;
    protected transient CountDownLatch waitItems = null;
    protected transient CountDownLatch waitMaps = null;
    protected transient CountDownLatch waitRefreshInfo = null;
    protected transient CountDownLatch waitInventory = null;

    public UTServer() {
        this.init();
    }

    protected void init() {
        this.botEnteredWorldListeners = new HashSet<BotEnteredWorldListener>();
        this.botLeftWorldListeners = new HashSet<BotLeftWorldListener>();
        this.log = Logger.getAnonymousLogger();
        this.rawGBLog = Logger.getAnonymousLogger();
        this.info.serverStateFlag = new Flag<UTServerState>(UTServerState.NONE);
        this.info.serverStateFlag.addListener(this);
        this.connection = new UTServerConnection(this);
        Float freq = (Float)Settings.get(Settings.Setting.SERVER_UPDATE_FREQUENCY);
        int millis = (int)(1000.0f / freq.floatValue());
        this.setPongTimeoutMillis(millis);
        this.setAutoReconnectMillis(millis);
    }

    public String toString() {
        String adr = null;
        adr = this.info.serverURI == null ? "" : this.info.serverURI.toString();
        return this.info.name + " (" + adr + ")";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public boolean request(UTServerRequest request) {
        return this.connection.request(request);
    }

    public Flag<UTServerState> getServerStateFlag() {
        return this.info.serverStateFlag;
    }

    public UTServerState getServerState() {
        return this.info.serverStateFlag.getFlag();
    }

    public boolean isAutomaticallyReconnect() {
        return this.info.automaticallyReconnect;
    }

    public void setAutomaticallyReconnect(boolean automaticallyReconnect) {
        this.info.automaticallyReconnect = automaticallyReconnect;
        this.connection.request(new UTServerRequestConfigChange(ConfigurationParameter.AUTO_RECONNECT, new Boolean(this.info.automaticallyReconnect)));
    }

    public UTServerConnection getConnection() {
        return this.connection;
    }

    public void setConnection(UTServerConnection connection) {
        this.connection = connection;
    }

    public boolean isPingPong() {
        return this.info.pingPong;
    }

    public void setPingPong(boolean pingPong) {
        this.info.pingPong = pingPong;
        this.connection.request(new UTServerRequestConfigChange(ConfigurationParameter.PING_CONNECTION, new Boolean(this.info.pingPong)));
    }

    public int getPongTimeoutMillis() {
        return this.info.pongTimeoutMillis;
    }

    public void setPongTimeoutMillis(int pongTimeoutMillis) {
        this.info.pongTimeoutMillis = pongTimeoutMillis;
    }

    public Logger getLog() {
        return this.log;
    }

    public URI getServerURI() {
        return this.info.serverURI;
    }

    public void setServerURI(URI serverURI) {
        this.info.serverURI = serverURI;
        this.connection.request(new UTServerRequestConfigChange(ConfigurationParameter.URI, serverURI));
    }

    public void setServerRemoteParserURI(URI serverURI) {
        this.info.serverRemoteParserURI = serverURI;
    }

    public URI getServerRemoteParserURI() {
        return this.info.serverRemoteParserURI;
    }

    public int getAutoReconnectMillis() {
        return this.info.autoReconnectMillis;
    }

    public void setAutoReconnectMillis(int autoReconnectMillis) {
        this.info.autoReconnectMillis = autoReconnectMillis;
    }

    public Logger getRawGBLog() {
        return this.rawGBLog;
    }

    public GameInfo getGameInfo() {
        return this.info.gameInfo;
    }

    protected void setGameInfo(GameInfo gameInfo) {
        this.info.gameInfo = gameInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flagChanged(Object changedValue, int listenerParam) {
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            switch ((UTServerState)((Object)changedValue)) {
                case UNAVAILABLE: 
                case TERMINATED: {
                    if (this.waitItems != null) {
                        this.waitItems.countDown();
                    }
                    if (this.waitMaps != null) {
                        this.waitMaps.countDown();
                    }
                    if (this.waitNavPoints != null) {
                        this.waitNavPoints.countDown();
                    }
                    if (this.waitRefreshInfo == null) break;
                    this.waitRefreshInfo.countDown();
                }
            }
        }
    }

    public void terminate() {
        this.connection.terminate();
    }

    public void finalize() {
        this.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshInformations() {
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.getServerState() != UTServerState.RUNNING && this.getServerState() != UTServerState.PAUSED) {
                return false;
            }
            if (this.waitRefreshInfo == null) {
                this.waitRefreshInfo = new CountDownLatch(1);
            } else if (this.waitRefreshInfo.getCount() == 0L) {
                this.waitRefreshInfo = new CountDownLatch(1);
            }
        }
        this.request(new UTServerRequestPlayers());
        try {
            this.waitRefreshInfo.await();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public void reconnect() {
        this.request(new UTServerRequestReconnect());
    }

    public boolean waitForCommunication() {
        if (this.info.serverURI == null) {
            return false;
        }
        if (this.info.serverURI.equals(this.connection.getCurrentURI())) {
            return true;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        Flag<UTServerState> flag = this.getServerStateFlag();
        FlagListener<UTServerState> listener = new FlagListener<UTServerState>(){

            @Override
            public void flagChanged(UTServerState changedValue, int listenerParam) {
                switch (changedValue) {
                    case RUNNING: 
                    case PAUSED: {
                        latch.countDown();
                        break;
                    }
                    case UNAVAILABLE: 
                    case TERMINATED: {
                        latch.countDown();
                    }
                }
            }
        };
        flag.addListener(listener);
        if (this.getServerState() == UTServerState.RUNNING || this.getServerState() == UTServerState.PAUSED) {
            flag.removeListener(listener);
            return true;
        }
        if (this.getServerState() == UTServerState.NONE || this.getServerState() == UTServerState.UNAVAILABLE) {
            this.reconnect();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        flag.removeListener(listener);
        return this.getServerState() == UTServerState.RUNNING || this.getServerState() == UTServerState.PAUSED;
    }

    public synchronized Set<Player> getPlayers() {
        return this.info.players;
    }

    protected void removeExperiment() {
        this.setServerOpened(true);
        Flag<Experiment.ExperimentState> state = this.info.actualExperiment.getExperimentState();
        state.removeListener(this.info.experimentStateListener);
        this.info.experimentStateListener = null;
        this.info.actualExperiment = null;
    }

    public void terminateExperiment() {
        if (this.info.actualExperiment != null) {
            this.info.actualExperiment.experimentEnd();
        }
    }

    public void addRcvMsgListener(RcvMsgListener listener) {
        this.connection.addRcvMsgListener(listener);
    }

    public void removeRcvMsgListener(RcvMsgListener listener) {
        this.connection.removeRcvMsgListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UTServerInfoSnapshot getSnapshot() {
        UTServerInfoSnapshot uTServerInfoSnapshot = this.info;
        synchronized (uTServerInfoSnapshot) {
            return (UTServerInfoSnapshot)this.info.clone();
        }
    }

    public Agent loadBotFromClass(String className, String classPath) throws PogamutException {
        try {
            File f = new File(classPath);
            URL url = f.toURI().toURL();
            URLClassLoader cl = new URLClassLoader(new URL[]{url}, this.getClass().getClassLoader());
            Class<?> c = cl.loadClass(className);
            return (Agent)c.newInstance();
        }
        catch (Exception e) {
            throw new PogamutException("Loading bot from class failed.");
        }
    }

    public Agent loadBotFromJar(String pathToJar) throws PogamutException, IOException {
        File f = new File(pathToJar);
        JarFile jarFile = new JarFile(f);
        Manifest m = jarFile.getManifest();
        if (m == null) {
            throw new PogamutException("Manifest file not found.");
        }
        return this.loadBotFromClass(m.getMainAttributes().getValue("Bot-class"), pathToJar);
    }

    public boolean isServerOpened() {
        return this.info.serverOpened;
    }

    public void setServerOpened(boolean opened) {
        this.info.serverOpened = opened;
    }

    public void setName(String name) {
        this.info.name = name;
    }

    @Override
    public boolean isConnectionAlive() {
        switch (this.getServerState()) {
            case UNAVAILABLE: 
            case TERMINATED: 
            case NONE: 
            case INITIALIZING: {
                return false;
            }
            case RUNNING: 
            case PAUSED: 
            case HANDSHAKE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public String getMap() {
        if (this.info.gameInfo == null) {
            return null;
        }
        return this.info.gameInfo.level;
    }

    @Override
    public boolean setMap(String name) throws PogamutException {
        return this.connection.changeMap(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<UTMap> getAvailableMaps() {
        if (this.info.maps != null) {
            return this.info.maps;
        }
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.waitMaps == null) {
                this.waitMaps = new CountDownLatch(1);
            } else if (this.waitMaps.getCount() == 0L) {
                this.waitMaps = new CountDownLatch(1);
            }
            this.request(new UTServerRequestMaps());
        }
        try {
            this.waitMaps.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.info.maps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<NavPoint> getNavPoints() throws PogamutException {
        if (this.info.navPoints != null) {
            return this.info.navPoints;
        }
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.waitNavPoints == null) {
                this.waitNavPoints = new CountDownLatch(1);
            } else if (this.waitNavPoints.getCount() == 0L) {
                this.waitNavPoints = new CountDownLatch(1);
            }
            this.request(new UTServerRequestNavPoints());
        }
        try {
            this.waitNavPoints.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.info.navPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Collection<Item> getItems() {
        if (this.info.items != null) {
            return this.info.items;
        }
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.waitItems == null) {
                this.waitItems = new CountDownLatch(1);
            } else if (this.waitItems.getCount() == 0L) {
                this.waitItems = new CountDownLatch(1);
            }
            this.request(new UTServerRequestItems());
        }
        try {
            this.waitItems.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.info.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Item> getInventory() {
        if (this.info.inventory != null) {
            return this.info.inventory;
        }
        Flag<UTServerState> flag = this.info.serverStateFlag;
        synchronized (flag) {
            if (this.waitInventory == null) {
                this.waitInventory = new CountDownLatch(1);
            } else if (this.waitInventory.getCount() == 0L) {
                this.waitInventory = new CountDownLatch(1);
            }
            this.request(new UTServerRequestInventory());
        }
        try {
            this.waitInventory.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.info.inventory;
    }

    @Override
    public Collection<Player> getAllBots() throws PogamutException {
        return this.info.players;
    }

    @Override
    public synchronized Collection<Agent> getConnectedBots() {
        return this.info.bots;
    }

    @Override
    public void connectBot(Agent newBot) throws PogamutException {
        this.connectBot(newBot, newBot.getName());
    }

    public void connectBot(Agent newBot, ParserType parserType) throws PogamutException {
        this.connectBot(newBot, newBot.getName(), parserType);
    }

    @Override
    public void connectBot(Agent bot, String botName) throws PogamutException {
        this.connectBot(bot, botName, this.getPreferredParserType());
    }

    private ParserType getPreferredParserType() {
        Preferences pref = Preferences.userNodeForPackage(Agent.class);
        ParserType parserType = null;
        String parserTypeStr = pref.get("PreferredParserType", "REMOTE");
        parserType = parserTypeStr.equals("REMOTE") && this.getServerRemoteParserURI() != null ? ParserType.REMOTE : ParserType.LOCAL;
        return parserType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectBot(final Agent bot, final String botName, ParserType parserType) throws PogamutException {
        try {
            switch (parserType) {
                case LOCAL: {
                    bot.bindLocalParser(this.info.serverURI);
                    break;
                }
                case REMOTE: {
                    try {
                        bot.bindRemoteParser(this.info.serverRemoteParserURI);
                    }
                    catch (ConnectException ex) {
                        ex.printStackTrace();
                        this.log.severe("Can't connect bot to remote server (" + this.info.serverRemoteParserURI.toString() + ") using local parser.");
                        bot.bindLocalParser(this.info.serverURI);
                    }
                    break;
                }
            }
        }
        catch (ConnectException ex) {
            ex.printStackTrace();
            throw new PogamutException("Connection refused.", ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new PogamutException("Cant write/read to socket.", ex);
        }
        List<Agent> ex = this.info.bots;
        synchronized (ex) {
            this.info.bots.add(bot);
        }
        Thread startThread = new Thread(new Runnable(){

            @Override
            public void run() {
                bot.startAgent(botName, false);
                for (BotEnteredWorldListener listener : UTServer.this.botEnteredWorldListeners) {
                    listener.botEnteredWorld(bot);
                }
            }
        }, "Starting agent (UTServer.connectBot())");
        startThread.start();
    }

    @Override
    public void connectOriginalBot(String name, Triple location, int difficultyLevel, int team) throws PogamutException {
        if (difficultyLevel > 7) {
            difficultyLevel = 7;
        }
        if (difficultyLevel < 1) {
            difficultyLevel = 1;
        }
        this.connection.sendCommandToGB("ADDBOT {Name " + name + "}" + "{StartLocation " + location.toString() + "}" + "{StartRotation 0,0,65000}" + "{Skill " + difficultyLevel);
    }

    @Override
    public void respawnBot(String botUnrealId) throws PogamutException {
        this.connection.sendCommandToGB("RESPAWN {Id " + botUnrealId + "}");
    }

    @Override
    public void respawnBot(String botUnrealId, Triple location) throws PogamutException {
        this.connection.sendCommandToGB("RESPAWN {Id " + botUnrealId + "}{Location " + location.toString() + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kickBot(String botUnrealId) throws PogamutException {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            for (Agent bot : this.info.bots) {
                if (!bot.getMemory().getAgentUnrealID().equals(botUnrealId)) continue;
                this.disconnectBot(bot);
                return;
            }
        }
        this.connection.sendCommandToGB("KICK {Id " + botUnrealId + "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectBot(String botUnrealId) {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            for (Agent bot : this.info.bots) {
                if (!bot.getMemory().getAgentUnrealID().equals(botUnrealId)) continue;
                this.disconnectBot(bot);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectAllBots() {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            for (Agent bot : this.info.bots) {
                bot.disconnect();
            }
        }
    }

    @Override
    public void pause(boolean completely) throws PogamutException {
        if (completely) {
            this.connection.sendCommandToGB("PAUSE {PauseBots False} {PauseAll True}");
        } else {
            this.connection.sendCommandToGB("PAUSE {PauseBots True} {PauseAll False}");
        }
    }

    @Override
    public void resume() throws PogamutException {
        this.connection.sendCommandToGB("PAUSE {PauseBots False} {PauseAll False}");
    }

    @Override
    public void addInventory(String botUnrealId, String inventoryClass) throws PogamutException {
        this.connection.sendCommandToGB("ADDINV {Id " + botUnrealId + "}{Class " + inventoryClass + "}");
    }

    @Override
    public void changeAttribute(String botUnrealId, String attribute, String value) throws PogamutException {
        if (attribute.equals("Health")) {
            int health = Integer.parseInt(value);
            if (health < 1) {
                health = 1;
            }
            if (health > 199) {
                health = 199;
            }
            this.connection.sendCommandToGB("CHATTR {Health " + health + "}");
        }
    }

    @Override
    public void botInvulnerable(String botUnrealId, boolean invulnerable) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{Invulnerable " + (invulnerable ? "True" : "False") + "}");
    }

    @Override
    public void botAutoTrace(String botUnrealId, boolean autoTrace) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{AutoTrace " + (autoTrace ? "True" : "False") + "}");
    }

    @Override
    public void botManualSpawn(String botUnrealId, boolean manualSpawn) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{ManualSpawn " + (manualSpawn ? "True" : "False") + "}");
    }

    public void botShowDebug(String botUnrealId, boolean showDebug) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{ShowDebug " + (showDebug ? "True" : "False") + "}");
    }

    public void botShowFocalPoint(String botUnrealId, boolean showFocalPoint) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{ShowFocalPoint " + (showFocalPoint ? "True" : "False") + "}");
    }

    public void botDrawTraceLines(String botUnrealId, boolean drawTraceLines) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{DrawTraceLines" + (drawTraceLines ? "True" : "False") + "}");
    }

    @Override
    public void setBotName(String botUnrealId, String name) throws PogamutException {
        this.connection.sendCommandToGB("CONF {Id " + botUnrealId + "}{Name " + name + "}");
    }

    @Override
    public void setVisionTime(double visionTime) throws PogamutException {
        if (visionTime < 0.1) {
            visionTime = 0.1;
        }
        if (visionTime > 2.0) {
            visionTime = 2.0;
        }
        this.connection.sendCommandToGB("CONF {VisionTime " + visionTime + "}");
    }

    @Override
    public void setGameSpeed(double speed) throws PogamutException {
        if (speed < 0.1) {
            speed = 0.1;
        }
        if (speed > 1.0) {
            speed = 1.0;
        }
        this.connection.sendCommandToGB("SETGAMESPEED {Speed " + speed + "}");
    }

    @Override
    public void startRecording(String fileName) throws PogamutException {
        this.connection.sendCommandToGB("REC {Filename " + fileName + "}");
    }

    @Override
    public void stopRecording() throws PogamutException {
        this.connection.sendCommandToGB("STOPREC");
    }

    @Override
    public void addBotEnteredWorldListener(BotEnteredWorldListener listener) {
        this.botEnteredWorldListeners.add(listener);
    }

    @Override
    public void removeBotEnteredWorldListener(BotEnteredWorldListener listener) {
        this.botEnteredWorldListeners.remove(listener);
    }

    @Override
    public void addBotLeftWorldListener(BotLeftWorldListener listener) {
        this.botLeftWorldListeners.add(listener);
    }

    @Override
    public void removeBotLeftWorldListener(BotLeftWorldListener listener) {
        this.botLeftWorldListeners.remove(listener);
    }

    @Override
    public void disconnectBot(Agent bot) {
        bot.disconnect();
        for (BotLeftWorldListener listener : this.botLeftWorldListeners) {
            listener.botLeftWorld(bot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBot(Agent bot) {
        if (!CommunicationState.getEndStates().contains((Object)bot.getCommunicationState())) {
            this.disconnectBot(bot);
        }
        List<Agent> list = this.info.bots;
        synchronized (list) {
            this.removeBotInner(bot);
        }
    }

    private void removeBotInner(Agent bot) {
        this.info.bots.remove(bot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBots() {
        List<Agent> list = this.info.bots;
        synchronized (list) {
            while (this.info.bots.size() != 0) {
                this.removeBotInner(this.info.bots.get(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Agent> removeDisconnectedBots() {
        Collection<Agent> toBeRemoved = this.getDisconnectedBots();
        List<Agent> list = this.info.bots;
        synchronized (list) {
            this.info.bots.removeAll(toBeRemoved);
        }
        return toBeRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Agent> getDisconnectedBots() {
        HashSet<Agent> col = new HashSet<Agent>();
        List<Agent> list = this.info.bots;
        synchronized (list) {
            for (Agent bot : this.info.bots) {
                if (!CommunicationState.getEndStates().contains((Object)bot.getCommunicationState())) continue;
                col.add(bot);
            }
        }
        return col;
    }

    @Override
    public synchronized boolean registerExperiment(Experiment experiment) {
        if (this.info.actualExperiment == null) {
            this.setServerOpened(false);
            this.info.actualExperiment = experiment;
            this.info.experimentStateListener = new FlagListener<Experiment.ExperimentState>(){

                @Override
                public void flagChanged(Experiment.ExperimentState changedValue, int listenerParam) {
                    System.out.println(changedValue.toString());
                    if (EnumSet.of(Experiment.ExperimentState.FINISHED, Experiment.ExperimentState.FAILED).contains((Object)changedValue)) {
                        UTServer.this.removeExperiment();
                    }
                }
            };
            experiment.getExperimentState().addListener(this.info.experimentStateListener);
            return true;
        }
        return false;
    }
}

