/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.introspection.python;

import cz.cuni.pogamut.introspection.python.PyObjectPlace;
import cz.cuni.pogamut.introspection.python.PyObjectWrapper;
import cz.cuni.pogamut.introspection.python.PyObjectWrappersManager;
import cz.cuni.pogamut.introspection.python.PyUnsupportedWrapper;
import java.util.ArrayList;
import org.python.core.PyObject;

public class PyObjectAdapter {
    private String name = null;
    private PyObjectPlace place = null;

    private PyObjectAdapter(String name) {
        this.name = name;
        this.place = null;
    }

    public PyObjectAdapter(String name, PyObjectPlace place) {
        this(name);
        this.place = place;
    }

    public String toString() {
        return "PyObjectAdapter(" + this.name + ")";
    }

    public ArrayList<PyObjectAdapter> getChildren() {
        Object object = this.place.get();
        PyObjectWrapper wrapper = this.getWrapper(object);
        if (wrapper instanceof PyUnsupportedWrapper) {
            return new ArrayList<PyObjectAdapter>(0);
        }
        ArrayList<PyObjectAdapter> list = wrapper.getChildren(object);
        if (list == null) {
            return new ArrayList<PyObjectAdapter>(0);
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public PyObjectWrapper getWrapper(Object object) {
        return PyObjectWrappersManager.getWrapper(object.getClass());
    }

    public Object getObject() {
        return this.place.get();
    }

    public Object getJavaObject() {
        Object obj = this.place.get();
        if (!(obj instanceof PyObject)) {
            return obj;
        }
        PyObject pyObj = (PyObject)obj;
        PyObjectWrapper wrapper = this.getWrapper(pyObj);
        if (wrapper instanceof PyUnsupportedWrapper) {
            return null;
        }
        return wrapper.getJavaObject(pyObj);
    }

    public void set(PyObjectWrapper wrapper, Object newValue) {
        if (this.place != null) {
            this.place.set(wrapper.getNewValue(newValue));
        }
    }

    public boolean hasChildren() {
        Object object = this.place.get();
        return this.getWrapper(object).hasChildren(object);
    }
}

