/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.exampleBots;

import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.Client.BaseBot;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;

public class SimpleBot
extends BaseBot {
    Item choosenItem = null;
    private boolean jumped;
    private NavPoint choosenNavPoint = null;
    private int walking = 0;

    public SimpleBot() {
        this.log.setLevel(Level.INFO);
        this.platformLog.setLevel(Level.INFO);
    }

    @Override
    protected void postPrepareAgent() {
    }

    @Override
    protected void doLogic() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.severe("Agent was ruthlessly interrupted during the sleep!");
            e.printStackTrace();
        }
        if (!this.memory.hasSelf()) {
            return;
        }
        if (this.memory.isColliding()) {
            this.stateWalking();
            return;
        }
        if (this.seeAnyReachableItemAndWantIt()) {
            this.stateSeeItem();
            return;
        }
        if (this.memory.getSeeAnyReachableNavPoint()) {
            this.stateSeeNavpoint();
            return;
        }
        this.stateTurnAround();
    }

    protected void stateWalking() {
        this.log.log(Level.INFO, "Decision is: WALKING");
        if (this.memory.isColliding()) {
            if (!this.jumped) {
                this.body.jump();
                this.jumped = true;
            } else {
                this.choosenNavPoint = null;
                this.body.stop();
                this.jumped = false;
            }
        }
        if (this.memory.isFalling()) {
            this.body.sendGlobalMessage("I am flying like a bird:D!");
            this.log.info("I'm flying like an angel to the sky ... it's so high ... oh, I am high! :-)");
        }
        if (this.memory.isBumpingToAnotherActor()) {
            this.body.stop();
        }
    }

    private boolean seeAnyReachableItemAndWantIt() {
        this.choosenItem = this.memory.getSeeAnyReachableItem() ? this.chooseItem() : null;
        return this.choosenItem != null;
    }

    private Item chooseItem() {
        if (this.memory.getSeeAnyReachableWeapon()) {
            Weapon weapon = this.memory.getSeeReachableWeapon();
            if (this.memory.hasWeaponOfType(weapon.weaponType)) {
                return null;
            }
            return weapon;
        }
        if (this.memory.getSeeAnyReachableArmor()) {
            return this.memory.getSeeReachableArmor();
        }
        if (this.memory.getSeeAnyReachableHealth() && this.memory.getAgentHealth() < 90) {
            return this.memory.getSeeReachableHealth();
        }
        if (this.memory.getSeeAnyReachableAmmo() && this.memory.isAmmoSuitable(this.memory.getSeeReachableAmmo())) {
            return this.memory.getSeeAmmo();
        }
        return null;
    }

    protected void stateSeeItem() {
        this.log.log(Level.INFO, "Decision is: SEE_ITEM --- Running for: " + this.choosenItem.toString());
        this.body.runToLocation(this.choosenItem.location);
        this.jumped = false;
    }

    protected void stateSeeNavpoint() {
        this.log.log(Level.INFO, "Decision is: SEE_NAVPOINT");
        if (this.choosenNavPoint != null) {
            if (Triple.distanceInSpace(this.memory.getAgentLocation(), this.choosenNavPoint.location) < 14.0) {
                this.choosenNavPoint = null;
            } else {
                ++this.walking;
                this.body.runToNavPoint(this.choosenNavPoint);
                if (this.walking > 12) {
                    this.choosenNavPoint = null;
                    this.walking = 0;
                }
            }
            return;
        }
        ArrayList<NavPoint> candidates = this.memory.getSeeNavPoints();
        int index = this.random.nextInt(candidates.size());
        this.choosenNavPoint = candidates.get(index);
        if (Triple.distanceInSpace(this.memory.getAgentLocation(), this.choosenNavPoint.location) < 200.0) {
            this.choosenNavPoint = null;
        }
        this.jumped = false;
    }

    protected void stateTurnAround() {
        this.log.log(Level.INFO, "Decision is: TURN_AROUND");
        this.body.turnHorizontal(80);
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            this.log.severe("Agent was ruthlessly interrupted during the sleep!");
            e.printStackTrace();
        }
    }

    public static void main(String[] Args) {
        SimpleBot bot = new SimpleBot();
        boolean localParser = true;
        URI uri = null;
        try {
            uri = new URI("ut://artemis.ms.mff.cuni.cz:3000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("URI creation failed, terminating.");
            System.exit(0);
        }
        AgentLauncher launcher = new AgentLauncher(bot, uri, localParser);
        launcher.setLogToScreen();
        launcher.launch();
    }
}

