/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.exampleBots;

import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.Client.BaseBot;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

public class InventoryBot
extends BaseBot {
    Item choosenItem = null;
    ArrayList<Item> choosenMedKits = null;
    private boolean runAlongPathInitialized = false;
    private boolean useAStar = false;
    private boolean pathRestart = false;
    private ArrayList<Item> itemsToRunAround = null;
    private Triple pl = null;
    private int runningToNavPointID = 0;
    private boolean jumped;
    private boolean running = false;
    private int walkAttempts = 0;

    public InventoryBot() {
        this.log.setLevel(Level.INFO);
        this.platformLog.setLevel(Level.INFO);
    }

    @Override
    protected void postPrepareAgent() {
        this.itemsToRunAround = new ArrayList();
        for (Weapon item : this.memory.getKnownWeapons()) {
            this.itemsToRunAround.add(item);
        }
        Collections.shuffle(this.itemsToRunAround);
    }

    @Override
    protected void doLogic() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.severe("Agent was ruthlessly interrupted during the sleep!");
            e.printStackTrace();
        }
        if (!this.memory.hasSelf()) {
            return;
        }
        if (this.memory.hasLoadedWeapon() && this.hasEnoughWeapons() && !this.memory.isShooting()) {
            this.stateShootFrenzy();
            return;
        }
        if (!this.memory.hasLoadedWeapon() && this.memory.hasAnyLoadedWeapon()) {
            this.stateRearm();
            return;
        }
        if (!this.memory.hasLoadedWeapon() && this.memory.isShooting()) {
            this.stateStopShooting();
            return;
        }
        if (this.memory.isColliding()) {
            this.stateWalking();
            return;
        }
        if (this.seeAnyReachableItemAndWantIt()) {
            this.stateSeeItem();
            return;
        }
        this.stateRunAroundItems();
    }

    public void stateShootFrenzy() {
        this.log.log(Level.INFO, "Decision is: SHOOT FRENZY");
        this.body.shoot(Triple.subtract(this.memory.getAgentLocation(), new Triple(100.0, 100.0, 0.0)));
    }

    protected boolean hasEnoughWeapons() {
        return this.memory.numberOfWeapons() > 1;
    }

    protected void stateRearm() {
        this.log.log(Level.INFO, "Decision is: REARM number of weapons is: " + this.memory.numberOfWeapons());
        AddWeapon weapon = this.memory.getAnyWeapon();
        this.body.changeWeapon(weapon);
        this.platformLog.info("switching to another weapon: " + weapon);
    }

    protected void stateStopShooting() {
        this.log.log(Level.INFO, "Decision is: STOP_SHOOTING");
        this.body.stopShoot();
    }

    protected void stateHit() {
        this.log.log(Level.INFO, "Decision is: HIT");
        this.body.turnHorizontal(355);
    }

    protected void stateWalking() {
        this.log.log(Level.INFO, "Decision is: WALKING");
        if (this.memory.isColliding()) {
            if (!this.jumped) {
                this.body.jump();
                this.jumped = true;
            } else {
                this.body.stop();
                this.running = false;
                this.jumped = false;
            }
        }
        if (this.memory.isFalling()) {
            this.body.sendGlobalMessage("I am flying like a bird:D!");
            this.log.info("I'm flying like an angel to the sky ... it's so high ... oh, I am high! :-)");
        }
        if (this.memory.isBumpingToAnotherActor()) {
            this.body.stop();
            this.running = false;
        }
    }

    private Weapon chooseWeapon() {
        ArrayList<Weapon> weapons = this.memory.getSeeReachableWeapons();
        for (Weapon weapon : weapons) {
            if (this.memory.getCurrentWeapon() == null) {
                return weapon;
            }
            if (this.memory.getCurrentWeapon().melee && !weapon.isMelee() && !this.memory.hasWeaponOfType(weapon.weaponType)) {
                return weapon;
            }
            if (this.memory.getCurrentWeapon().melee || !weapon.isMelee() || this.memory.hasWeaponOfType(weapon.weaponType)) continue;
            return weapon;
        }
        Weapon chosen = this.memory.getSeeReachableWeapon();
        if (!this.memory.hasWeaponOfType(chosen.weaponType)) {
            return chosen;
        }
        return null;
    }

    private Item chooseItem() {
        if (this.memory.getSeeAnyReachableWeapon()) {
            return this.chooseWeapon();
        }
        if (this.memory.getSeeAnyReachableArmor()) {
            return this.memory.getSeeReachableArmor();
        }
        if (this.memory.getSeeAnyReachableHealth()) {
            Health health = this.memory.getSeeReachableHealth();
            if (this.memory.getAgentHealth() < 100) {
                return health;
            }
            if (health.boostable) {
                return health;
            }
        }
        if (this.memory.getSeeAnyReachableAmmo() && this.memory.isAmmoSuitable(this.memory.getSeeReachableAmmo())) {
            return this.memory.getSeeAmmo();
        }
        return null;
    }

    private boolean seeAnyReachableItemAndWantIt() {
        this.choosenItem = this.memory.getSeeAnyReachableItem() ? this.chooseItem() : null;
        return this.choosenItem != null && Triple.distanceInSpace(this.memory.getAgentLocation(), this.choosenItem.location) > 20.0;
    }

    protected boolean canRunAlongMedKit() {
        this.choosenMedKits = this.gameMap.nearestHealth(10, 6);
        if (this.choosenMedKits.isEmpty()) {
            return false;
        }
        if (Triple.distanceInSpace(this.choosenMedKits.get((int)0).location, this.memory.getAgentLocation()) < 40.0) {
            if (this.choosenMedKits.size() > 2) {
                this.choosenMedKits.remove(0);
            }
            return false;
        }
        return true;
    }

    protected void stateMedKit() {
        this.log.log(Level.INFO, "Decision is: RUN_MED_KITS");
        if (!this.pathRestart) {
            this.pathRestart = true;
        }
        this.gameMap.runAroundItemsInTheMap(this.choosenMedKits, true);
    }

    protected void stateSeeItem() {
        this.log.log(Level.INFO, "Decision is: SEE_ITEM --- Running for: " + this.choosenItem.toString());
        if (!this.pathRestart) {
            this.pathRestart = true;
        }
        this.body.runToLocation(this.choosenItem.location);
        ++this.walkAttempts;
        if (this.walkAttempts > 10) {
            this.choosenItem = null;
            this.walkAttempts = 0;
        }
        this.running = true;
        this.jumped = false;
        this.pl = null;
    }

    protected void stateRunAroundItems() {
        this.log.log(Level.INFO, "Decision is: RUN_AROUND_ITEMS");
        if (this.pathRestart) {
            this.gameMap.restartPathToRunAlong();
            this.pathRestart = false;
        }
        this.gameMap.runAroundItemsInTheMap(this.itemsToRunAround, this.useAStar);
    }

    public static void main(String[] Args) {
        InventoryBot bot = new InventoryBot();
        boolean localParser = true;
        URI uri = null;
        try {
            uri = new URI("ut://192.168.1.2:3000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("URI creation failed, terminating.");
            System.exit(0);
        }
        AgentLauncher launcher = new AgentLauncher(bot, uri, localParser);
        launcher.setLogToScreen();
        launcher.launch();
    }
}

