/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.exampleBots;

import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.Client.BaseBot;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.AutoTraceRay;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;

public class AutoTestingBot
extends BaseBot {
    int counter = -1;
    ArrayList<Item> itemsToRunAround = null;
    boolean initialized = false;
    int strafeCounter = 0;

    public AutoTestingBot() {
        this.log.setLevel(Level.INFO);
        this.platformLog.setLevel(Level.INFO);
    }

    @Override
    protected void postPrepareAgent() {
        this.itemsToRunAround = new ArrayList();
        for (Weapon item : this.memory.getKnownWeapons()) {
            this.itemsToRunAround.add(item);
        }
        Collections.shuffle(this.itemsToRunAround);
    }

    @Override
    protected void doLogic() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.severe("Agent was ruthlessly interrupted during the sleep!");
            e.printStackTrace();
        }
        if (!this.memory.hasSelf()) {
            return;
        }
        switch (this.counter) {
            case -1: {
                this.log.info("KnownTest");
                if (this.memory.getKnownAmmos() != null) {
                    this.log.info("Ammos: " + this.memory.getKnownAmmos().toString());
                }
                if (this.memory.getKnownArmors() != null) {
                    this.log.info("Armors: " + this.memory.getKnownArmors().toString());
                }
                if (this.memory.getKnownWeapons() != null) {
                    this.log.info("Weapons: " + this.memory.getKnownWeapons().toString());
                }
                if (this.memory.getKnownHealths() != null) {
                    this.log.info("Healths: " + this.memory.getKnownHealths().toString());
                }
                ++this.counter;
                break;
            }
            case 0: {
                if (this.memory.numberOfWeapons() > 2) {
                    this.log.info("Gather at least 3 weapons");
                    ++this.counter;
                }
                this.gameMap.runAroundItemsInTheMap(this.itemsToRunAround, false);
                break;
            }
            case 1: {
                this.log.info("Throw current weapon");
                this.body.throwWeapon();
                ++this.counter;
                break;
            }
            case 2: {
                this.log.info("Rearm to best");
                this.body.changeToBestWeapon();
                ++this.counter;
                break;
            }
            case 3: {
                this.log.info("Print properties");
                this.log.info(this.memory.getAgentName());
                this.log.info(String.valueOf("Ammo: " + this.memory.getAgentAmmo()));
                this.log.info(String.valueOf("Armor: " + this.memory.getAgentArmor()));
                this.log.info(String.valueOf("Health: " + this.memory.getAgentHealth()));
                this.log.info(String.valueOf("Is Moving: " + this.memory.getAgentIsMoving()));
                this.log.info(String.valueOf("Score: " + this.memory.getAgentScore()));
                this.log.info(String.valueOf("Team: " + this.memory.getAgentTeam()));
                this.log.info(String.valueOf("Location: " + this.memory.getAgentLocation().toString()));
                this.log.info(String.valueOf("Rotation: " + this.memory.getAgentRotation().toString()));
                this.log.info(String.valueOf("Velocity: " + this.memory.getAgentVelocity().toString()));
                this.log.info(String.valueOf("Weapon: " + this.memory.getCurrentWeapon().toString()));
                ++this.counter;
                break;
            }
            case 4: {
                this.log.info("Send global message");
                this.body.sendGlobalMessage("I am alive");
                ++this.counter;
                break;
            }
            case 5: {
                this.log.info("Send team channel message");
                this.body.sendPrivateMessage("I am alive in the team");
                ++this.counter;
                break;
            }
            case 6: {
                this.log.info("Start recording");
                this.body.startRecording("myRecordTest");
                this.body.moveContinuous();
                ++this.counter;
                break;
            }
            case 7: {
                this.log.info("Pause the game");
                this.body.pauseTheGame();
                ++this.counter;
                break;
            }
            case 8: {
                this.log.info("Change name of the bot");
                this.body.configure(true, false, "MyTestingBot", false, 10.0);
                this.body.configureAutoTrace(true);
                this.body.restartAutoTraceRays();
                ++this.counter;
                break;
            }
            case 9: {
                this.log.info("Unpause the game");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    this.log.severe("Auto Testing Agent was interupted during the sleep");
                    e.printStackTrace();
                }
                this.body.unpauseTheGame();
                ++this.counter;
                break;
            }
            case 10: {
                this.log.info("Set walk");
                this.body.setWalk();
                ++this.counter;
                break;
            }
            case 11: {
                ++this.counter;
                break;
            }
            case 12: {
                ++this.counter;
                this.log.info("If see enemy, set run, print enemy score");
                if (this.memory.getSeeAnyEnemy()) {
                    Player plr = this.memory.getSeeEnemy();
                    this.log.info("Enemy's score: " + this.memory.getPlayerScore(plr.ID));
                    this.body.setRun();
                    ++this.counter;
                    break;
                }
                this.gameMap.runAroundItemsInTheMap(this.itemsToRunAround, false);
                break;
            }
            case 13: {
                this.log.info("AutoTraceTest");
                this.log.info("Agent name: " + this.memory.getAgentName());
                ArrayList<AutoTraceRay> traces = this.memory.getAutoTraces();
                this.log.info("Size of traces: " + String.valueOf(traces.size()));
                for (AutoTraceRay ray : traces) {
                    this.log.info(ray.toString());
                }
                ++this.counter;
                break;
            }
            case 14: {
                this.log.info("Add Rays");
                this.body.addRayToAutoTrace(410, new Triple(50.0, -10.0, 10.0), 300.0, true, false);
                this.body.addRayToAutoTrace(415, new Triple(10.0, -100.0, 10.0), 300.0, true, false);
                this.body.addRayToAutoTrace(417, new Triple(10.0, 10.0, -100.0), 300.0, true, false);
                this.body.addRayToAutoTrace(420, new Triple(-10010.0, 1000.0, 500.0), 300.0, true, false);
                ++this.counter;
                break;
            }
            case 15: {
                this.log.info("AutoTraceTest");
                ArrayList<AutoTraceRay> traces2 = this.memory.getAutoTraces();
                this.log.info("Size of traces: " + String.valueOf(traces2.size()));
                this.log.info("Trace IDs: " + this.memory.getAutoTraceIDs().toString());
                for (AutoTraceRay ray : traces2) {
                    this.log.info(ray.toString());
                }
                ++this.counter;
                break;
            }
            case 16: {
                this.log.info("Remove rays from autoTrace");
                this.body.removeAllRaysFromAutoTrace();
                ++this.counter;
                break;
            }
            case 17: {
                this.log.info("AutoTrace remove test");
                ArrayList<AutoTraceRay> traces3 = this.memory.getAutoTraces();
                this.log.info("Size of traces: " + String.valueOf(traces3.size()));
                this.log.info("Trace IDs: " + this.memory.getAutoTraceIDs().toString());
                for (AutoTraceRay ray : traces3) {
                    this.log.info(ray.toString());
                }
                ++this.counter;
                break;
            }
            case 18: {
                this.log.info("Shoot as much as possible: " + this.memory.getAgentAmmo());
                if (!this.memory.hasLoadedWeapon()) {
                    ++this.counter;
                }
                this.body.shoot(new Triple(10.0, 10.0, 10.0));
                break;
            }
            case 19: {
                this.log.info("Switch to another weapon");
                if (this.memory.hasAnyLoadedWeapon()) {
                    this.log.info("switching to weapon: " + this.memory.getAnyWeapon().toString());
                    this.body.changeWeapon(this.memory.getAnyWeapon());
                } else {
                    this.log.info("No weapon available");
                }
                ++this.counter;
                break;
            }
            case 20: {
                this.log.info("Repeat switching weapons");
                if (this.memory.hasAnyLoadedWeapon()) {
                    this.counter = 18;
                    break;
                }
                ++this.counter;
                break;
            }
            case 21: {
                if (this.memory.hasAnyLoadedWeapon()) {
                    ++this.counter;
                }
                if (!this.initialized) {
                    this.itemsToRunAround.clear();
                    this.log.info(this.memory.getKnownAmmos().toString());
                    for (Ammo it : this.memory.getKnownAmmos()) {
                        this.itemsToRunAround.add(it);
                    }
                    this.initialized = true;
                    this.log.info(this.itemsToRunAround.toString());
                }
                this.gameMap.runAroundItemsInTheMap(this.itemsToRunAround, false);
                break;
            }
            case 22: {
                this.log.info("Stop recording");
                this.body.stopRecording();
                this.initialized = false;
                this.log.info("Has Weapon");
                this.body.changeWeapon(this.memory.getAnyWeapon());
                ++this.counter;
                break;
            }
            case 23: {
                this.log.info("Weapon Again" + this.memory.getCurrentWeapon().toString());
                ++this.counter;
                break;
            }
            case 24: {
                this.log.info("Test STRAFE TO");
                Triple strafeTo = new Triple();
                strafeTo = Triple.subtract(this.memory.getAgentLocation(), this.memory.getAgentVelocity());
                NavPoint nav = this.memory.getSeeNavPoint();
                if (nav != null) {
                    this.body.strafeToLocation(nav.location, strafeTo);
                    this.log.info("Going to location: " + nav.location.toString() + ", strafing to location: " + strafeTo.toString());
                }
                ++this.strafeCounter;
                if (this.strafeCounter <= 30) break;
                ++this.counter;
                break;
            }
            case 25: {
                this.log.info("");
                ++this.counter;
                break;
            }
            default: {
                this.log.info("Testing successfully finished, end bot");
                this.stopAgentSoft();
            }
        }
    }

    @Override
    public void receiveMessage(RcvMsgEvent e) {
        switch (e.getMessage().getType()) {
            case BOT_KILLED: {
                this.counter = 0;
                break;
            }
            case MAP_FINISHED: {
                this.platformLog.warning("Map finished.");
                this.stopAgentSoft();
            }
        }
    }

    public static void main(String[] Args) {
        AutoTestingBot bot = new AutoTestingBot();
        boolean localParser = true;
        URI uri = null;
        try {
            uri = new URI("ut://localhost:4000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("URI creation failed, terminating.");
            System.exit(0);
        }
        AgentLauncher launcher = new AgentLauncher(bot, uri, localParser);
        launcher.setLogToScreen();
        launcher.launch();
    }
}

