/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.exampleBots;

import cz.cuni.pogamut.Client.BaseBot;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.exceptions.ConnectException;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AdvancedBot
extends BaseBot {
    Item choosenItem = null;
    boolean pathRestart = false;
    private boolean useAStar = false;
    private ArrayList<Item> itemsToRunAround = null;
    private Player enemy = null;
    private boolean jumped;

    public AdvancedBot() {
        this.log.setLevel(Level.INFO);
        this.platformLog.setLevel(Level.INFO);
    }

    @Override
    protected void postPrepareAgent() {
        this.itemsToRunAround = new ArrayList();
        for (Weapon item : this.memory.getKnownWeapons()) {
            this.itemsToRunAround.add(item);
        }
        Collections.shuffle(this.itemsToRunAround);
    }

    @Override
    protected void doLogic() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.severe("Agent was ruthlessly interrupted during the sleep!");
            e.printStackTrace();
        }
        if (!this.memory.hasSelf()) {
            return;
        }
        if (this.memory.getSeeAnyEnemy() && this.memory.hasLoadedWeapon()) {
            this.statePursue();
            return;
        }
        this.enemy = null;
        if (this.memory.isShooting()) {
            this.stateStopShooting();
            return;
        }
        if (this.memory.isBeingDamaged()) {
            this.stateHit();
            return;
        }
        if (this.seeAnyReachableItemAndWantIt()) {
            this.stateSeeItem();
            return;
        }
        this.stateRunAroundItems();
    }

    protected void statePursue() {
        this.log.log(Level.INFO, "Decision is: PURSUE");
        if (!this.pathRestart) {
            this.pathRestart = true;
        }
        if (this.enemy != null) {
            this.enemy = this.memory.getSeePlayer(this.enemy.ID);
            if (this.enemy == null && this.memory.isShooting()) {
                this.body.stopShoot();
            }
        }
        if (this.enemy == null) {
            this.enemy = this.memory.getSeeEnemy();
            if (this.enemy == null) {
                this.body.stop();
                this.body.stopShoot();
                return;
            }
        }
        if (!this.memory.isShooting()) {
            this.body.shoot(this.enemy);
        }
        if (this.memory.getAgentAmmo() == 0 && this.memory.hasLoadedWeapon()) {
            AddWeapon weapon = this.memory.getAnyWeapon();
            this.body.changeWeapon(weapon);
        }
        if (Triple.distanceInSpace(this.memory.getAgentLocation(), this.enemy.location) < 400.0) {
            if (this.memory.isMoving()) {
                this.body.stop();
            }
        } else {
            this.body.runToTarget(this.enemy);
            this.jumped = false;
        }
    }

    protected void stateStopShooting() {
        this.log.log(Level.INFO, "Decision is: STOP_SHOOTING");
        this.body.stopShoot();
    }

    protected void stateHit() {
        this.log.log(Level.INFO, "Decision is: HIT");
        this.body.turnHorizontal(355);
    }

    protected void stateWalking() {
        this.log.log(Level.INFO, "Decision is: WALKING");
        if (this.memory.isColliding()) {
            if (!this.jumped) {
                this.body.jump();
                this.jumped = true;
            } else {
                this.body.stop();
                this.jumped = false;
            }
        }
        if (this.memory.isFalling()) {
            this.body.sendGlobalMessage("I am flying like a bird:D!");
            this.log.info("I'm flying like an angel to the sky ... it's so high ... oh, I am high! :-)");
        }
        if (this.memory.isBumpingToAnotherActor()) {
            this.body.stop();
        }
    }

    private Weapon chooseWeapon() {
        ArrayList<Weapon> weapons = this.memory.getSeeReachableWeapons();
        for (Weapon weapon : weapons) {
            if (this.memory.getCurrentWeapon() == null) {
                return weapon;
            }
            if (this.memory.getCurrentWeapon().melee && !weapon.isMelee() && !this.memory.hasWeaponOfType(weapon.weaponType)) {
                return weapon;
            }
            if (this.memory.getCurrentWeapon().melee || !weapon.isMelee() || this.memory.hasWeaponOfType(weapon.weaponType)) continue;
            return weapon;
        }
        Weapon chosen = this.memory.getSeeReachableWeapon();
        if (!this.memory.hasWeaponOfType(chosen.weaponType)) {
            return chosen;
        }
        return null;
    }

    private Item chooseItem() {
        if (this.memory.getSeeAnyReachableWeapon()) {
            return this.chooseWeapon();
        }
        if (this.memory.getSeeAnyReachableArmor()) {
            return this.memory.getSeeReachableArmor();
        }
        if (this.memory.getSeeAnyReachableHealth() && this.memory.getAgentHealth() < 100) {
            return this.memory.getSeeReachableHealth();
        }
        if (this.memory.getSeeAnyReachableAmmo() && this.memory.isAmmoSuitable(this.memory.getSeeReachableAmmo())) {
            return this.memory.getSeeAmmo();
        }
        return null;
    }

    private boolean seeAnyReachableItemAndWantIt() {
        this.choosenItem = this.memory.getSeeAnyReachableItem() ? this.chooseItem() : null;
        return this.choosenItem != null && Triple.distanceInSpace(this.memory.getAgentLocation(), this.choosenItem.location) > 20.0;
    }

    protected void stateSeeItem() {
        this.log.log(Level.INFO, "Decision is: SEE_ITEM --- Running for: " + this.choosenItem.toString());
        if (!this.pathRestart) {
            this.pathRestart = true;
        }
        this.body.runToLocation(this.choosenItem.location);
        this.jumped = false;
    }

    protected void stateRunAroundItems() {
        this.log.log(Level.INFO, "Decision is: RUN_AROUND_ITEMS");
        if (this.pathRestart) {
            this.gameMap.restartPathToRunAlong();
            this.pathRestart = false;
        }
        this.gameMap.runAroundItemsInTheMap(this.itemsToRunAround, this.useAStar);
    }

    public static void main(String[] Args) {
        AdvancedBot bot = new AdvancedBot();
        boolean localParser = true;
        URI uri = null;
        try {
            uri = new URI("ut://10.3.20.250:3000");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("URI creation failed, terminating.");
            System.exit(0);
        }
        bot.log.getParent().removeHandler(bot.log.getParent().getHandlers()[0]);
        bot.log.getParent().addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.println(record.getSourceClassName() + " " + record.getSourceMethodName() + ": " + record.getMessage());
            }

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }
        });
        if (localParser) {
            try {
                bot.bindLocalParser(uri);
            }
            catch (IOException e1) {
                System.out.println(e1.getMessage());
                e1.printStackTrace();
                return;
            }
            catch (ConnectException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        } else {
            try {
                bot.bindRemoteParser(uri);
            }
            catch (ConnectException e) {
                e.printStackTrace();
                System.exit(1);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        bot.startAgent();
    }
}

