/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Parser;

import cz.cuni.pogamut.exceptions.CantCloseConnectionException;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.DisconnectException;
import cz.cuni.utils.ExceptionToString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class GameBotConnection {
    public static final String DEFAULT_ADDRESS = "localhost";
    public static final int DEFAULT_PORT = 3000;
    public static final int SOCKET_TIMEOUT = 2000;
    protected InetAddress serverAddress = null;
    protected int serverPort;
    private Socket socket = null;
    protected BufferedReader input = null;
    private PrintWriter output = null;
    private Logger log = null;
    private Logger rawDataLog = Logger.getAnonymousLogger();

    public Logger getRawDataLog() {
        return this.rawDataLog;
    }

    public GameBotConnection(String netAddress, int port, Logger log) throws UnknownHostException {
        this(netAddress, port, log, null);
    }

    public GameBotConnection(String netAddress, int port, Logger log, Logger rawDataLog) throws UnknownHostException {
        this.serverAddress = InetAddress.getByName(netAddress);
        this.serverPort = port;
        this.log = log;
        this.rawDataLog = rawDataLog;
    }

    public GameBotConnection(String netAddress, int port) throws UnknownHostException {
        this(netAddress, port, Logger.getAnonymousLogger());
    }

    public GameBotConnection(String netAddress) throws UnknownHostException {
        this(netAddress, 3000, Logger.getAnonymousLogger());
    }

    public GameBotConnection(String netAddress, Logger rawDataLog) throws UnknownHostException {
        this(netAddress, 3000, Logger.getAnonymousLogger(), rawDataLog);
    }

    public GameBotConnection() throws UnknownHostException {
        this(DEFAULT_ADDRESS, 3000, Logger.getLogger("GameBotConnection"));
    }

    public void connect() throws ConnectException {
        try {
            this.log.info("Connecting to GB: " + this.serverAddress + ":" + this.serverPort);
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.serverAddress, this.serverPort), 2000);
            this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.output = new PrintWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.log.severe(ExceptionToString.process("Can't connect to GameBot (" + this.serverAddress + ":" + this.serverPort + ")", e));
            throw new ConnectException("Can't connect to GameBot (" + this.serverAddress + ":" + this.serverPort + ") -> " + e.getMessage(), e);
        }
    }

    void disconnect() throws DisconnectException {
        if (!this.isConnected()) {
            return;
        }
        this.log.info("Disconnecting from GameBots.");
        try {
            this.input.close();
            this.output.close();
            this.socket.close();
        }
        catch (IOException e) {
            this.log.severe(ExceptionToString.process("Unable to disconnect from Gamebot", e));
            this.input = null;
            this.output = null;
            this.socket = null;
            throw new DisconnectException("Unable to disconnect from Gamebot -> " + e.getMessage(), e);
        }
        this.input = null;
        this.output = null;
        this.socket = null;
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return true;
        }
        if (this.socket.isClosed()) {
            return true;
        }
        return true;
    }

    public synchronized void send(String msg) throws CantWriteException {
        try {
            this.rawDataLog.info(">>> " + msg);
            this.output.println(msg);
            this.output.flush();
        }
        catch (NullPointerException e) {
            this.log.severe(ExceptionToString.process("Unable to send data to GameBot, connection closed.", e));
            throw new CantWriteException("Unable to send data to GameBot, connection closed.");
        }
        catch (Exception e) {
            this.log.severe(ExceptionToString.process("Unable to send data to GameBot.", e));
            throw new CantWriteException("Unable to send data to GameBot -> " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CantCloseConnectionException {
        Socket socket = this.socket;
        synchronized (socket) {
            if (this.socket.isClosed()) {
                return;
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new CantCloseConnectionException("Can't close connection -> " + e.getMessage(), e);
            }
        }
    }

    private class BufferedReaderForLog
    extends BufferedReader {
        private StringBuffer lastLine;
        private String lineSeparator;

        public BufferedReaderForLog(InputStreamReader stream) {
            super(stream);
            this.lastLine = new StringBuffer(255);
            this.lineSeparator = System.getProperty("line.separator");
        }

        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            int result = super.read(cbuf, offset, length);
            if (result < 0) {
                return result;
            }
            boolean next = false;
            int i = 0;
            while (i < result) {
                next = false;
                for (int j = 0; j < this.lineSeparator.length(); ++j) {
                    if (this.lineSeparator.charAt(j) != cbuf[offset + i]) continue;
                    ++i;
                    if (next) continue;
                    GameBotConnection.this.rawDataLog.info("<<< " + this.lastLine.toString());
                    this.lastLine = new StringBuffer(255);
                    next = true;
                }
                if (next) continue;
                this.lastLine.append(cbuf[offset + i]);
                ++i;
            }
            return result;
        }
    }
}

