/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.utils.HashCode;
import java.io.Serializable;

public class Triple
implements Cloneable,
Serializable {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    private final int hashCode;

    private int getHashCode() {
        HashCode hc = new HashCode();
        hc.add(this.x);
        hc.add(this.y);
        hc.add(this.z);
        return hc.getHash();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Triple() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.hashCode = this.getHashCode();
    }

    public Triple(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.hashCode = this.getHashCode();
    }

    public Triple(Triple t) {
        this.x = t.x;
        this.y = t.y;
        this.z = t.z;
        this.hashCode = this.getHashCode();
    }

    public Object clone() {
        return new Triple(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple sec = (Triple)obj;
        return sec.x == this.x && sec.y == this.y && sec.z == this.z;
    }

    public String toString() {
        String temp = String.valueOf(this.x) + ',' + String.valueOf(this.y) + ',' + String.valueOf(this.z);
        return temp;
    }

    public void setTriple(Triple newTriple) {
        this.x = newTriple.x;
        this.y = newTriple.y;
        this.z = newTriple.z;
    }

    public static Triple add(Triple a, Triple b) {
        Triple sum = new Triple();
        sum.x = a.x + b.x;
        sum.y = a.y + b.y;
        sum.z = a.z + b.z;
        return sum;
    }

    public static Triple subtract(Triple a, Triple b) {
        Triple difference = new Triple();
        difference.x = a.x - b.x;
        difference.y = a.y - b.y;
        difference.z = a.z - b.z;
        return difference;
    }

    public static Triple multiplyByNumber(Triple a, Double b) {
        return new Triple(a.x * b, a.y * b, a.z * b);
    }

    public static double distanceInSpace(Triple a, Triple b) {
        double distance = 0.0;
        distance = Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0);
        distance = Math.sqrt(distance);
        return distance;
    }

    public static double distanceInPlane(Triple a, Triple b) {
        double distance = 0.0;
        distance = Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0);
        distance = Math.sqrt(distance);
        return distance;
    }

    public static double vectorSize(Triple a) {
        double distance = 0.0;
        distance = Math.pow(a.x, 2.0) + Math.pow(a.y, 2.0) + Math.pow(a.z, 2.0);
        distance = Math.sqrt(distance);
        return distance;
    }

    public boolean zero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }
}

