/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.ConfigChange;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.PlayerJoinsGame;
import cz.cuni.pogamut.MessageObjects.PlayerLeft;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.io.Serializable;

public class Player
extends MessageObject
implements Cloneable,
Serializable {
    public Triple location = null;
    public Triple rotation = null;
    public Triple velocity = null;
    public int team;
    public String weapon = null;
    public boolean reachable = false;
    public int shooting = 0;
    public String name = null;
    public boolean autoTrace = false;
    public boolean invulnerable = false;
    public boolean manualSpawn = false;
    public double visionTime = 1.0;
    public boolean showDebug = false;
    public boolean showFocalPoint = false;
    public boolean drawTraceLines = false;

    @Override
    public boolean hasID() {
        return true;
    }

    public Player(PlayerJoinsGame fake) {
        this.UnrealID = fake.UnrealID;
        this.ID = fake.ID;
        this.name = fake.name;
    }

    public Player(PlayerLeft fake) {
        this.UnrealID = fake.UnrealID;
        this.ID = fake.ID;
        this.name = fake.name;
    }

    public Player(String UnrealID, int ID) {
        super(MessageType.PLAYER, ID, UnrealID, false);
    }

    public Player(int ID, String UnrealID, Triple location, Triple rotation, Triple velocity, int team, String weapon, boolean reachable, boolean visible, String name, boolean autoTrace, boolean invulnerable, boolean manualSpawn, double visionTime, boolean showDebug, boolean showFocalPoint, boolean drawTraceLines) {
        super(MessageType.PLAYER, ID, UnrealID, visible);
        this.location = location;
        this.rotation = rotation;
        this.velocity = velocity;
        this.team = team;
        this.weapon = weapon;
        this.reachable = reachable;
        this.name = name;
        this.autoTrace = autoTrace;
        this.invulnerable = invulnerable;
        this.manualSpawn = manualSpawn;
        this.visionTime = visionTime;
        this.showDebug = showDebug;
        this.showFocalPoint = showFocalPoint;
        this.drawTraceLines = drawTraceLines;
    }

    public Player() {
        super(MessageType.PLAYER);
    }

    public Player(Player original) {
        this(original.ID, original.UnrealID, original.location, original.rotation, original.velocity, original.team, original.weapon, original.reachable, original.visible, original.name, original.autoTrace, original.invulnerable, original.manualSpawn, original.visionTime, original.showDebug, original.showFocalPoint, original.drawTraceLines);
    }

    @Override
    public Object clone() {
        return new Player(this.ID, this.UnrealID, this.location, this.rotation, this.velocity, this.team, this.weapon, this.reachable, this.visible, this.name, this.autoTrace, this.invulnerable, this.manualSpawn, this.visionTime, this.showDebug, this.showFocalPoint, this.drawTraceLines);
    }

    public Triple getPlayerLocation() {
        return this.location;
    }

    public Triple getPlayerRotation() {
        return this.rotation;
    }

    public Triple getPlayerVelocity() {
        return this.velocity;
    }

    public int getPlayerTeam() {
        return this.team;
    }

    public String getPlayerWeapon() {
        return this.weapon;
    }

    public boolean getPlayerReachability() {
        return this.reachable;
    }

    @Override
    public boolean diff(MessageObject old) {
        int same = 0;
        Player oldPlayer = (Player)old;
        if (this.UnrealID == oldPlayer.UnrealID) {
            this.UnrealID = null;
            ++same;
        }
        if (this.location.equals(oldPlayer.location)) {
            this.location = null;
            ++same;
        } else {
            oldPlayer.location = this.location;
        }
        if (this.rotation.equals(oldPlayer.rotation)) {
            this.rotation = null;
            ++same;
        } else {
            oldPlayer.rotation = this.rotation;
        }
        if (this.velocity.equals(oldPlayer.velocity)) {
            this.velocity = null;
            ++same;
        } else {
            oldPlayer.velocity = this.velocity;
        }
        if (this.weapon.equals(oldPlayer.weapon)) {
            this.weapon = null;
            ++same;
        } else {
            oldPlayer.weapon = this.weapon;
        }
        if (this.reachable == oldPlayer.reachable) {
            ++same;
        } else {
            oldPlayer.reachable = this.reachable;
        }
        if (this.visible == oldPlayer.visible) {
            ++same;
        } else {
            oldPlayer.visible = this.visible;
        }
        if (this.name.equals(oldPlayer.name)) {
            ++same;
        } else {
            oldPlayer.name = this.name;
        }
        return same != 8;
    }

    @Override
    public void update(MessageObject newMsgObj) {
        Player newPlayer = (Player)newMsgObj;
        if (newPlayer.UnrealID != null) {
            this.UnrealID = newPlayer.UnrealID;
        }
        if (newPlayer.location != null) {
            this.location = newPlayer.location;
        }
        if (newPlayer.rotation != null) {
            this.rotation = newPlayer.rotation;
        }
        if (newPlayer.velocity != null) {
            this.velocity = newPlayer.velocity;
        }
        if (newPlayer.weapon != null) {
            this.weapon = newPlayer.weapon;
        }
        if (newPlayer.name != null) {
            this.name = newPlayer.name;
        }
        this.reachable = newPlayer.reachable;
        this.visible = newPlayer.visible;
    }

    public void updateConfigChange(ConfigChange change) {
        this.name = change.name;
        this.autoTrace = change.autoTrace;
        this.invulnerable = change.invulnerable;
        this.manualSpawn = change.manualSpawn;
        this.visionTime = change.visionTime;
        this.showDebug = change.showDebug;
        this.showFocalPoint = change.showFocalPoint;
        this.drawTraceLines = change.drawTraceLines;
    }

    @Override
    public String toString() {
        String temp = super.toString();
        if (this.location != null) {
            temp = temp + ", location: " + this.location.toString();
        }
        if (this.rotation != null) {
            temp = temp + ", rotation: " + this.rotation.toString();
        }
        if (this.velocity != null) {
            temp = temp + ", velocity: " + this.velocity.toString();
        }
        if (this.weapon != null) {
            temp = temp + ", weapon: " + this.weapon;
        }
        temp = this.reachable ? temp + ", is reachable" : temp + ", is not reachable ";
        temp = this.shooting > 0 ? temp + ", is shooting" : temp + ", is not shooting";
        temp = temp + ", team: " + String.valueOf(this.team);
        return temp;
    }
}

