/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import java.util.ArrayList;

public enum NeighNavFlag {
    WALK(1),
    FLY(2),
    SWIM(4),
    JUMP(8),
    DOOR(16),
    SPECIAL(32),
    LADDER(64),
    PROSCRIBED(128),
    FORCED(256),
    PLAYERONLY(512);

    private int flag = 0;

    private NeighNavFlag(int flag) {
        this.flag = flag;
    }

    public int get() {
        return this.flag;
    }

    public boolean isSet(int flag) {
        return (this.flag & flag) != 0;
    }

    public static ArrayList<NeighNavFlag> getFlags(int flags) {
        ArrayList<NeighNavFlag> list = new ArrayList<NeighNavFlag>();
        for (NeighNavFlag flag : NeighNavFlag.values()) {
            if ((flags & flag.get()) == 0) continue;
            list.add(flag);
        }
        return list;
    }

    public static String getFlagsString(int flags) {
        ArrayList<NeighNavFlag> allFlags = NeighNavFlag.getFlags(flags);
        String str = "";
        if (allFlags.size() == 0) {
            return "none";
        }
        str = allFlags.get(0).name();
        allFlags.remove(0);
        for (NeighNavFlag flag : allFlags) {
            str = ", " + flag.name();
        }
        return str;
    }
}

