/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.io.Serializable;

public class Item
extends MessageObject
implements Serializable,
Cloneable {
    public Triple location = null;
    public boolean reachable = false;
    public String cls = null;
    public String humanName = null;
    public NavPoint navPoint = null;

    public Item(int ID, String UnrealID, String cls, Triple location, boolean reachable, boolean visible) {
        super(MessageType.ITEM, ID, UnrealID, visible);
        this.location = location;
        this.reachable = reachable;
    }

    public Item(MessageType itemType, int ID, String UnrealID, String cls, Triple location, boolean reachable, boolean visible, NavPoint navPoint) {
        this(itemType, ID, UnrealID, cls, location, reachable, visible, navPoint, null);
    }

    public Item(MessageType itemType, int ID, String UnrealID, String cls, Triple location, boolean reachable, boolean visible, NavPoint navPoint, String humanName) {
        super(itemType, ID, UnrealID, visible);
        this.location = location;
        this.reachable = reachable;
        this.cls = cls;
        this.navPoint = navPoint;
        this.humanName = humanName;
    }

    public Item(Item original) {
        this(original.type, original.ID, original.getUnrealID(), original.cls, original.location, original.reachable, original.visible, original.navPoint, original.humanName);
    }

    @Override
    public Object clone() {
        return new Item(this.type, this.ID, this.getUnrealID(), this.cls, this.location, this.reachable, this.visible, this.navPoint, this.humanName);
    }

    public Item(MessageType type) {
        super(type);
    }

    public Item() {
        super(MessageType.ITEM);
    }

    @Override
    public String toString() {
        String str = super.toString() + ", Location " + this.location.toString() + ", Reachable " + this.reachable + ", Class " + this.cls;
        str = this.navPoint != null ? str + ", NavPoint: " + this.navPoint.UnrealID : str + ", NavPoint: null";
        return str;
    }

    @Override
    public boolean hasID() {
        return true;
    }

    @Override
    public boolean diff(MessageObject old) {
        Item oldItem = (Item)old;
        boolean changed = false;
        if (oldItem.location.equals(this.location)) {
            this.location = null;
        } else {
            oldItem.location = this.location;
            changed = true;
        }
        if (oldItem.reachable != this.reachable) {
            oldItem.reachable = this.reachable;
            changed = true;
        }
        return changed;
    }

    @Override
    public void update(MessageObject newMsgObj) {
        Item newItem = (Item)newMsgObj;
        if (newMsgObj.UnrealID != null) {
            this.UnrealID = newItem.UnrealID;
        }
        if (newItem.location != null) {
            this.location = newItem.location;
        }
        if (newItem.navPoint != null) {
            this.navPoint = newItem.navPoint;
        }
        this.reachable = newItem.reachable;
    }
}

